/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.PdfPageData;

public class PdfPageFormat {
    private static Set<PageFormat> availablePaper;

    public PdfPageFormat() {
        throw new AssertionError((Object)"PdfPageFormat cannot be instanced.  Use factory methods.");
    }

    public static final PageFormat createPdfPageFormat(MediaSizeName mediaSizeName, PrintService printingDevice) {
        int i;
        int useArea;
        boolean testFlag = false;
        if (printingDevice == null) {
            printingDevice = PrintServiceLookup.lookupDefaultPrintService();
        }
        if (testFlag && printingDevice == null) {
            System.out.println("Print Device is null");
        }
        PageFormat pdfPageFormat = new PageFormat();
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        if (mediaSize == null) {
            mediaSize = MediaSize.getMediaSizeForName(PdfPageFormat.getDefaultMediaSizeName(printingDevice));
        }
        if (testFlag && mediaSize == null) {
            System.out.println("Media Size is null");
        }
        float xSize = mediaSize.getX(25400) * 72.0f;
        float ySize = mediaSize.getY(25400) * 72.0f;
        Paper pdfPaper = new Paper();
        pdfPaper.setSize(xSize, ySize);
        MediaPrintableArea area = (MediaPrintableArea)printingDevice.getDefaultAttributeValue(MediaPrintableArea.class);
        if (testFlag && area == null) {
            System.out.println("Area is null");
        }
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
        attributes.add(mediaSizeName);
        MediaPrintableArea[] areas = (MediaPrintableArea[])printingDevice.getSupportedAttributeValues(MediaPrintableArea.class, null, attributes);
        if (testFlag && areas == null) {
            System.out.println("Printable Area array is null");
        }
        if (areas[useArea = 0] == null) {
            i = 0;
            while (i != areas.length && areas[useArea] == null) {
                useArea = i++;
            }
        }
        float[] imagable = areas[useArea].getPrintableArea(25400);
        i = 0;
        while (i < 4) {
            int n = i++;
            imagable[n] = imagable[n] * 72.0f;
        }
        if (imagable[2] + imagable[0] > xSize) {
            imagable[2] = xSize - imagable[0];
        }
        if (imagable[3] + imagable[1] > ySize) {
            imagable[3] = ySize - imagable[1];
        }
        pdfPaper.setImageableArea(imagable[0], imagable[1], imagable[2], imagable[3]);
        pdfPageFormat.setPaper(pdfPaper);
        return pdfPageFormat;
    }

    public static PageFormat getDefaultPage(PrintService printingDevice) {
        if (printingDevice == null) {
            printingDevice = PrintServiceLookup.lookupDefaultPrintService();
        }
        return PdfPageFormat.createPdfPageFormat(PdfPageFormat.getDefaultMediaSizeName(printingDevice), printingDevice);
    }

    public static MediaSizeName getDefaultMediaSizeName(PrintService printingDevice) {
        MediaSizeName size = (MediaSizeName)printingDevice.getDefaultAttributeValue(MediaSizeName.class);
        if (size == null || MediaSize.getMediaSizeForName(size) == null) {
            Locale locale = Locale.getDefault();
            size = locale.equals(Locale.UK) ? MediaSizeName.ISO_A4 : (locale.equals(Locale.US) ? MediaSizeName.NA_LETTER : MediaSizeName.ISO_A4);
        }
        return size;
    }

    public static void findPrinterPapers(PrintService printingDevice) {
        Media[] res;
        availablePaper = new HashSet<PageFormat>();
        if (printingDevice == null) {
            printingDevice = PrintServiceLookup.lookupDefaultPrintService();
        }
        for (Media m : res = (Media[])printingDevice.getSupportedAttributeValues(Media.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null)) {
            MediaSize size;
            if (!(m instanceof MediaSizeName) || (size = MediaSize.getMediaSizeForName((MediaSizeName)m)) == null) continue;
            availablePaper.add(PdfPageFormat.createPdfPageFormat((MediaSizeName)m, printingDevice));
        }
    }

    public static PageFormat getPageFormat(int p, PdfDecoder pdfDecoder) {
        PdfPageData pageData = pdfDecoder.getPdfPageData();
        float cropW = pageData.getCropBoxWidth(p);
        float cropH = pageData.getCropBoxHeight(p);
        PageFormat result = PdfPageFormat.getAppropriatePageFormat(cropW, cropH);
        return result;
    }

    private static PageFormat getAppropriatePageFormat(float cropW, float cropH) {
        if (availablePaper == null) {
            PdfPageFormat.findPrinterPapers(null);
        }
        PageFormat result = null;
        for (PageFormat pf : availablePaper) {
            result = PdfPageFormat.getClosestPageFormat(result, pf, cropW, cropH);
        }
        if (result == null) {
            result = PdfPageFormat.getDefaultPage(null);
        }
        return result;
    }

    private static PageFormat getClosestPageFormat(PageFormat original, PageFormat newFormat, float cropW, float cropH) {
        double cropShortSide;
        double newLongSide = newFormat.getHeight() > newFormat.getWidth() ? newFormat.getHeight() : newFormat.getWidth();
        double newShortSide = newFormat.getHeight() < newFormat.getWidth() ? newFormat.getHeight() : newFormat.getWidth();
        double cropLongSide = cropH > cropW ? (double)cropH : (double)cropW;
        double d = cropShortSide = cropH < cropW ? (double)cropH : (double)cropW;
        if (newShortSide >= cropShortSide && newLongSide >= cropLongSide) {
            double origShortSide;
            if (original == null) {
                PageFormat result = (PageFormat)newFormat.clone();
                return result;
            }
            double origLongSide = original.getHeight() > original.getWidth() ? original.getHeight() : original.getWidth();
            double d2 = origShortSide = original.getHeight() < original.getWidth() ? original.getHeight() : original.getWidth();
            if (origLongSide + origShortSide > newShortSide + newLongSide) {
                PageFormat result = (PageFormat)newFormat.clone();
                return result;
            }
        }
        return original;
    }
}

