/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.sun.pdfview.font.FlPoint;
import com.sun.pdfview.font.FontSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TestType1CFont
extends JPanel
implements KeyListener {
    int[] encoding = new int[256];
    int[] glyphnames;
    String[] names;
    HashMap<String, GlyphData> charset = new HashMap();
    ArrayList<String> charnames = new ArrayList();
    int charcounter = -1;
    byte[] data;
    int pos;
    byte[][] subrs;
    float[] stack = new float[100];
    int stackptr = 0;
    AffineTransform at = new AffineTransform(0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f);
    int num;
    float fnum;
    int type;
    static int CMD = 0;
    static int NUM = 1;
    static int FLT = 2;
    GlyphData showing;
    String showname;
    Font gfont = new Font("Sans-serif", 0, 24).deriveFont(AffineTransform.getScaleInstance(1.0, -1.0));
    Color fillColor = new Color(224, 255, 255);
    int charstringtype = 2;
    float[] temps = new float[32];
    int charsetbase = 0;
    int encodingbase = 0;
    int charstringbase = 0;
    int privatebase = 0;
    int privatesize = 0;
    int gsubrbase = 0;
    int lsubrbase = 0;
    int gsubrsoffset = 0;
    int lsubrsoffset = 0;
    int defaultWidthX = 0;
    int nominalWidthX = 0;
    int nglyphs = 1;

    @Override
    public boolean isRequestFocusEnabled() {
        return true;
    }

    public TestType1CFont(InputStream inputStream) throws IOException {
        int n;
        this.setPreferredSize(new Dimension(800, 800));
        this.addKeyListener(this);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        int n2 = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        byte[] byArray = new byte[32000];
        while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) >= 0) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            arrayList.add(byArray2);
            n2 += n;
            byArray = new byte[32000];
        }
        this.data = new byte[n2];
        n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            byte[] byArray3 = (byte[])arrayList.get(i);
            System.arraycopy(byArray3, 0, this.data, n, byArray3.length);
            n += byArray3.length;
        }
        this.pos = 0;
        this.parse();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 39) {
            ++this.charcounter;
            if (this.charcounter >= this.charnames.size()) {
                this.charcounter = 0;
            }
            this.showing = this.readGlyph(this.charnames.get(this.charcounter));
        } else if (keyEvent.getKeyCode() == 37) {
            --this.charcounter;
            if (this.charcounter < 0) {
                this.charcounter = this.charnames.size() - 1;
            }
            this.showing = this.readGlyph(this.charnames.get(this.charcounter));
        } else {
            char c = keyEvent.getKeyChar();
            this.showing = this.readGlyph(FontSupport.stdNames[FontSupport.standardEncoding[c & 0xFF]]);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        AffineTransform affineTransform = new AffineTransform(0.5, 0.0, 0.0, -0.5, 30.0, (double)(this.getHeight() * 3 / 4));
        graphics2D.transform(affineTransform);
        graphics2D.setColor(Color.black);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.showing != null) {
            this.showing.draw(graphics2D);
        }
    }

    private void printData() {
        char[] cArray = new char[17];
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            int n2 = this.data[i] & 0xFF;
            cArray[n++] = n2 == 0 ? 46 : (n2 < 32 || n2 >= 127 ? 63 : (char)n2);
            if (n2 < 16) {
                System.out.print("0" + Integer.toHexString(n2));
            } else {
                System.out.print(Integer.toHexString(n2));
            }
            if ((i & 0xF) == 15) {
                System.out.println("      " + new String(cArray));
                n = 0;
                continue;
            }
            if ((i & 7) == 7) {
                System.out.print("  ");
                cArray[n++] = 32;
                continue;
            }
            if ((i & 1) != 1) continue;
            System.out.print(" ");
        }
        System.out.println();
    }

    private int readNext(boolean bl) {
        this.num = this.data[this.pos++] & 0xFF;
        if (this.num == 30 && !bl) {
            this.readFNum();
            this.type = FLT;
            return this.type;
        }
        if (this.num == 28) {
            this.num = (this.data[this.pos] << 8) + (this.data[this.pos + 1] & 0xFF);
            this.pos += 2;
            this.type = NUM;
            return this.type;
        }
        if (this.num == 29 && !bl) {
            this.num = (this.data[this.pos] & 0xFF) << 24 | (this.data[this.pos + 1] & 0xFF) << 16 | (this.data[this.pos + 2] & 0xFF) << 8 | this.data[this.pos + 3] & 0xFF;
            this.pos += 4;
            this.type = NUM;
            return this.type;
        }
        if (this.num == 12) {
            this.num = 1000 + (this.data[this.pos++] & 0xFF);
            this.type = CMD;
            return this.type;
        }
        if (this.num < 32) {
            this.type = CMD;
            return this.type;
        }
        if (this.num < 247) {
            this.num -= 139;
            this.type = NUM;
            return this.type;
        }
        if (this.num < 251) {
            this.num = (this.num - 247) * 256 + (this.data[this.pos++] & 0xFF) + 108;
            this.type = NUM;
            return this.type;
        }
        if (this.num < 255) {
            this.num = -(this.num - 251) * 256 - (this.data[this.pos++] & 0xFF) - 108;
            this.type = NUM;
            return this.type;
        }
        if (!bl) {
            this.printData();
            throw new RuntimeException("Got a 255 code while reading dict");
        }
        this.fnum = (float)((this.data[this.pos] & 0xFF) << 24 | (this.data[this.pos + 1] & 0xFF) << 16 | (this.data[this.pos + 2] & 0xFF) << 8 | this.data[this.pos + 3] & 0xFF) / 65536.0f;
        this.pos += 4;
        this.type = FLT;
        return this.type;
    }

    public void readFNum() {
        float f = 0.0f;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        float f2 = 1.0f;
        byte by = this.data[this.pos++];
        while (true) {
            if (by == -35) {
                by = this.data[this.pos++];
            }
            int n3 = by >> 4 & 0xF;
            by = (byte)(by << 4 | 0xD);
            if (n3 < 10) {
                if (n != 0) {
                    n2 = n2 * 10 + n3;
                    continue;
                }
                if (f2 == 1.0f) {
                    f = f * 10.0f + (float)n3;
                    continue;
                }
                f += (float)n3 * f2;
                f2 /= 10.0f;
                continue;
            }
            if (n3 == 10) {
                f2 = 0.1f;
                continue;
            }
            if (n3 == 11) {
                n = 1;
                continue;
            }
            if (n3 == 12) {
                n = -1;
                continue;
            }
            if (n3 != 14) break;
            bl = true;
        }
        this.fnum = (float)(bl ? -1 : 1) * f * (float)Math.pow(10.0, n2 * n);
    }

    private int readInt(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 8 | this.data[this.pos++] & 0xFF;
        }
        return n2;
    }

    private int readByte() {
        return this.data[this.pos++] & 0xFF;
    }

    public int getIndexSize(int n) {
        int n2 = this.pos;
        this.pos = n;
        int n3 = this.readInt(2);
        if (n3 == 0) {
            return 2;
        }
        int n4 = this.readByte();
        this.pos += n3 * n4;
        int n5 = this.readInt(n4);
        this.pos = n2;
        return 2 + (n3 + 1) * n4 + n5;
    }

    public Range getIndexEntry(int n, int n2) {
        int n3 = this.pos;
        this.pos = n;
        int n4 = this.readInt(2);
        int n5 = this.readByte();
        this.pos += n5 * n2;
        int n6 = this.readInt(n5);
        Range range = new Range(n6 + 2 + n + n5 * (n4 + 1), this.readInt(n5) - n6);
        this.pos = n3;
        return range;
    }

    private void readDict(Range range) {
        this.pos = range.getStart();
        while (this.pos < range.getEnd()) {
            int n = this.readCommand(false);
            if (n == 1006) {
                this.charstringtype = (int)this.stack[0];
            } else if (n == 1007) {
                this.at = this.stackptr == 4 ? new AffineTransform(this.stack[0], this.stack[1], this.stack[2], this.stack[3], 0.0f, 0.0f) : new AffineTransform(this.stack[0], this.stack[1], this.stack[2], this.stack[3], this.stack[4], this.stack[5]);
            } else if (n == 15) {
                this.charsetbase = (int)this.stack[0];
            } else if (n == 16) {
                this.encodingbase = (int)this.stack[0];
            } else if (n == 17) {
                this.charstringbase = (int)this.stack[0];
            } else if (n == 18) {
                this.privatesize = (int)this.stack[0];
                this.privatebase = (int)this.stack[1];
            } else if (n == 19) {
                this.lsubrbase = (int)this.stack[0];
                this.lsubrsoffset = this.calcoffset(this.lsubrbase);
            } else if (n == 20) {
                this.defaultWidthX = (int)this.stack[0];
            } else if (n == 21) {
                this.nominalWidthX = (int)this.stack[0];
            }
            this.stackptr = 0;
        }
    }

    private int readCommand(boolean bl) {
        while (true) {
            int n;
            if ((n = this.readNext(bl)) == CMD) {
                System.out.print("CMD= " + this.num + ", args=");
                for (int i = 0; i < this.stackptr; ++i) {
                    System.out.print(" " + this.stack[i]);
                }
                System.out.println();
                return this.num;
            }
            this.stack[this.stackptr++] = n == NUM ? (float)this.num : this.fnum;
        }
    }

    private void readEncodingData(int n) {
        if (n == 0) {
            System.out.println("**** STANDARD ENCODING!");
        } else if (n == 1) {
            System.out.println("**** EXPERT ENCODING!");
        } else {
            this.pos = n;
            int n2 = this.readByte();
            if ((n2 & 0x7F) == 0) {
                System.out.println("**** Type 0 Encoding:");
                int n3 = this.readByte();
                for (int i = 1; i < n3 + 1; ++i) {
                    this.encoding[i] = this.readByte();
                    System.out.println("Encoding[" + i + "] = " + this.encoding[i]);
                }
            } else if ((n2 & 0x7F) == 1) {
                System.out.println("**** Type 1 Encoding:");
                int n4 = this.readByte();
                int n5 = 0;
                for (int i = 0; i < n4; ++i) {
                    int n6 = this.readByte();
                    int n7 = this.readByte();
                    int n8 = n6;
                    while (n8 < n6 + n7 + 1) {
                        System.out.println("Encoding[" + n5 + "] = " + n8);
                        this.encoding[n5++] = n8++;
                    }
                }
            } else {
                System.out.println("Bad encoding type: " + n2);
            }
        }
    }

    private void readGlyphNames(int n) {
        block10: {
            int n2;
            block11: {
                block9: {
                    if (n == 0) {
                        System.out.println("**** Identity glyphNames");
                        this.glyphnames = new int[229];
                        for (int i = 0; i < this.glyphnames.length; ++i) {
                            this.glyphnames[i] = i;
                        }
                        return;
                    }
                    if (n == 1) {
                        System.out.println("**** Type1CExpertCharset glyphNames");
                        this.glyphnames = FontSupport.type1CExpertCharset;
                        return;
                    }
                    if (n == 2) {
                        System.out.println("**** Type1CExpertSubCharset glyphNames");
                        this.glyphnames = FontSupport.type1CExpertSubCharset;
                        return;
                    }
                    System.out.print("**** Custom glyphNames Type ");
                    this.glyphnames = new int[this.nglyphs];
                    this.glyphnames[0] = 0;
                    this.pos = n;
                    n2 = this.readByte();
                    if (n2 != 0) break block9;
                    System.out.println("0");
                    for (int i = 1; i < this.nglyphs; ++i) {
                        this.glyphnames[i] = this.readInt(2);
                        System.out.println("glyphnames[" + i + "] = " + this.glyphnames[i]);
                    }
                    break block10;
                }
                if (n2 != 1) break block11;
                System.out.println("1");
                int n3 = 1;
                while (n3 < this.nglyphs) {
                    int n4 = this.readInt(2);
                    int n5 = this.readByte() + 1;
                    for (int i = 0; i < n5; ++i) {
                        System.out.println("glyphnames[" + n3 + "] = " + n4);
                        this.glyphnames[n3++] = n4++;
                    }
                }
                break block10;
            }
            if (n2 != 2) break block10;
            System.out.println("2");
            int n6 = 1;
            while (n6 < this.nglyphs) {
                int n7 = this.readInt(2);
                int n8 = this.readInt(2) + 1;
                for (int i = 0; i < n8; ++i) {
                    System.out.println("glyphnames[" + n6 + "] = " + n7);
                    this.glyphnames[n6++] = n7++;
                }
            }
        }
    }

    private void readNames(int n) {
        this.pos = n;
        int n2 = this.readInt(2);
        this.names = new String[n2];
        for (int i = 0; i < n2; ++i) {
            Range range = this.getIndexEntry(n, i);
            this.names[i] = new String(this.data, range.getStart(), range.getLen());
            System.out.println("Read name: " + i + " from " + range.getStart() + " to " + range.getEnd() + ": " + this.safe(this.names[i]));
        }
    }

    private void parse() {
        int n = this.readByte();
        int n2 = this.readByte();
        int n3 = this.readByte();
        int n4 = this.readByte();
        int n5 = n3;
        int n6 = n5 + this.getIndexSize(n5);
        int n7 = n6 + this.getIndexSize(n6);
        this.gsubrbase = n7 + this.getIndexSize(n7);
        this.gsubrsoffset = this.calcoffset(this.gsubrbase);
        this.readNames(n7);
        this.pos = n6;
        if (this.readInt(2) != 1) {
            this.printData();
            throw new RuntimeException("More than one font in this file!");
        }
        System.out.println("TOPDICT[0]:");
        this.readDict(this.getIndexEntry(n6, 0));
        System.out.println("PRIVATE DICT:");
        this.readDict(new Range(this.privatebase, this.privatesize));
        this.pos = this.charstringbase;
        this.nglyphs = this.readInt(2);
        System.out.println("GLYPHNAMES:");
        this.readGlyphNames(this.charsetbase);
        System.out.println("ENCODING:");
        this.readEncodingData(this.encodingbase);
        System.out.println("GLYPHS:");
        this.readGlyphs(this.charstringbase);
    }

    private String safe(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c < '\u0080') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("<" + c + ">");
        }
        return stringBuffer.toString();
    }

    private void readGlyphs(int n) {
        for (int i = 1; i < this.nglyphs; ++i) {
            System.out.println("Reading glyph " + this.safe(this.getSID(this.glyphnames[i])));
            this.charnames.add(this.getSID(this.glyphnames[i]));
        }
    }

    public GlyphData readGlyph(String string) {
        int n = this.getNameIndex(string);
        for (int i = 0; i < this.glyphnames.length; ++i) {
            if (this.glyphnames[i] != n) continue;
            return this.readGlyph(i);
        }
        return this.readGlyph(0);
    }

    public GlyphData readGlyph(int n) {
        String string = this.getSID(n);
        if (this.charset.containsKey(string)) {
            return this.charset.get(string);
        }
        Range range = this.getIndexEntry(this.charstringbase, n);
        FlPoint flPoint = new FlPoint();
        GlyphData glyphData = new GlyphData();
        this.parseGlyph(range, glyphData, flPoint);
        glyphData.setName(string);
        this.charset.put(string, glyphData);
        return glyphData;
    }

    private void buildAccentChar(float f, float f2, float f3, float f4, GlyphData glyphData) {
        System.out.println("Building accent character!!!!!!");
        for (int i = 0; i < this.nglyphs; ++i) {
            if (this.encoding[i] == (int)f3) {
                glyphData.addGlyph(this.readGlyph(i + 1), f, f2);
                continue;
            }
            if (this.encoding[i] != (int)f4) continue;
            glyphData.addGlyph(this.readGlyph(i + 1), 0.0f, 0.0f);
        }
    }

    public int calcoffset(int n) {
        int n2 = this.getIndexSize(n);
        if (n2 < 1240) {
            return -107;
        }
        if (n2 < 33900) {
            return -1131;
        }
        return Short.MIN_VALUE;
    }

    public String getSID(int n) {
        if (n < FontSupport.stdNames.length) {
            return FontSupport.stdNames[n];
        }
        return this.names[n -= FontSupport.stdNames.length];
    }

    private int getNameIndex(String string) {
        int n = FontSupport.findName(string, FontSupport.stdNames);
        if (n == -1) {
            n = FontSupport.findName(string, this.names) + FontSupport.stdNames.length;
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public void parseGlyph(Range range, GlyphData glyphData, FlPoint flPoint) {
        this.pos = range.getStart();
        int n = 0;
        glyphData.setAdvance(this.defaultWidthX);
        block47: while (this.pos < range.getEnd()) {
            int n2 = this.readCommand(true);
            int n3 = 0;
            switch (n2) {
                case 1: 
                case 3: {
                    if ((this.stackptr & 1) == 1) {
                        glyphData.setAdvance((float)this.nominalWidthX + this.stack[0]);
                    }
                    this.stackptr = 0;
                    continue block47;
                }
                case 4: {
                    if (this.stackptr > 1) {
                        glyphData.setAdvance((float)this.nominalWidthX + this.stack[0]);
                        this.stack[0] = this.stack[1];
                    }
                    flPoint.y += this.stack[0];
                    if (flPoint.open) {
                        glyphData.closePath();
                    }
                    flPoint.open = false;
                    glyphData.moveTo(flPoint.x, flPoint.y);
                    this.stackptr = 0;
                    continue block47;
                }
                case 5: {
                    int n4 = 0;
                    while (n4 < this.stackptr) {
                        flPoint.x += this.stack[n4++];
                        flPoint.y += this.stack[n4++];
                        glyphData.lineTo(flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 6: {
                    int n4 = 0;
                    while (n4 < this.stackptr) {
                        if ((n4 & 1) == 0) {
                            flPoint.x += this.stack[n4++];
                        } else {
                            flPoint.y += this.stack[n4++];
                        }
                        glyphData.lineTo(flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 7: {
                    int n4 = 0;
                    while (n4 < this.stackptr) {
                        if ((n4 & 1) == 0) {
                            flPoint.y += this.stack[n4++];
                        } else {
                            flPoint.x += this.stack[n4++];
                        }
                        glyphData.lineTo(flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 8: {
                    float f5;
                    float f2;
                    float f3;
                    float f4;
                    int n4 = 0;
                    while (n4 < this.stackptr) {
                        f4 = flPoint.x + this.stack[n4++];
                        f3 = flPoint.y + this.stack[n4++];
                        f2 = f4 + this.stack[n4++];
                        f5 = f3 + this.stack[n4++];
                        flPoint.x = f2 + this.stack[n4++];
                        flPoint.y = f5 + this.stack[n4++];
                        glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 10: {
                    n3 = this.pos;
                    int n4 = (int)this.stack[--this.stackptr] + this.lsubrsoffset;
                    Range range2 = this.getIndexEntry(this.lsubrbase, n4);
                    this.parseGlyph(range2, glyphData, flPoint);
                    this.pos = n3;
                    continue block47;
                }
                case 11: {
                    return;
                }
                case 14: {
                    if (this.stackptr == 5) {
                        this.buildAccentChar(this.stack[1], this.stack[2], this.stack[3], this.stack[4], glyphData);
                    }
                    if (flPoint.open) {
                        glyphData.closePath();
                    }
                    flPoint.open = false;
                    this.stackptr = 0;
                    return;
                }
                case 18: {
                    if ((this.stackptr & 1) == 1) {
                        glyphData.setAdvance((float)this.nominalWidthX + this.stack[0]);
                    }
                    n += this.stackptr / 2;
                    this.stackptr = 0;
                    continue block47;
                }
                case 19: 
                case 20: {
                    if ((this.stackptr & 1) == 1) {
                        glyphData.setAdvance((float)this.nominalWidthX + this.stack[0]);
                    }
                    System.out.println("Added " + this.stackptr + " extra bits;  skipping " + (((n += this.stackptr / 2) - 1) / 8 + 1) + " from " + n);
                    this.pos += (n - 1) / 8 + 1;
                    this.stackptr = 0;
                    continue block47;
                }
                case 21: {
                    if (this.stackptr > 2) {
                        glyphData.setAdvance((float)this.nominalWidthX + this.stack[0]);
                        this.stack[0] = this.stack[1];
                        this.stack[1] = this.stack[2];
                    }
                    flPoint.x += this.stack[0];
                    flPoint.y += this.stack[1];
                    if (flPoint.open) {
                        glyphData.closePath();
                    }
                    glyphData.moveTo(flPoint.x, flPoint.y);
                    flPoint.open = false;
                    this.stackptr = 0;
                    continue block47;
                }
                case 22: {
                    if (this.stackptr > 1) {
                        glyphData.setAdvance((float)this.nominalWidthX + this.stack[0]);
                        this.stack[0] = this.stack[1];
                    }
                    flPoint.x += this.stack[0];
                    if (flPoint.open) {
                        glyphData.closePath();
                    }
                    glyphData.moveTo(flPoint.x, flPoint.y);
                    flPoint.open = false;
                    this.stackptr = 0;
                    continue block47;
                }
                case 23: {
                    if ((this.stackptr & 1) == 1) {
                        glyphData.setAdvance((float)this.nominalWidthX + this.stack[0]);
                    }
                    n += this.stackptr / 2;
                    this.stackptr = 0;
                    continue block47;
                }
                case 24: {
                    float f5;
                    float f2;
                    float f3;
                    float f4;
                    int n4 = 0;
                    while (n4 < this.stackptr - 2) {
                        f4 = flPoint.x + this.stack[n4++];
                        f3 = flPoint.y + this.stack[n4++];
                        f2 = f4 + this.stack[n4++];
                        f5 = f3 + this.stack[n4++];
                        flPoint.x = f2 + this.stack[n4++];
                        flPoint.y = f5 + this.stack[n4++];
                        glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    }
                    flPoint.x += this.stack[n4++];
                    flPoint.y += this.stack[n4++];
                    glyphData.lineTo(flPoint.x, flPoint.y);
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 25: {
                    int n4 = 0;
                    while (n4 < this.stackptr - 6) {
                        flPoint.x += this.stack[n4++];
                        flPoint.y += this.stack[n4++];
                        glyphData.lineTo(flPoint.x, flPoint.y);
                    }
                    float f4 = flPoint.x + this.stack[n4++];
                    float f3 = flPoint.y + this.stack[n4++];
                    float f2 = f4 + this.stack[n4++];
                    float f5 = f3 + this.stack[n4++];
                    flPoint.x = f2 + this.stack[n4++];
                    flPoint.y = f5 + this.stack[n4++];
                    glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 26: {
                    float f5;
                    float f2;
                    float f3;
                    float f4;
                    int n4 = 0;
                    if ((this.stackptr & 1) == 1) {
                        flPoint.x += this.stack[n4++];
                    }
                    while (n4 < this.stackptr) {
                        f4 = flPoint.x;
                        f3 = flPoint.y + this.stack[n4++];
                        f2 = f4 + this.stack[n4++];
                        f5 = f3 + this.stack[n4++];
                        flPoint.x = f2;
                        flPoint.y = f5 + this.stack[n4++];
                        glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 27: {
                    float f5;
                    float f2;
                    float f3;
                    float f4;
                    int n4 = 0;
                    if ((this.stackptr & 1) == 1) {
                        flPoint.y += this.stack[n4++];
                    }
                    while (n4 < this.stackptr) {
                        f4 = flPoint.x + this.stack[n4++];
                        f3 = flPoint.y;
                        f2 = f4 + this.stack[n4++];
                        f5 = f3 + this.stack[n4++];
                        flPoint.x = f2 + this.stack[n4++];
                        flPoint.y = f5;
                        glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 29: {
                    n3 = this.pos;
                    int n4 = (int)this.stack[--this.stackptr] + this.gsubrsoffset;
                    Range range3 = this.getIndexEntry(this.gsubrbase, n4);
                    this.parseGlyph(range3, glyphData, flPoint);
                    this.pos = n3;
                    continue block47;
                }
                case 30: {
                    n3 = 4;
                }
                case 31: {
                    int n5;
                    float f5;
                    float f2;
                    float f3;
                    float f4;
                    int n4 = 0;
                    while (n4 < this.stackptr) {
                        n5 = (n4 + n3 & 4) == 0 ? 1 : 0;
                        f4 = flPoint.x + (n5 != 0 ? this.stack[n4++] : 0.0f);
                        f3 = flPoint.y + (n5 != 0 ? 0.0f : this.stack[n4++]);
                        f2 = f4 + this.stack[n4++];
                        f5 = f3 + this.stack[n4++];
                        flPoint.x = f2 + (n5 != 0 ? 0.0f : this.stack[n4++]);
                        flPoint.y = f5 + (n5 != 0 ? this.stack[n4++] : 0.0f);
                        if (n4 == this.stackptr - 1) {
                            if (n5 != 0) {
                                flPoint.x += this.stack[n4++];
                            } else {
                                flPoint.y += this.stack[n4++];
                            }
                        }
                        glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 1003: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f4 != 0.0f && f3 != 0.0f ? 1.0f : 0.0f;
                    continue block47;
                }
                case 1004: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f4 != 0.0f || f3 != 0.0f ? 1.0f : 0.0f;
                    continue block47;
                }
                case 1005: {
                    float f4 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f4 == 0.0f ? 1.0f : 0.0f;
                    continue block47;
                }
                case 1009: {
                    this.stack[this.stackptr - 1] = Math.abs(this.stack[this.stackptr - 1]);
                    continue block47;
                }
                case 1010: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f4 + f3;
                    continue block47;
                }
                case 1011: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f3 - f4;
                    continue block47;
                }
                case 1012: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f3 / f4;
                    continue block47;
                }
                case 1014: {
                    this.stack[this.stackptr - 1] = -this.stack[this.stackptr - 1];
                    continue block47;
                }
                case 1015: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f4 == f3 ? 1.0f : 0.0f;
                    continue block47;
                }
                case 1018: {
                    --this.stackptr;
                    continue block47;
                }
                case 1020: {
                    float f4;
                    int n4 = (int)this.stack[--this.stackptr];
                    this.temps[n4] = f4 = this.stack[--this.stackptr];
                    continue block47;
                }
                case 1021: {
                    int n4 = (int)this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = this.temps[n4];
                    continue block47;
                }
                case 1022: {
                    if (this.stack[this.stackptr - 2] > this.stack[this.stackptr - 1]) {
                        this.stack[this.stackptr - 4] = this.stack[this.stackptr - 3];
                    }
                    this.stackptr -= 3;
                    continue block47;
                }
                case 1023: {
                    this.stack[this.stackptr++] = (float)Math.random();
                    continue block47;
                }
                case 1024: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f3 * f4;
                    continue block47;
                }
                case 1026: {
                    this.stack[this.stackptr - 1] = (float)Math.sqrt(this.stack[this.stackptr - 1]);
                    continue block47;
                }
                case 1027: {
                    float f4 = this.stack[this.stackptr - 1];
                    this.stack[this.stackptr++] = f4;
                    continue block47;
                }
                case 1028: {
                    float f4 = this.stack[this.stackptr - 1];
                    this.stack[this.stackptr - 1] = this.stack[this.stackptr - 2];
                    this.stack[this.stackptr - 2] = f4;
                    continue block47;
                }
                case 1029: {
                    int n4 = (int)this.stack[this.stackptr - 1];
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    this.stack[this.stackptr - 1] = this.stack[this.stackptr - 2 - n4];
                    continue block47;
                }
                case 1030: {
                    int n4 = (int)this.stack[--this.stackptr];
                    int n5 = (int)this.stack[--this.stackptr];
                    n4 = n4 > 0 ? (n4 %= n5) : n5 - -n4 % n5;
                    if (n4 <= 0) continue block47;
                    float[] fArray = new float[n5];
                    System.arraycopy(this.stack, this.stackptr - 1 - n4, fArray, 0, n4);
                    System.arraycopy(this.stack, this.stackptr - 1 - n5, fArray, n4, n5 - n4);
                    System.arraycopy(fArray, 0, this.stack, this.stackptr - 1 - n5, n5);
                    continue block47;
                }
                case 1034: {
                    float f;
                    float f4 = flPoint.x + this.stack[0];
                    float f3 = f = flPoint.y;
                    float f2 = f4 + this.stack[1];
                    float f5 = f3 + this.stack[2];
                    flPoint.x = f2 + this.stack[3];
                    flPoint.y = f5;
                    glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    f4 = flPoint.x + this.stack[4];
                    f3 = flPoint.y;
                    f2 = f4 + this.stack[5];
                    f5 = f;
                    flPoint.x = f2 + this.stack[6];
                    flPoint.y = f5;
                    glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 1035: {
                    float f4 = flPoint.x + this.stack[0];
                    float f3 = flPoint.y + this.stack[1];
                    float f2 = f4 + this.stack[2];
                    float f5 = f3 + this.stack[3];
                    flPoint.x = f2 + this.stack[4];
                    flPoint.y = f5 + this.stack[5];
                    glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    f4 = flPoint.x + this.stack[6];
                    f3 = flPoint.y + this.stack[7];
                    f2 = f4 + this.stack[8];
                    f5 = f3 + this.stack[9];
                    flPoint.x = f2 + this.stack[10];
                    flPoint.y = f5 + this.stack[11];
                    glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 1036: {
                    float f = flPoint.y;
                    float f4 = flPoint.x + this.stack[0];
                    float f3 = flPoint.y + this.stack[1];
                    float f2 = f4 + this.stack[2];
                    float f5 = f3 + this.stack[3];
                    flPoint.x = f2 + this.stack[4];
                    flPoint.y = f5;
                    glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    f4 = flPoint.x + this.stack[5];
                    f3 = flPoint.y;
                    f2 = f4 + this.stack[6];
                    f5 = f3 + this.stack[7];
                    flPoint.x = f2 + this.stack[8];
                    flPoint.y = f;
                    glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 1037: {
                    float f = flPoint.y;
                    float f6 = flPoint.x;
                    float f4 = flPoint.x + this.stack[0];
                    float f3 = flPoint.y + this.stack[1];
                    float f2 = f4 + this.stack[2];
                    float f5 = f3 + this.stack[3];
                    flPoint.x = f2 + this.stack[4];
                    flPoint.y = f5 + this.stack[5];
                    glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    f4 = flPoint.x + this.stack[6];
                    f3 = flPoint.y + this.stack[7];
                    f2 = f4 + this.stack[8];
                    f5 = f3 + this.stack[9];
                    if (Math.abs(f2 - f6) > Math.abs(f5 - f)) {
                        flPoint.x = f2 + this.stack[10];
                        flPoint.y = f;
                    } else {
                        flPoint.x = f6;
                        flPoint.y = f5 + this.stack[10];
                    }
                    glyphData.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
            }
            System.out.println("ERROR! TYPE1C CHARSTRING CMD IS " + n2);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Need the name of a cff font.");
            System.exit(0);
        }
        JFrame jFrame = new JFrame("Font test: " + stringArray[0]);
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            TestType1CFont testType1CFont = new TestType1CFont(fileInputStream);
            jFrame.getContentPane().add(testType1CFont);
            jFrame.pack();
            jFrame.setVisible(true);
            testType1CFont.requestFocus();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class GlyphData {
        GeneralPath gp = new GeneralPath();
        GeneralPath advp;
        ArrayList<GlyphPoint> points = new ArrayList();
        float x = 0.0f;
        float y = 0.0f;
        float advance;
        String name;

        public void setName(String string) {
            this.name = string;
        }

        public void lineTo(float f, float f2) {
            this.gp.lineTo(f, f2);
            this.x = f;
            this.y = f2;
            this.points.add(new GlyphPoint(f, f2, false));
        }

        public void moveTo(float f, float f2) {
            this.gp.moveTo(f, f2);
            this.x = f;
            this.y = f2;
            this.points.add(new GlyphPoint(f, f2, false));
        }

        public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
            this.gp.curveTo(f, f2, f3, f4, f5, f6);
            this.x = f5;
            this.y = f6;
            this.points.add(new GlyphPoint(f, f2, true));
            this.points.add(new GlyphPoint(f3, f4, true));
            this.points.add(new GlyphPoint(f5, f6, false));
        }

        public void closePath() {
            this.gp.closePath();
        }

        public void addGlyph(GlyphData glyphData, float f, float f2) {
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
            PathIterator pathIterator = glyphData.gp.getPathIterator(affineTransform);
            float[] fArray = new float[6];
            while (!pathIterator.isDone()) {
                int n = pathIterator.currentSegment(fArray);
                switch (n) {
                    case 0: {
                        this.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 1: {
                        this.lineTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 3: {
                        this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    case 4: {
                        this.closePath();
                        break;
                    }
                    default: {
                        System.out.println("Unknown path type: " + n);
                    }
                }
                pathIterator.next();
            }
        }

        public void setAdvance(float f) {
            this.advance = f;
            this.advp = new GeneralPath();
            this.advp.moveTo(-2.0f, -2.0f);
            this.advp.lineTo(2.0f, 2.0f);
            this.advp.moveTo(-2.0f, 2.0f);
            this.advp.lineTo(2.0f, -2.0f);
            this.advp.moveTo(f - 2.0f, -2.0f);
            this.advp.lineTo(f, 0.0f);
            this.advp.lineTo(f + 2.0f, -2.0f);
            this.advp.moveTo(f, 0.0f);
            this.advp.lineTo(f, -8.0f);
        }

        public void draw(Graphics2D graphics2D) {
            graphics2D.setColor(TestType1CFont.this.fillColor);
            graphics2D.fill(this.gp);
            graphics2D.setColor(Color.black);
            graphics2D.draw(this.gp);
            for (int i = 0; i < this.points.size(); ++i) {
                GlyphPoint glyphPoint = this.points.get(i);
                graphics2D.setColor(Color.red);
                graphics2D.draw(glyphPoint.gp);
                graphics2D.setColor(Color.blue);
                graphics2D.setFont(TestType1CFont.this.gfont);
                graphics2D.drawString(String.valueOf(i), glyphPoint.x + 3.0f, glyphPoint.y + 3.0f);
            }
            graphics2D.setColor(Color.black);
            graphics2D.draw(this.advp);
            if (this.name != null) {
                graphics2D.setFont(TestType1CFont.this.gfont);
                graphics2D.drawString(this.name, 0, -40);
            }
        }
    }

    class GlyphPoint {
        float x;
        float y;
        boolean curvecontrol;
        GeneralPath gp;

        public GlyphPoint(float f, float f2, boolean bl) {
            this.x = f;
            this.y = f2;
            this.curvecontrol = bl;
            this.gp = new GeneralPath();
            if (bl) {
                this.gp.moveTo(f - 4.0f, f2 - 4.0f);
                this.gp.lineTo(f + 4.0f, f2 + 4.0f);
                this.gp.moveTo(f - 4.0f, f2 + 4.0f);
                this.gp.lineTo(f + 4.0f, f2 - 4.0f);
            } else {
                this.gp.moveTo(f - 4.0f, f2 - 4.0f);
                this.gp.lineTo(f - 4.0f, f2 + 4.0f);
                this.gp.lineTo(f + 4.0f, f2 + 4.0f);
                this.gp.lineTo(f + 4.0f, f2 - 4.0f);
                this.gp.closePath();
            }
        }
    }

    class Range {
        private int start;
        private int len;

        public Range(int n, int n2) {
            this.start = n;
            this.len = n2;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getLen() {
            return this.len;
        }

        public final int getEnd() {
            return this.start + this.len;
        }
    }
}

