SELECT ES.CODIGOEMPRESA
      ,ES.CODIGOESTAB
      ,ES.CODIGOSIND
      ,T.CODIGOTABELAPATRONAL
      ,A.CODIGOATIVFEDERAL
      ,A.DESCRATIVFEDERAL
      ,EMP.NOMEEMPRESA
      ,E.NOMEESTAB
      ,E.APELIDOESTAB
      ,S.NOMESIND
      ,T.DESCRTABELAPATRONAL
      ,FP.ALIQUOTA                
      ,FP.PARCELAADIC
      ,FP.LIMITEDE
      ,FP.LIMITEATE
      ,ES.CAPITALSOCIAL
      ,0 TIPO
      ,NULL VALORDEBITO 
 FROM ESTABSIND ES
 JOIN ESTAB E
   ON E.CODIGOEMPRESA = ES.CODIGOEMPRESA
  AND E.CODIGOESTAB = Es.CODIGOESTAB
 JOIN EMPRESA EMP
   ON EMP.CODIGOEMPRESA = E.CODIGOEMPRESA  
 JOIN SINDICATO S
   ON S.CODIGOSIND = ES.CODIGOSIND
 JOIN ATIVFEDERAL A
   ON A.CODIGOATIVFEDERAL = ES.CODIGOATIVFEDERAL   
 JOIN TABELAPATRONAL T 
   ON T.CODIGOTABELAPATRONAL = ES.CODIGOTABELAPATRONAL  
 JOIN FAIXAPATRONAL FP
   ON ES.CODIGOTABELAPATRONAL = FP.CODIGOTABELAPATRONAL
WHERE ES.CAPITALSOCIAL >= FP.LIMITEDE
  AND ES.CAPITALSOCIAL <= FP.LIMITEATE
  AND ES.DATAINICIAL = (SELECT MAX(ES1.DATAINICIAL)
                          FROM ESTABSIND ES1
                         WHERE ES.CODIGOEMPRESA = ES1.CODIGOEMPRESA
                           AND ES.CODIGOESTAB = ES1.CODIGOESTAB
                           AND ES1.DATAINICIAL <= :pDataInicial)
  AND FP.DATAINICIAL = (SELECT MAX(FP1.DATAINICIAL)
                          FROM FAIXAPATRONAL FP1
                         WHERE FP1.DATAINICIAL <= :pDataInicial
                           AND FP.CODIGOTABELAPATRONAL = FP1.CODIGOTABELAPATRONAL)
%0:s
UNION

SELECT ES.CODIGOEMPRESA
      ,ES.CODIGOESTAB
      ,ES.CODIGOSIND
      ,T.CODIGOTABELAPATRONAL
      ,'' CODIGOATIVFEDERAL
      ,'' DESCRATIVFEDERAL
      ,EMP.NOMEEMPRESA
      ,E.NOMEESTAB
      ,E.APELIDOESTAB
      ,S.NOMESIND
      ,T.DESCRTABELAPATRONAL
      ,FP.ALIQUOTA                
      ,FP.PARCELAADIC
      ,FP.LIMITEDE
      ,FP.LIMITEATE
      ,SUM(ES.CAPITALSOCIAL) CAPITALSOCIAL
      ,1 TIPO
      ,(SUM(ES.CAPITALSOCIAL) * FP.ALIQUOTA / 100 + FP.PARCELAADIC) VALORDEBITO       
 FROM ESTABSIND ES
 JOIN ESTAB E
   ON E.CODIGOEMPRESA = ES.CODIGOEMPRESA
  AND E.CODIGOESTAB = Es.CODIGOESTAB
 JOIN EMPRESA EMP
   ON EMP.CODIGOEMPRESA = E.CODIGOEMPRESA  
 JOIN SINDICATO S
   ON S.CODIGOSIND = ES.CODIGOSIND
 JOIN TABELAPATRONAL T 
   ON T.CODIGOTABELAPATRONAL = ES.CODIGOTABELAPATRONAL  
 JOIN FAIXAPATRONAL FP
   ON ES.CODIGOTABELAPATRONAL = FP.CODIGOTABELAPATRONAL
  AND ES.DATAINICIAL = (SELECT MAX(ES1.DATAINICIAL)
                          FROM ESTABSIND ES1
                         WHERE ES.CODIGOEMPRESA = ES1.CODIGOEMPRESA
                           AND ES.CODIGOESTAB = ES1.CODIGOESTAB
                           AND ES1.DATAINICIAL <= :pDataInicial)
  AND FP.DATAINICIAL = (SELECT MAX(FP1.DATAINICIAL)
                          FROM FAIXAPATRONAL FP1
                         WHERE FP1.DATAINICIAL <= :pDataInicial
                           AND FP.CODIGOTABELAPATRONAL = FP1.CODIGOTABELAPATRONAL)
%0:s
GROUP BY ES.CODIGOEMPRESA
        ,ES.CODIGOESTAB
        ,ES.CODIGOSIND
        ,T.CODIGOTABELAPATRONAL
        ,EMP.NOMEEMPRESA
        ,E.NOMEESTAB
        ,E.APELIDOESTAB
        ,S.NOMESIND
        ,T.DESCRTABELAPATRONAL
        ,FP.ALIQUOTA                
        ,FP.PARCELAADIC
        ,FP.LIMITEDE
        ,FP.LIMITEATE

HAVING SUM(ES.CAPITALSOCIAL) BETWEEN FP.LIMITEDE AND FP.LIMITEATE
                           
ORDER BY 1, 2, 3, 17, 4
        