  select C.CodigoEstrut,
         A.CodigoEvento,
         B.Compet,
         A.CodigoPerCalculo,
         A.ReferEvento,
         B.CodigoPerCalcCompl,
         C.ValorCalculo,
         A.ValorEvento
    from CalculoEvento A,
         PeriodoCalculo B,
         Evento C
   where A.CodigoEmpresa    = :CodigoEmpresa
     and A.CodigoFuncContr       = :CodigoFuncContr
     and A.CodigoEvento     = :CodigoEvento
     and B.Compet between :DataInicial and :DataFinal
     and B.CodigoEmpresa    = A.CodigoEmpresa
     and B.CodigoPerCalculo = A.CodigoPerCalculo
     and C.CodigoEvento     = A.CodigoEvento

union

select E.CodigoEstrut,
       RE.CodigoEvento,
       R.DataResc,
       null CodigoPerCalculo,
       RE.ReferEvento,
       null CodigoPerCalcCompl,
       E.ValorCalculo,
       RE.ValorEvento
from Rescisao R,
     CausaDemissao CD,
     RescisaoEvento RE,
     Evento E
where RE.CodigoEmpresa  = :CodigoEmpresa
  and RE.CodigoFuncContr     = :CodigoFuncContr
  and RE.CodigoEvento   = :CodigoEvento
  and R.CodigoEmpresa   = RE.CodigoEmpresa
  and R.CodigoFuncContr      = RE.CodigoFuncContr
  and R.Complementar    = RE.Complementar
  and ((R.TipoRescisao  = 1 and
      cast('01.'|| extract(month from R.DataResc)||'.'||extract(year from R.DataResc) as date)  between :DataInicial and :DataFinal)
   or  (R.TipoRescisao  <> 1 and cast('01.'|| extract(month from R.DataPgtoResc)||'.'||extract(year from R.DataPgtoResc) as date) between :DataInicial and :DataFinal))
  and E.CodigoEvento    = RE.CodigoEvento
  and CD.CodigoCausa    = R.CodigoCausa
order by 1, 2, 3, 4
