    select t.CodigoFuncContr,
         t.Compet,
         t.CodigoEstrut,
         cast(sum(t.ValorEvento) as numeric(16,2)) ValorEvento,
         cast(sum(t.ReferEvento) as numeric(18,2)) ReferEvento,
         cast(sum(t.BaseEvento) as numeric(18,9)) BaseEvento

from(    select FPC.CodigoFuncContr,
         PC.Compet,
         E.CodigoEstrut,
         sum(CE.ValorEvento) ValorEvento,
         max(CE.ReferEvento) ReferEvento,
         sum(CE.BaseEvento) BaseEvento
    from PeriodoCalculo PC,
         FuncPerCalculo FPC,
         FuncLocal FL,
         CalculoEvento CE,
         Evento E
   where PC.CodigoEmpresa = FPC.CodigoEmpresa
     and PC.CodigoPerCalculo = FPC.CodigoPerCalculo
     and FPC.CodigoEmpresa = FL.CodigoEmpresa
     and FPC.CodigoFuncContr = FL.CodigoFuncContr
     and FPC.DataLocal = FL.DataTransf
     and FPC.CodigoEmpresa = CE.CodigoEmpresa
     and FPC.CodigoPerCalculo = CE.CodigoPerCalculo
     and FPC.CodigoFuncContr = CE.CodigoFuncContr
     and CE.CodigoEvento = E.CodigoEvento
     and PC.CodigoEmpresa = :pCodigoEmpresa
     and PC.Compet between :pDataInicial and :pDataFinal
     and FL.CodigoEstab = :pCodigoEstab
     and PC.CodigoTipoCalc in (1, 7)
     and (E.CodigoEstrut = '01.01.08.01'
      or  E.CodigoEstrut = '01.01.09.01' 
      or  E.CodigoEstrut like '97.01%')
group by FPC.CodigoFuncContr,
         PC.Compet,
         E.CodigoEstrut,
         E.CodigoEvento) t

group by t.CodigoFuncContr,
         t.Compet,
         t.CodigoEstrut

union all

    select FPC.CodigoFuncContr,
         PC.Compet,
         E.CodigoEstrut,
         cast(sum(CE.ValorEvento) as numeric(16,2)) ValorEvento,
         cast(sum(CE.ReferEvento) as numeric(18,2)) ReferEvento,
         cast(sum(CE.BaseEvento) as numeric(18,9)) BaseEvento
    from PeriodoCalculo PC,
         FuncPerCalculo FPC,
         FuncLocal FL,
         CalculoEvento CE,
         Evento E
   where PC.CodigoEmpresa = FPC.CodigoEmpresa
     and PC.CodigoPerCalculo = FPC.CodigoPerCalculo
     and FPC.CodigoEmpresa = FL.CodigoEmpresa
     and FPC.CodigoFuncContr = FL.CodigoFuncContr
     and FPC.DataLocal = FL.DataTransf
     and FPC.CodigoEmpresa = CE.CodigoEmpresa
     and FPC.CodigoPerCalculo = CE.CodigoPerCalculo
     and FPC.CodigoFuncContr = CE.CodigoFuncContr
     and CE.CodigoEvento = E.CodigoEvento
     and PC.CodigoEmpresa = :pCodigoEmpresa
     and PC.Compet between :pDataInicial and :pDataFinal
     and FL.CodigoEstab = :pCodigoEstab
     and PC.CodigoTipoCalc in (20, 21, 23)
     and E.CodigoEstrut = '97.01.02'
    group by FPC.CodigoFuncContr,
          PC.Compet,
          E.CodigoEstrut
order by 1, 2, 3