SELECT Fc.DataAdm AS DataVinculo, 
       Fp.nomefunc, 
       FP.DataNasc AS DataNasc, 
       CASE Fp.sexo 
         WHEN 1 THEN 'M' 
         ELSE 'F' 
       END AS Sexo, 
       DA.nomedepend AS NomePai, 
       DB.nomedepend AS NomeMae, 
       CASE FP.nacionalidade 
         WHEN 10 THEN '10010' 
         WHEN 20 THEN '20010' 
         WHEN 15 THEN '30010' 
         ELSE 'NAC.NAO ENCONTRADA' 
       END AS NACIONALIDADE, 
       FP.SIGLAESTADONASC AS UFNascimento, 
       Replace(M_Nasc.codigorais, '.', '') AS MunicipioNascimento, 
       CASE FP.racacor 
         WHEN 1 THEN '5' 
         WHEN 2 THEN '1' 
         WHEN 4 THEN '2' 
         WHEN 6 THEN '4' 
         WHEN 8 THEN '3' 
         WHEN 9 THEN '1' 
       END AS Cor, 
       CASE FP.estadocivil 
         WHEN 1 THEN '0001' 
         WHEN 2 THEN '0002' 
         WHEN 3 THEN '0003' 
         WHEN 4 THEN '0005' 
         WHEN 5 THEN '0006' 
         WHEN 6 THEN '0001' 
         WHEN 7 THEN '0007' 
         WHEN 8 THEN '0008' 
         WHEN 9 THEN '0009' 
       END AS EstadoCivil, 
       CASE FP.grauinstr 
         WHEN 1 THEN '0001' 
         WHEN 2 THEN '0002' 
         WHEN 3 THEN '0003' 
         WHEN 4 THEN '0004' 
         WHEN 5 THEN '0005' 
         WHEN 6 THEN '0006' 
         WHEN 7 THEN '0007' 
         WHEN 8 THEN '0008' 
         WHEN 9 THEN '0009' 
         WHEN 10 THEN '0010' 
         WHEN 11 THEN '0011' 
         WHEN 12 THEN '0012' 
         ELSE '0000' 
       END as NivelInstrucao, 
       CASE 
         WHEN FP.datachegada IS NOT NULL THEN (FP.datachegada)
       END AS DataChegadaBrasil, 
       FP.cpffunc AS CPF, 
       CASE 
         WHEN FP.numerorg IS NULL THEN NULL 
         WHEN Replace(Replace(Replace(Replace(FP.numerorg, '.', ''), '/', ''), 
                      '-', '') 
              , '0', 
                     '') = '' THEN NULL 
         ELSE Replace(Replace(FP.numerorg, '.', ''), '-', '') 
       END AS Identidade, 
       Cast('' AS VARCHAR(45)) AS ComplementoRg, 
       FP.siglaestadorg, 
       FP.codigoorgaoemissorrg, 
       FP.emissrg AS DataEmissaoRg, 
       Lpad(Replace(Replace(FTD.numeroctps, '.', ''), '-', ''), 7, '0') as  NumeroCtps
       , 
       Lpad(Replace(Replace(FTD.seriectps, '.', ''), '-', ''), 5, '0') 
       as SerieCtps, 
       FTD.siglaestadoctps, 
       FTD.expedctps AS DataEmissaoCtps, 
       CASE FP.certciviltipo 
         WHEN '0' THEN '0091' 
         WHEN '1' THEN '0092' 
         WHEN '2' THEN '0095' 
         WHEN '3' THEN '0098' 
       END AS CertCivilTipo,
       FP.CERTCIVILEMISSAO,
       Substr(FP.certciviltermo, 1, 32) AS TermoMatricula, 
       FP.certcivilLivro AS Livro,
       FP.certcivilFolha AS Folha,
       FP.certcivilcartorio AS Cartorio, 
       FP.certcivilsiglaestado AS UfEmissao, 
       MC.codigorais AS MunicipioDeEmissaoCertCivil, 
       Cast(FP.passapnumero AS VARCHAR(15)) AS Passaporte, 
       Coalesce(FP.codigoorgaoemissorpasport, '85') AS OrgaoEmissorPassaporte,
       FP.passapsiglaestado AS UFEmissaoPassaporte, 
       FP.passapemissao AS DataEmissaoPassaporte, 
       FP.passapvalidade AS DataValidadePassaporte, 
       Lpad(Cast(PP.codigopaisnis AS VARCHAR(4)), 4, '0') AS PaisEmissaoPassaporte, 
       Cast (CASE 
               WHEN FP.titeleit IS NULL THEN NULL 
               WHEN Replace(Replace(Replace(Replace(FP.titeleit, '.', ''), '/', 
                                    ''), 
                            '-', '') 
                    , '0', 
                           '') = '' THEN NULL 
               ELSE Replace(Replace(Replace(FP.titeleit, '.', ''), '/', ''), '-' 
                    , '') 
             END AS VARCHAR(13)) AS NumeroTituloEleitor, 
       Cast(FP.zonatiteleit AS VARCHAR(4)) AS ZonaEleitoral, 
       Cast(FP.secaotiteleit AS VARCHAR(4))AS SessaoEleitoral, 
       FP.portnatnumero AS NumeroPortaria, 
       FP.portnatdata AS DataNaturalizacaoPortaria, 
       Replace(FP.ricnumero, '.', '') AS RicNumero, 
       FP.ricsiglaestado AS RicSigla, 
       FP.codigoorgaoemissorric, 
       MRIC.codigorais AS CodigoMunicRic, 
       FP.ricdataexped AS RicDataExped, 
       Cast(1 AS INTEGER) AS TipoLogradouroFunc, 
       Replace(Replace(CASE 
                         WHEN Cast(1 AS INTEGER) = 1 THEN fp.cepfunc 
                       END, '.', ''), '-', '-') AS CEPFUNC, 
       cast('NUM' as VARCHAR(3)) as TipoEnderecoRuaLoteNumerto,
       fp.numeroender, 
       fp.complender, 
       E.caixapostal AS caixaPostal, 
       E.cepcaixapostal AS CepCaixaPostal, 
       Cast(FP.dddfone AS VARCHAR(3)) AS DDDFone, 
       Cast(FP.numerofone AS VARCHAR(9)) AS NumeroFone, 
       Cast(1 AS INTEGER) AS TipoTelefone, 
       fp.endereletr 
FROM   funccontrato Fc 
       JOIN funcpessoa Fp 
         ON( fp.codigofuncpessoa = fc.codigofuncpessoa ) 
       LEFT JOIN dependente DA 
              ON DA.codigoempresa = FC.codigoempresa 
                 AND DA.codigofunccontr = FC.codigofunccontr 
                 AND DA.parentesco = '03' 
                 AND DA.sexo = 1 
       LEFT JOIN dependente DB 
              ON DB.codigoempresa = FC.codigoempresa 
                 AND DB.codigofunccontr = FC.codigofunccontr 
                 AND DB.parentesco = '03' 
                 AND DB.sexo = 2 
       JOIN municipio M_Nasc 
         ON FP.siglaestadonasc = M_Nasc.siglaestado 
            AND FP.codigomunicnasc = M_Nasc.codigomunic
	   LEFT JOIN (SELECT FTD.CODIGOEMPRESA,
                         FTD.CODIGOFUNCCONTR, 
                     MAX(FTD.DATAINICIAL) DATAINICIAL 
                        FROM FUNCCTPS FTD 
                       GROUP BY FTD.CODIGOEMPRESA, FTD.CODIGOFUNCCONTR) FCTD 
              ON FCTD.CODIGOEMPRESA = FC.CODIGOEMPRESA 
             AND FCTD.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR 
       LEFT JOIN FUNCCTPS FTD 
              ON FTD.CODIGOEMPRESA = FC.CODIGOEMPRESA 
             AND FTD.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR 
             AND FTD.DATAINICIAL = FCTD.DATAINICIAL			
       LEFT JOIN municipio MC 
                    ON FP.certcivilsiglaestado = MC.siglaestado 
                       AND FP.certcivilmunic = MC.codigomunic 
       LEFT JOIN municipio MRIC 
                    ON FP.ricsiglaestado = MRIC.siglaestado 
                       AND FP.ricmunic = MRIC.codigomunic 
       LEFT JOIN municipio MF 
                    ON FP.siglaestado = MF.siglaestado 
                       AND FP.codigomunic = MF.codigomunic 
       LEFT JOIN pais PP 
                    ON FP.passappaisemissao = PP.codigopais 
       JOIN funclocal FL 
         ON FL.codigoempresa = FC.codigoempresa 
            AND FL.codigofunccontr = FC.codigofunccontr 
            AND FL.datatransf = (SELECT Max(FLS.datatransf) 
                                 FROM   funclocal FLS 
                                 WHERE  FLS.codigoempresa = FL.codigoempresa 
                                        AND FLS.codigofunccontr = 
                                            FL.codigofunccontr) 
       JOIN estab E 
         ON FL.codigoempresa = E.codigoempresa 
            AND FL.codigoestab = E.codigoestab 
Where %0:s