SELECT FP.cpffunc AS CPF,
       FP.DataNasc AS DataNasc,
       Fc.DataAdm AS DataAdmissao,

       CASE FP.nacionalidade 
         WHEN 10 THEN '105'
         WHEN 20 THEN 'CodSite'
         WHEN 15 THEN 'CodSite'
         ELSE 'NAC.NAO ENCONTRADA' 
       END AS Nascimento_PaisNascimento,
       M_Nasc.SIGLAESTADO AS Nascimento_UfN,
       Replace(M_Nasc.codigorais, '.', '') AS Nascimento_CodigoMunicipioN,
       REPLACE(REPLACE(REPLACE(fp.PISFUNC, '.',''), '/',''), '-','') as Trabalhador_Nis,
       CASE FP.racacor 
         WHEN 1 THEN '5' 
         WHEN 2 THEN '1' 
         WHEN 4 THEN '2' 
         WHEN 6 THEN '4' 
         WHEN 8 THEN '3' 
         WHEN 9 THEN '1' 
       END AS Trabalhador_RacaCor,
       CASE FP.estadocivil 
         WHEN 1 THEN '1'
         WHEN 2 THEN '2'
         WHEN 3 THEN '3'
         WHEN 4 THEN '5'
       END AS Trabalhador_EstadoCivil,
       CASE FP.grauinstr 
         WHEN 1 THEN '01'
         WHEN 2 THEN '02'
         WHEN 3 THEN '03'
         WHEN 4 THEN '04'
         WHEN 5 THEN '05'
         WHEN 6 THEN '06'
         WHEN 7 THEN '07'
         WHEN 8 THEN '08'
         WHEN 9 THEN '09'
         WHEN 10 THEN '10'
         WHEN 11 THEN '11'
         WHEN 12 THEN '12'
         WHEN 13 THEN '12'
         ELSE '0000' 
       END as Trabalhador_GrauInstrucao,

       Lpad(Replace(Replace(FTD.numeroctps, '.', ''), '-', ''), 7, '0') as  Documentos_Ctps_NumeroCtps,
       Lpad(Replace(Replace(FTD.seriectps, '.', ''), '-', ''), 5, '0') as Documentos_Ctps_SerieCtps,
       FTD.siglaestadoctps as Documentos_Ctps_UfCtps,
       FC.DATAAPOSENT as OFFaposentadoriaS,
       FC.DATAAPOSENT as OFFaposentadoriaN,
       Cast(FP.dddfone AS VARCHAR(3)) || Cast(FP.numerofone AS VARCHAR(9)) AS Contato_TelefonePrincipal,
       fp.endereletr AS Contato_EmailPrincipal,
       Replace(Replace(CASE 
                         WHEN Cast(1 AS INTEGER) = 1 THEN fp.cepfunc 
                       END, '.', ''), '-', '-') AS EnderecoResidencialBR_Cep,

       fp.numeroender as EnderecoResidencialBR_Nume,
       fp.numeroender as SemNumeroLogradouroEnderecoBR,
       fp.COMPLENDER  as EnderecoResidencialBR_Comp,
       fp.BAIRROFUNC as EnderecoResidencialBR_Bair,
       Cast('0' AS Varchar(1)) AS  EnderecoResidencialBR_Tip,
       fp.ENDERFUNC as EnderecoResidencialBR_Des,
       fp.SIGLAESTADO as EnderecoResidencialBR_U
FROM   funccontrato Fc 
       JOIN funcpessoa Fp 
         ON( fp.codigofuncpessoa = fc.codigofuncpessoa ) 
       LEFT JOIN dependente DA 
              ON DA.codigoempresa = FC.codigoempresa 
                 AND DA.codigofunccontr = FC.codigofunccontr 
                 AND DA.parentesco = '03' 
                 AND DA.sexo = 1 
       LEFT JOIN dependente DB 
              ON DB.codigoempresa = FC.codigoempresa 
                 AND DB.codigofunccontr = FC.codigofunccontr 
                 AND DB.parentesco = '03' 
                 AND DB.sexo = 2 
       JOIN municipio M_Nasc 
         ON FP.siglaestadonasc = M_Nasc.SIGLAESTADO
            AND FP.codigomunicnasc = M_Nasc.codigomunic
       LEFT JOIN (SELECT FTD.CODIGOEMPRESA,
                         FTD.CODIGOFUNCCONTR, 
                     MAX(FTD.DATAINICIAL) DATAINICIAL 
                 FROM FUNCCTPS FTD 
                GROUP BY FTD.CODIGOEMPRESA, FTD.CODIGOFUNCCONTR) FCTD 
              ON FCTD.CODIGOEMPRESA = FC.CODIGOEMPRESA 
             AND FCTD.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR 
       LEFT JOIN FUNCCTPS FTD 
              ON FTD.CODIGOEMPRESA = FC.CODIGOEMPRESA 
             AND FTD.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR 
             AND FTD.DATAINICIAL = FCTD.DATAINICIAL
       LEFT JOIN municipio MC 
                    ON FP.certcivilsiglaestado = MC.siglaestado 
                       AND FP.certcivilmunic = MC.codigomunic 
       LEFT JOIN municipio MRIC 
                    ON FP.ricsiglaestado = MRIC.siglaestado 
                       AND FP.ricmunic = MRIC.codigomunic 
       LEFT JOIN municipio MF 
                    ON FP.siglaestado = MF.siglaestado 
                       AND FP.codigomunic = MF.codigomunic 
       LEFT JOIN pais PP 
                    ON FP.passappaisemissao = PP.codigopais 
       JOIN funclocal FL 
         ON FL.codigoempresa = FC.codigoempresa 
            AND FL.codigofunccontr = FC.codigofunccontr 
            AND FL.datatransf = (SELECT Max(FLS.datatransf) 
                                 FROM   funclocal FLS 
                                 WHERE  FLS.codigoempresa = FL.codigoempresa 
                                        AND FLS.codigofunccontr = 
                                            FL.codigofunccontr) 
       JOIN estab E 
         ON FL.codigoempresa = E.codigoempresa 
            AND FL.codigoestab = E.codigoestab 

Where %0:s