select distinct x.CodigoEmpresa,
                x.InscrFederal,
                x.TipoInscr,
                ceg.SocioRespCNPJ,
                cast(fP.CpfFunc as VarChar(18)) InscrBenef,
                cast(1 as integer) OrigemDado,
                cast(1 as integer) TipoBenef,
                f.CodigoFuncContr CodigoBenef,
                fp.NomeFunc Nome,
                f.DataDem DataDemissao,
                x.DataEncerAtiv,
                cast(0 as integer) codigoImposto
     from Estab x,
          FuncContrato f,
          FuncPerCalculo fpc,
          CalculoEvento ce,
          Evento e,
          PeriodoCalculo pc,
          CfgEmpresaGem ceg,
          FuncPessoa fp 
    where x.CodigoEmpresa = f.CodigoEmpresa
         and ceg.CodigoEmpresa = x.CodigoEmpresa
         and f.CodigoEmpresa = fpc.CodigoEmpresa
         and f.CodigoFuncContr = fpc.CodigoFuncContr
         and fpc.CodigoEmpresa = ce.CodigoEmpresa
         and fpc.CodigoPerCalculo = ce.CodigoPerCalculo
         and fpc.CodigoFuncContr = ce.CodigoFuncContr
         and ce.CodigoEvento = e.CodigoEvento
         and fp.codigoFuncPessoa = f.codigoFuncPessoa
         %s
         and x.CodigoEstab = 1
         and e.OrigemDadoDirf = 1
         and e.FormaInformeDirf <> 0
         and ce.ValorEvento > 0
         and fpc.DataPgtoFolha between :pCompetIni and :pCompetFin
         and pc.CodigoEmpresa = fpc.CodigoEmpresa
         and pc.CodigoPerCalculo = fpc.CodigoPerCalculo
         and pc.DataFinalFolha >= fpc.DataLocal
union
select distinct x.CodigoEmpresa,
                x.InscrFederal,
                x.TipoInscr,
                ceg.SocioRespCNPJ,
                cast(fp.CpfFunc as VarChar(18)) InscrBenef,
                cast(1 as integer) OrigemDado,
                cast(1 as integer) TipoBenef,
                f.CodigoFuncContr CodigoBenef,
                fp.NomeFunc Nome,
                f.DataDem DataDemissao,
                x.DataEncerAtiv,
                cast(0 as integer) codigoImposto
     from Estab x,
          FuncContrato f,
          ReciboFerias rf,
          FeriasEvento fe,
          Evento e,
          CfgEmpresaGem ceg,
          funcPessoa fp 
    where x.CodigoEmpresa = f.CodigoEmpresa
      and ceg.CodigoEmpresa = x.CodigoEmpresa
      and f.CodigoEmpresa = rf.CodigoEmpresa
      and f.CodigoFuncContr = rf.CodigoFuncContr
      and rf.CodigoEmpresa = fe.CodigoEmpresa
      and rf.CodigoFuncContr = fe.CodigoFuncContr
      and rf.DataInicial = fe.DataInicial
      and rf.DataInicialFerias = fe.DataInicialFerias
	  and rf.SeqReciboFerias = fe.SeqReciboFerias
      and fe.CodigoEvento = e.CodigoEvento
      and fp.codigoFuncPessoa = f.codigoFuncPessoa
      %s
      and x.CodigoEstab = 1
      and e.OrigemDadoDirf = 2
      and e.FormaInformeDirf <> 0
      and e.FormaInformeDirf <> 0
      and fe.ValorEvento > 0
      and rf.Tiporecibo <> 3
      and rf.DataPgto between  :pCompetIni and :pCompetFin
      and (rf.DataPgto >= f.DataTransfEmp or f.DataTransfEmp is null)
union
select distinct x.CodigoEmpresa,
                x.InscrFederal,
                x.TipoInscr,
                ceg.SocioRespCNPJ,
                cast(fp.CpfFunc as VarChar(18)) InscrBenef,
                cast(1 as integer) OrigemDado,
                cast(1 as integer) TipoBenef,
                f.CodigoFuncContr CodigoBenef,
                fp.NomeFunc Nome,
                f.DataDem DataDemissao,
                x.DataEncerAtiv,
                cast(0 as integer) codigoImposto
     from Estab x,
          FuncContrato f,
          Rescisao r,
          RescisaoEvento re,
          Evento e,
          CfgEmpresaGem ceg,
          FuncPessoa fp
    where x.CodigoEmpresa = f.CodigoEmpresa
        and ceg.CodigoEmpresa = x.CodigoEmpresa
        and f.CodigoEmpresa = r.CodigoEmpresa
        and f.CodigoFuncContr = r.CodigoFuncContr
        and r.CodigoEmpresa = re.CodigoEmpresa
        and r.CodigoFuncContr = re.CodigoFuncContr
        and r.Complementar = re.Complementar
        and re.CodigoEvento = e.CodigoEvento
        and fp.codigoFuncPessoa = f.codigoFuncPessoa
        %s
        and x.CodigoEstab = 1
        and e.OrigemDadoDirf = 1
        and e.FormaInformeDirf <> 0
        and re.ValorEvento > 0
        and r.DataPgtoResc between :pCompetIni and :pCompetFin
union
select distinct x.CodigoEmpresa,
                x.InscrFederal,
                x.TipoInscr,
                ceg.SocioRespCNPJ,
                cast(fp.CpfFunc as VarChar(18)) InscrBenef,
                cast(1 as integer) OrigemDado,
                cast(1 as integer) TipoBenef,
                f.CodigoFuncContr CodigoBenef,
                fp.NomeFunc Nome,
                f.DataDem DataDemissao,
                x.DataEncerAtiv,
                cast(0 as integer) codigoImposto
     from Estab x,
          FuncContrato f,
          AdtoFerias af,
          CfgEmpresaGem ceg,
          FuncPessoa fp
    where x.CodigoEmpresa = f.CodigoEmpresa
      and ceg.CodigoEmpresa = x.CodigoEmpresa
      and f.CodigoEmpresa = af.CodigoEmpresa
      and f.CodigoFuncContr = af.CodigoFuncContr
      and fp.codigoFuncPessoa = f.codigoFuncPessoa
      %s
      and x.CodigoEstab = 1
      and af.DataAdto between :pCompetIni and :pCompetFin
      and (af.DataAdto >= f.DataTransfEmp or f.DataTransfEmp is null)   
union
select distinct x.CodigoEmpresa,
                x.InscrFederal,
                x.TipoInscr,
                ceg.SocioRespCNPJ,
                cast(fp.CpfFunc as VarChar(18)) InscrBenef,
                cast(1 as integer) OrigemDado,
                cast(1 as integer) TipoBenef,
                f.CodigoFuncContr CodigoBenef,
                fp.NomeFunc Nome,
                f.DataDem DataDemissao,
                x.DataEncerAtiv,
                cast(0 as integer) codigoImposto
     from Estab x,
          FuncContrato f,
          Vale v,
          TipoVale tv,
          CfgEmpresaGem ceg,
          FuncPessoa fp
    where x.CodigoEmpresa = f.CodigoEmpresa
          and ceg.CodigoEmpresa = x.CodigoEmpresa
          and f.CodigoEmpresa = v.CodigoEmpresa
          and f.CodigoFuncContr = v.CodigoFuncContr
          and fp.codigoFuncPessoa = f.codigoFuncPessoa
          %s
          and x.CodigoEstab = 1
          and v.DataVale between :pCompetIni and :pCompetFin
          and (v.DataVale >= f.DataTransfEmp
           or f.DataTransfEmp is null)
          and v.CodigoTipoVale = tv.CodigoTipoVale
          and tv.PossuiIRRF = '1'
union
select distinct x.CodigoEmpresa,
                x.InscrFederal,
                x.TipoInscr,
                ceg.SocioRespCNPJ,
                cast(t.CPFTerc as VarChar(18)) InscrBenef,
                cast(2 as integer) OrigemDado,
                cast(1 as integer) TipoBenef,
                cast(t.CodigoTerc as integer) CodigoBenef,
                t.NomeTerc Nome,
                cast(null as Date) DataDemissao,
                x.DataEncerAtiv,
                cast(0 as integer) codigoImposto
           from Estab x,
                Terceiro t,
                TerceiroPgto tp,
                CfgEmpresaGem ceg
          where x.CodigoEmpresa = tp.CodigoEmpresa
                and ceg.CodigoEmpresa = x.CodigoEmpresa
                and tp.CodigoTerc = t.CodigoTerc
                and x.CodigoEstab = 1
                %s
                and (EXISTS(SELECT 1
                            FROM TERCEIROPGTOSERVICO IRRF
                            WHERE IRRF.CodigoEmpresa = TP.CODIGOEMPRESA
                            AND IRRF.CODIGOTERC = TP.CODIGOTERC
                            AND IRRF.COMPET = TP.COMPET
                            AND IRRF.SEQ = TP.SEQ
                            AND IRRF.CODIGOSERVICO = 9067
                            AND IRRF.VALOR > 0) or tp.GPSORIGEM in(6,7))
                and tp.DataPgto between :pCompetIni and :pCompetFin
union
select distinct x.CodigoEmpresa,
                x.InscrFederal,
                x.TipoInscr,
                ceg.SocioRespCNPJ,
                cast(oe.InscrFederal as VarChar(18)) InscrBenef,
                cast(3 as integer) OrigemDado,
                cast(oe.TipoInscr as integer) TipoBenef,
                cast(oe.CodigoOutEmp as integer) CodigoBenef,
                oe.NomeOutEmp Nome,
                cast(null as Date) DataDemissao,
                x.DataEncerAtiv,
                cast(0 as integer) codigoImposto
     from Estab x,
          OutraEmpresa oe,
          OutraEmpPgto oep,
          CfgEmpresaGem ceg
     where x.CodigoEmpresa = oep.CodigoEmpresa
       and ceg.CodigoEmpresa= x.CodigoEmpresa
       and oep.CodigoOutEmp = oe.CodigoOutEmp
       %s
       and x.CodigoEstab = 1
       and oep.CodigoImpostoIRRF is not null
       and oep.BaseIRRF > 0
       and oep.DataPgto between :pCompetIni and :pCompetFin
union
select distinct x.CodigoEmpresa,
                x.InscrFederal,
                x.TipoInscr,
                ceg.SocioRespCNPJ,
                cast(fp.CpfFunc as VarChar(18)) InscrBenef,
                cast(1 as integer) OrigemDado,
                cast(1 as integer) TipoBenef,
                f.CodigoFuncContr CodigoBenef,
                fp.NomeFunc Nome,
                f.DataDem DataDemissao,
                x.DataEncerAtiv,
                ir.CODIGOIMPOSTO
     from Estab x,
          FuncContrato f,
          InformeRendimentoOutRend ir,
          CfgEmpresaGem ceg,
          FuncPessoa fp 
    where x.CodigoEmpresa = f.CodigoEmpresa
          and ceg.CodigoEmpresa = x.CodigoEmpresa
          and f.CodigoEmpresa = ir.CodigoEmpresa
          and f.CodigoFuncContr = ir.CodigoFuncContr
          and fp.codigoFuncPessoa = f.codigoFuncPessoa
          %s
          and not ir.CODIGOIMPOSTO is null    
          and ir.CAMPOINFORME in (1,2,3,4,5,6)
          and x.CodigoEstab = 1
          and ir.DATAPGTO between :pCompetIni and :pCompetFin
union
select distinct x.CodigoEmpresa,
                x.InscrFederal,
                x.TipoInscr,
                ceg.SocioRespCNPJ,
                cast(s.INSCRFEDERAL as VarChar(18)) InscrBenef,
                cast(1 as integer) OrigemDado,
                cast(1 as integer) TipoBenef,
                s.CODIGOSOCIO CodigoBenef,
                s.NOMESOCIO Nome,
                s.DATAFIMSOCIO DataDemissao,
                x.DataEncerAtiv,
                ir.CODIGOIMPOSTO
     from Estab x,
          SOCIO s,
          InformeRendimentoOutRend ir,
          CfgEmpresaGem ceg
    where x.CodigoEmpresa = s.CodigoEmpresa
      and ceg.CodigoEmpresa = x.CodigoEmpresa
      and s.CodigoEmpresa = ir.CodigoEmpresa
      and s.CODIGOSOCIO = ir.CODIGOSOCIO
      %s
      and not ir.CODIGOIMPOSTO is null
      and ir.CAMPOINFORME in (1,2,3,4,5,6)
      and x.CodigoEstab = 1
      and ir.DATAPGTO between :pCompetIni and :pCompetFin
union
select distinct x.CodigoEmpresa,
                x.InscrFederal,
                x.TipoInscr,
                ceg.SocioRespCNPJ,
                cast(t.CPFTERC as VarChar(18)) InscrBenef,
                cast(2 as integer) OrigemDado,
                cast(1 as integer) TipoBenef,
                t.CODIGOTERC CodigoBenef,
                t.NOMETERC Nome,
                cast(null as Date) DataDemissao,
                x.DataEncerAtiv,
                ir.CODIGOIMPOSTO
       from Estab x,
            TERCEIRO t,
            InformeRendimentoOutRend ir,
            CfgEmpresaGem ceg,
            TERCEIROBANCO tb
      where x.CodigoEmpresa = tb.CodigoEmpresa
        and tb.codigoempresa = x.codigoempresa
        and ceg.CodigoEmpresa = x.CodigoEmpresa
        and tb.CodigoEmpresa = ir.CodigoEmpresa
        and t.CODIGOTERC = ir.CODIGOTERC
        %s
        and not ir.CODIGOIMPOSTO is null
        and ir.CAMPOINFORME in (1,2,3,4,5,6)
        and x.CodigoEstab = 1
        and ir.DATAPGTO between :pCompetIni and :pCompetFin
order by 12, 1, 2, 3, 4, 5, 6, 7, 8

