select T.CODIGOEMPRESA
     ,T.CODIGOESTAB
     ,T.TIPOINSCR
     ,T.INSCRFEDERAL
     ,T.TIPOINSCRBENEF
     ,T.InscrFederalBenef
     ,T.NOMEFUNC
     ,T.NomeOperadora
     ,T.InscrFederalOper
     ,T.REGISTROANS
     ,SUM(T.ValorPagoTitular) ValorPagoTitular
     ,SUM(T.ValorPagoReembolsoAnoAnt) ValorPagoReembolsoAnoAnt
     ,SUM(T.ValorPagoReembolsoAno) ValorPagoReembolsoAno 

from (SELECT X.CODIGOEMPRESA
     ,FL.CODIGOESTAB 
     ,E.TIPOINSCR
     ,E.INSCRFEDERAL
     ,1 TIPOINSCRBENEF
     ,FP.CPFFUNC InscrFederalBenef
     ,FP.NOMEFUNC
     ,OE.NOMEOUTEMP NomeOperadora
     ,OE.INSCRFEDERAL InscrFederalOper
     ,OEE.REGISTROANS
     ,SUM(case when CFPS.TIPODESPESA in (1,2,3) then      
               CFPS.VALOR
          end) ValorPagoTitular
     ,SUM(case when CFPS.TIPODESPESA = 4 then      
               CFPS.VALOR
          end) ValorPagoReembolsoAnoAnt
      ,SUM(case when CFPS.TIPODESPESA = 5 then      
               CFPS.VALOR
          end) ValorPagoReembolsoAno

    FROM CALCULOFUNCPLANOSAUDE CFPS
    JOIN FUNCCONTRATO X
      ON X.CODIGOEMPRESA = CFPS.CODIGOEMPRESA
     AND X.CodigoFuncContr = CFPS.CodigoFuncContr
    JOIN FUNCPESSOA FP
      ON FP.CODIGOFUNCPESSOA = X.CODIGOFUNCPESSOA 
    JOIN ESTAB E
      ON E.CODIGOEMPRESA = X.CODIGOEMPRESA
     AND E.CODIGOESTAB = 1
    JOIN OUTRAEMPEMP OEE
      ON OEE.CODIGOEMPRESA = CFPS.CODIGOEMPRESA
     AND OEE.CODIGOOUTEMP = CFPS.CODIGOOUTEMP
    JOIN OUTRAEMPRESA OE
      ON OE.CODIGOOUTEMP = OEE.CODIGOOUTEMP
    JOIN FUNCLOCAL FL 
      ON FL.CODIGOEMPRESA = X.CODIGOEMPRESA
     AND FL.CODIGOFUNCCONTR = X.CODIGOFUNCCONTR
     AND FL.DATATRANSF = (SELECT MAX(FLX.DATATRANSF) FROM FUNCLOCAL FLX
                           WHERE FLX.CODIGOEMPRESA = FL.CODIGOEMPRESA
                             AND FLX.CODIGOFUNCCONTR = FL.CODIGOFUNCCONTR
                             AND FLX.DATATRANSF <= :pDataFinal)   
   WHERE DATAPGTO BETWEEN :pDataInicial and :pDataFinal
     AND CFPS.CODIGODEPEND IS NULL
   %s
   GROUP BY X.CODIGOEMPRESA
           ,FL.CODIGOESTAB
           ,E.TIPOINSCR
           ,E.INSCRFEDERAL
           ,FP.CPFFUNC
           ,FP.NOMEFUNC
           ,OE.NOMEOUTEMP
           ,OE.INSCRFEDERAL
           ,OEE.REGISTROANS

UNION

SELECT X.CODIGOEMPRESA
      ,FL.CODIGOESTAB
      ,E.TIPOINSCR
      ,E.INSCRFEDERAL
      ,1 TIPOINSCRBENEF
      ,FP.CPFFUNC InscrFederalBenef
      ,FP.NOMEFUNC
      ,OE.NOMEOUTEMP NomeOperadora
      ,OE.INSCRFEDERAL InscrFederalOper
      ,OEE.REGISTROANS
      ,0 ValorPagoTitular
      ,0 ValorPagoReembolsoAnoAnt
      ,0 ValorPagoReembolsoAno
     FROM CALCULOFUNCPLANOSAUDE CFPS
     JOIN FUNCCONTRATO X
       ON X.CODIGOEMPRESA = CFPS.CODIGOEMPRESA
      AND X.CodigoFuncContr = CFPS.CodigoFuncContr
     JOIN FUNCPESSOA FP
       ON FP.CODIGOFUNCPESSOA = X.CODIGOFUNCPESSOA  
     JOIN ESTAB E
       ON E.CODIGOEMPRESA = X.CODIGOEMPRESA
      AND E.CODIGOESTAB = 1
     JOIN OUTRAEMPEMP OEE
       ON OEE.CODIGOEMPRESA = CFPS.CODIGOEMPRESA
      AND OEE.CODIGOOUTEMP = CFPS.CODIGOOUTEMP
     JOIN OUTRAEMPRESA OE
       ON OE.CODIGOOUTEMP = OEE.CODIGOOUTEMP
     JOIN FUNCLOCAL FL 
       ON FL.CODIGOEMPRESA = X.CODIGOEMPRESA
      AND FL.CODIGOFUNCCONTR = X.CODIGOFUNCCONTR
      AND FL.DATATRANSF = (SELECT MAX(FLX.DATATRANSF) FROM FUNCLOCAL FLX
                            WHERE FLX.CODIGOEMPRESA = FL.CODIGOEMPRESA
                             AND FLX.CODIGOFUNCCONTR = FL.CODIGOFUNCCONTR
                             AND FLX.DATATRANSF <= :pDataFinal)      
   WHERE DATAPGTO BETWEEN :pDataInicial and :pDataFinal
     AND CFPS.CODIGODEPEND IS NOT NULL
  %s
   GROUP BY X.CODIGOEMPRESA
           ,FL.CODIGOESTAB
           ,E.TIPOINSCR
           ,E.INSCRFEDERAL
           ,FP.CPFFUNC
           ,FP.NOMEFUNC
           ,OE.NOMEOUTEMP
           ,OE.INSCRFEDERAL
           ,OEE.REGISTROANS
) T
   GROUP BY T.CODIGOEMPRESA
           ,T.CODIGOESTAB
          ,T.TIPOINSCR
          ,T.INSCRFEDERAL
          ,T.TIPOINSCRBENEF
          ,T.InscrFederalBenef
          ,T.NOMEFUNC
          ,T.NomeOperadora
          ,T.InscrFederalOper
          ,T.REGISTROANS
