select T.CodigoEmpresa,
       T.CPFFunc,
       T.DescrRendIsentoOut,
       sum(T.Total) Total
from (
      select X.CodigoEmpresa,
            FP.CPFFunc,
            e.DescrRendIsentoOut,
            sum(ce.ValorEvento) Total
      from Funccontrato X
       Join FuncPessoa FP 
        on FP.CodigoFuncPessoa = X.CodigoFuncPessoa
    join FuncPerCalculo fpc 
      on X.CodigoEmpresa = fpc.CodigoEmpresa
     and X.CodigoFuncContr = fpc.CodigoFuncContr
    join CalculoEvento ce
      on fpc.CodigoEmpresa = ce.CodigoEmpresa
     and fpc.CodigoPerCalculo = ce.CodigoPerCalculo
     and fpc.CodigoFuncContr = ce.CodigoFuncContr
    join Evento e 
      on ce.CodigoEvento = e.CodigoEvento
      join PeriodoCalculo pc
      on PC.CodigoEmpresa = FPC.CodigoEmpresa
        and PC.CodigoPerCalculo = FPC.CodigoPerCalculo
      where 1 = 1
        %s
        and fpc.DataPgtoFolha between :pCompetIni and :pCompetFin
        and e.OrigemDadoDirf = 1
        and e.LocalInformeDirf = 13
        and e.FormaInformeDirf <> 0
        and ce.ValorEvento <> 0
        and PC.DataFinalFolha >= FPC.DataLocal
        and ce.CodigoEvento not in(Select re.CodigoEvento
                                   from Rescisao r
                                   join RescisaoEvento re
                                     on re.CodigoEmpresa = r.CodigoEmpresa
                                    and re.CodigoFuncContr = r.CodigoFuncContr
                                    and re.Complementar = r.Complementar
                                   join Evento ev
                                    on ev.CodigoEvento = re.CodigoEvento
                                  where r.CodigoFuncContr = x.CodigoFuncContr
                                    and r.CodigoEmpresa = x.CodigoEmpresa
                                    and ((r.DataResc between PC.DataInicialFolha and PC.DataFinalFolha and r.TipoRescisao = 1) or
                                         (r.DataPgtoResc between PC.DataInicialFolha and PC.DataFinalFolha and r.TipoRescisao <> 1))
                                    and ev.OrigemDadoDirf = 1
                                    and ev.LocalInformeDirf = 13
                                    and ev.FormaInformeDirf <> 0
                                    and re.ValorEvento <> 0)
    group by X.CodigoEmpresa,
             FP.CPFFunc,
             e.DescrRendIsentoOut
      union all
      select X.CodigoEmpresa,
             FP.CPFFunc,
             e.DescrRendIsentoOut,
             sum(fe.ValorEvento) Total
      from FuncContrato X
       Join FuncPessoa FP 
        on FP.CodigoFuncPessoa = X.CodigoFuncPessoa
    join ReciboFerias rf
      on X.CodigoFuncContr = rf.CodigoFuncContr
        and X.CodigoEmpresa = rf.CodigoEmpresa
    join FeriasEvento fe
      on rf.CodigoEmpresa = fe.CodigoEmpresa
       and rf.CodigoFuncContr = fe.CodigoFuncContr
       and rf.DataInicial = fe.DataInicial
       and rf.DataInicialFerias= fe.DataInicialFerias
	   and rf.SeqReciboFerias = fe.SeqReciboFerias
    join Evento e
      on fe.CodigoEvento = e.CodigoEvento
      where 1 = 1
        %s
       and rf.DataPgto between :pCompetIni and :pCompetFin
       and rf.TipoRecibo <> 3
       and e.OrigemDadoDirf = 2
       and e.LocalInformeDirf = 13
       and e.FormaInformeDirf <> 0
       and fe.ValorEvento <> 0
       and (rf.DataPgto >= X.DataTransfEmp or X.DataTransfEmp is null)
      group by X.CodigoEmpresa,
             FP.CPFFunc,
             e.DescrRendIsentoOut
      union all
      select X.CodigoEmpresa,
           Fp.CPFFunc,
           e.DescrRendIsentoOut,
           sum(re.ValorEvento) Total
    from FuncContrato X
     Join FuncPessoa FP 
        on FP.CodigoFuncPessoa = X.CodigoFuncPessoa
    join Rescisao r 
      on X.CodigoFuncContr = r.CodigoFuncContr
     and X.CodigoEmpresa = r.CodigoEmpresa
    join RescisaoEvento re
      on r.CodigoEmpresa = re.CodigoEmpresa
        and r.CodigoFuncContr = re.CodigoFuncContr
        and r.Complementar = re.Complementar
    join Evento e
      on re.CodigoEvento = e.CodigoEvento
      where r.DataPgtoResc between :pCompetIni and :pCompetFin
        %s
        and e.OrigemDadoDirf = 1
        and e.LocalInformeDirf = 13
        and e.FormaInformeDirf <> 0
        and re.ValorEvento <> 0
      group by X.CodigoEmpresa,
             FP.CPFFunc,
             e.DescrRendIsentoOut
    ) T
group by T.CodigoEmpresa,
         T.CPFFunc,
         T.DescrRendIsentoOut
order by 1, 2