  select FPC.DataPgtoFolha,
         E.LocalInformeDirf,
         sum(RE.ValorEvento * E.FormaInformeDirf) Valor
   from FuncContrato F 
    join FuncPessoa FP
      on FP.CodigoFuncPessoa = F.CodigoFuncPessoa   
    join Rescisao R
      on R.CodigoEmpresa   = F.CodigoEmpresa
     and R.CodigoFuncContr = F.CodigoFuncContr
    join RescisaoEvento RE
      on RE.CodigoEmpresa = R.CodigoEmpresa
     and RE.CodigoFuncContr = R.CodigoFuncContr
     and RE.Complementar = R.Complementar
    join FuncPerCalculo FPC
      on FPC.CodigoEmpresa = R.CodigoEmpresa
     and FPC.CodigoFuncContr = R.CodigoFuncContr
    join PeriodoCalculo PC
      on PC.CodigoPerCalculo = FPC.CodigoPerCalculo
      and PC.CodigoEmpresa = FPC.CodigoEmpresa
     join Evento E
       on E.CodigoEvento = RE.CodigoEvento
   where F.CodigoEmpresa  = :pCodigoEmpresa
     and FP.CPFFunc        = :pInscrBenef
     and E.OrigemDadoDirf    =  1
     and E.LocalInformeDirf <> 0
     and E.FormaInformeDirf  <> 0
     and ((R.DataResc between PC.DataInicialFolha and PC.DataFinalFolha
     and R.TipoRescisao = 1)
      or (R.DataPgtoResc between PC.DataInicialFolha and PC.DataFinalFolha
     and R.TipoRescisao <> 1))
     and PC.CodigoTipoCalc between 1 and 6
     and FPC.DataPgtoFolha between :pCompetIni and :pCompetFin
group by FPC.DataPgtoFolha,
         E.LocalInformeDirf
order by 1, 2
