  select ad.DataAdto Data,
         sum(ad.ValorAdto)  BaseIRRF,
         sum(ad.ValorIRRF) ValorIRRF
    from FuncContrato f
    join funcPessoa FP
      on Fp.codigofuncPessoa = F.codigofuncPessoa
    join AdtoFerias ad
      on ad.CodigoEmpresa   = f.CodigoEmpresa
     and ad.CodigoFuncContr = f.CodigoFuncContr
   where f.CodigoEmpresa = :pCodigoEmpresa
     and fP.CpfFunc       = :pInscrBenef
     and ad.DataAdto between :pCompetIni and :pCompetFin
     and (ad.DataAdto >= f.DataTransfEmp
      or f.DataTransfEmp is null)
group by ad.DataAdto
union all
  select v.DataVale Data,
         sum(v.ValorBruto) BaseIrrf,
         sum(v.DescontoIR) ValorIRRF
    from FuncContrato f
    join FuncPessoa FP
      on Fp.codigofuncPessoa = F.codigofuncPessoa
    join Vale v
      on V.CodigoEmpresa   = F.CodigoEmpresa
     and V.CodigoFuncContr = F.CodigoFuncContr
    join TipoVale tv
      on tv.CodigoTipoVale  = v.CodigoTipoVale
    join ValeParcela VP
     on  VP.CodigoEmpresa   = V.CodigoEmpresa
     and VP.CodigoFuncContr = V.CodigoFuncContr
     and VP.DataVale        = V.DataVale
     and VP.Seq             = V.Seq
   where f.CodigoEmpresa   = :pCodigoEmpresa
     and fp.CpfFunc         = :pInscrBenef
     and VP.TipoDesconto    = 1
     and v.DataVale between :pCompetIni and :pCompetFin
     and tv.PossuiIRRF     = 1
     and (v.DataVale >= f.DataTransfEmp
      or f.DataTransfEmp is null)
group by v.DataVale
order by 1
