  select E.CODIGOEMPRESA, 
         E.CODIGOESTAB, 
         COALESCE(S.CODIGOSIND, 0) CODIGOSIND, 
         S.NOMESIND, 
         EM.NOMEEMPRESA, 
         E.NOMEESTAB, 
         E.INSCRFEDERAL, 
         TL.DESCRTIPOLOGRAD, 
         E.ENDERECOESTAB, 
         E.NUMENDERESTAB, 
         E.BAIRROENDERESTAB, 
         TLS.DESCRTIPOLOGRAD LOGRADSIND, 
         S.ENDERSIND, 
         S.COMPLENDER, 
         S.BAIRROSIND, 
         S.SIGLAESTADO, 
         S.CEPSIND, 
         S.CODIGOENTID, 
         S.INSCRFEDERAL INSCRFEDERALSIND, 
         M.NOMEMUNIC, 
         CFG.PORTEEMP, 
         CAST(SUM(ES.CAPITALSOCIAL) AS NUMERIC(16,2)) CAPITALSOCIAL, 
         E.CAPITALSOCIAL CAPITALESTAB, 
         A.CODIGOATIVFEDERAL, 
         A.DESCRATIVFEDERAL,
         E.DATAINICIOATIV,
         E.DATAENCERATIV,
         E.EMAIL
    from ESTAB E 
    join TIPOLOGRADOURO  TL
         on TL.CODIGOTIPOLOGRAD = E.CODIGOTIPOLOGRAD
    left join ESTABSIND ES 
         on  E.CODIGOEMPRESA = ES.CODIGOEMPRESA 
         and E.CODIGOESTAB = ES.CODIGOESTAB 
    left join ATIVFEDERAL A 
         on  A.CODIGOATIVFEDERAL = ES.CODIGOATIVFEDERAL 
    left join SINDICATO S 
         on  ES.CODIGOSIND = S.CODIGOSIND 
    left join MUNICIPIO M 
         on  S.SIGLAESTADO = M.SIGLAESTADO 
         and S.CODIGOMUNIC = M.CODIGOMUNIC 
    left join TIPOLOGRADOURO TLS
         on  TLS.CODIGOTIPOLOGRAD = S.CODIGOTIPOLOGRAD
        join CFGEMPRESAFPAOPCAO CFG 
         on  E.CODIGOEMPRESA = CFG.CODIGOEMPRESA 
    join MUNICIPIO M_1 
         on  E.SIGLAESTADO = M_1.SIGLAESTADO 
         and E.CODIGOMUNIC = M_1.CODIGOMUNIC 
    join EMPRESA EM 
         on  E.CODIGOEMPRESA = EM.CODIGOEMPRESA
   where E.DATAINICIOATIV <= :PDATAINICIAL 
     and CFG.DATAOPCAO = ( 
              select max(CFG1.DATAOPCAO) 
                from CFGEMPRESAFPAOPCAO CFG1 
               where CFG1.CODIGOEMPRESA = E.CODIGOEMPRESA 
                 and CFG1.DATAOPCAO <= :PDATAINICIAL) 
     and ES.DATAINICIAL = ( 
              select max(SP.DATAINICIAL) 
                from ESTABConTRIBSINDPER SP 
               where SP.CODIGOEMPRESA = E.CODIGOEMPRESA 
                 and SP.CODIGOESTAB = E.CODIGOESTAB 
                 and SP.DATAINICIAL <= :PDATAINICIAL)
     %0:s				 
        
group by E.CODIGOEMPRESA, 
         E.CODIGOESTAB, 
         S.CODIGOSIND, 
         S.NOMESIND, 
         EM.NOMEEMPRESA, 
         E.NOMEESTAB, 
         E.INSCRFEDERAL, 
         TL.DESCRTIPOLOGRAD, 
         E.ENDERECOESTAB, 
         E.NUMENDERESTAB, 
         E.BAIRROENDERESTAB, 
         TLS.DESCRTIPOLOGRAD, 
         S.ENDERSIND, 
         S.COMPLENDER, 
         S.BAIRROSIND, 
         S.SIGLAESTADO, 
         S.CEPSIND, 
         S.CODIGOENTID, 
         S.INSCRFEDERAL, 
         M.NOMEMUNIC, 
         CFG.PORTEEMP, 
         E.CAPITALSOCIAL, 
         A.CODIGOATIVFEDERAL, 
         A.DESCRATIVFEDERAL,
         E.DATAINICIOATIV,
         E.DATAENCERATIV,
         E.EMAIL	 

union  

  select E.CODIGOEMPRESA, 
         E.CODIGOESTAB, 
         0 CODIGOSIND, 
         '' NOMESIND, 
         EM.NOMEEMPRESA, 
         E.NOMEESTAB, 
         E.INSCRFEDERAL, 
         TL.DESCRTIPOLOGRAD, 
         E.ENDERECOESTAB, 
         E.NUMENDERESTAB, 
         E.BAIRROENDERESTAB, 
         TLS.DESCRTIPOLOGRAD LOGRADSIND, 
         S.ENDERSIND, 
         S.COMPLENDER, 
         S.BAIRROSIND, 
         S.SIGLAESTADO, 
         S.CEPSIND, 
         S.CODIGOENTID, 
         S.INSCRFEDERAL INSCRFEDERALSIND, 
         M.NOMEMUNIC, 
         CFG.PORTEEMP, 
         CAST(SUM(ES.CAPITALSOCIAL) AS NUMERIC(16,2)) CAPITALSOCIAL, 
         E.CAPITALSOCIAL CAPITALESTAB, 
         A.CODIGOATIVFEDERAL, 
         A.DESCRATIVFEDERAL,
         E.DATAINICIOATIV,
         E.DATAENCERATIV,
         E.EMAIL
    from ESTAB E 
      join TIPOLOGRADOURO  TL
         on  TL.CODIGOTIPOLOGRAD = E.CODIGOTIPOLOGRAD
    left join ESTABSIND ES 
         on  E.CODIGOEMPRESA = ES.CODIGOEMPRESA 
         and E.CODIGOESTAB = ES.CODIGOESTAB 
    left join ATIVFEDERAL A 
         on  A.CODIGOATIVFEDERAL = ES.CODIGOATIVFEDERAL 
    left join SINDICATO S 
         on  ES.CODIGOSIND = S.CODIGOSIND 
    left join MUNICIPIO M 
         on  S.SIGLAESTADO = M.SIGLAESTADO 
         and S.CODIGOMUNIC = M.CODIGOMUNIC 
    left join TIPOLOGRADOURO TLS
         on  TLS.CODIGOTIPOLOGRAD = S.CODIGOTIPOLOGRAD
    join CFGEMPRESAFPAOPCAO CFG 
         on  E.CODIGOEMPRESA = CFG.CODIGOEMPRESA 
    join MUNICIPIO M_1 
         on  E.SIGLAESTADO = M_1.SIGLAESTADO 
         and E.CODIGOMUNIC = M_1.CODIGOMUNIC 
    join EMPRESA EM 
         on  E.CODIGOEMPRESA = EM.CODIGOEMPRESA
   where E.DATAINICIOATIV <= :PDATAINICIAL 
     and CFG.DATAOPCAO = ( 
             select max(CFG1.DATAOPCAO) 
               from CFGEMPRESAFPAOPCAO CFG1 
              where CFG1.CODIGOEMPRESA = E.CODIGOEMPRESA 
                and CFG1.DATAOPCAO <= :PDATAINICIAL) 
     and not exists( 
             select 1 
               from ESTABConTRIBSINDPER SP 
              where SP.CODIGOEMPRESA = E.CODIGOEMPRESA 
                and SP.CODIGOESTAB = E.CODIGOESTAB 
                and SP.DATAINICIAL <= :PDATAINICIAL)
     %0:s				
          
group by E.CODIGOEMPRESA, 
         E.CODIGOESTAB, 
         S.CODIGOSIND, 
         S.NOMESIND, 
         EM.NOMEEMPRESA, 
         E.NOMEESTAB, 
         E.INSCRFEDERAL, 
         TL.DESCRTIPOLOGRAD, 
         E.ENDERECOESTAB, 
         E.NUMENDERESTAB, 
         E.BAIRROENDERESTAB, 
         TLS.DESCRTIPOLOGRAD, 
         S.ENDERSIND, 
         S.COMPLENDER, 
         S.BAIRROSIND, 
         S.SIGLAESTADO, 
         S.CEPSIND, 
         S.CODIGOENTID, 
         S.INSCRFEDERAL, 
         M.NOMEMUNIC, 
         CFG.PORTEEMP, 
         E.CAPITALSOCIAL, 
         A.CODIGOATIVFEDERAL, 
         A.DESCRATIVFEDERAL,
         E.DATAINICIOATIV,
         E.DATAENCERATIV,
         E.EMAIL