SELECT E.CODIGOEMPRESA,
       EE.CODIGOESTAB,
       COALESCE(S.CODIGOSIND, 0) CodigoSind, 
       S.NOMESIND,
       E.NOMEEMPRESA,
       EE.NOMEESTAB,
       EE.APELIDOESTAB,
       EE.INSCRFEDERAL,
       CAST(SUM(ES.CAPITALSOCIAL) AS NUMERIC(16,2)) CAPITALSOCIALSIND,
       EE.CAPITALSOCIAL,
       EE.DATAINICIOATIV,
       EE.DATAENCERATIV
FROM ESTAB EE
 LEFT JOIN ESTABSIND ES
        ON EE.CODIGOEMPRESA = ES.CODIGOEMPRESA
       and EE.CODIGOESTAB = ES.CODIGOESTAB
 LEFT JOIN SINDICATO S
        ON ES.CODIGOSIND = S.CODIGOSIND
INNER JOIN EMPRESA E
        ON EE.CODIGOEMPRESA = E.CODIGOEMPRESA
     WHERE EE.DATAINICIOATIV <= :pDataInicial
       AND ES.DATAINICIAL = (
           SELECT MAX(SP.DATAINICIAL)
              FROM ESTABCONTRIBSINDPER SP
              WHERE SP.CODIGOEMPRESA = E.CODIGOEMPRESA
                AND SP.CODIGOESTAB = EE.CODIGOESTAB
                AND SP.DATAINICIAL <= :pDataInicial)               
%0:s

GROUP BY E.CODIGOEMPRESA,
        EE.CODIGOESTAB,
         S.CODIGOSIND,
         S.NOMESIND,
         E.NOMEEMPRESA,
        EE.NOMEESTAB,
        EE.APELIDOESTAB,
        EE.INSCRFEDERAL,
        EE.CAPITALSOCIAL,
        EE.DATAINICIOATIV,
        EE.DATAENCERATIV
       
UNION
 
SELECT E.CODIGOEMPRESA,
      EE.CODIGOESTAB,
       0 CODIGOSIND,
       '' NOMESIND,
       E.NOMEEMPRESA,
      EE.NOMEESTAB,
      EE.APELIDOESTAB,
      EE.INSCRFEDERAL,
      CAST(0 AS NUMERIC(16,2)) CAPITALSOCIALSIND,
      EE.CAPITALSOCIAL,
      EE.DATAINICIOATIV,
      EE.DATAENCERATIV
FROM ESTAB EE
 LEFT JOIN ESTABSIND ES
        ON EE.CODIGOEMPRESA = ES.CODIGOEMPRESA
       and EE.CODIGOESTAB = ES.CODIGOESTAB
 LEFT JOIN SINDICATO S
        ON ES.CODIGOSIND = S.CODIGOSIND
INNER JOIN EMPRESA E
        ON EE.CODIGOEMPRESA = E.CODIGOEMPRESA
     WHERE EE.DATAINICIOATIV <= :pDataInicial
       AND NOT EXISTS (
           SELECT 1
              FROM ESTABCONTRIBSINDPER SP
              WHERE SP.CODIGOEMPRESA = E.CODIGOEMPRESA
                AND SP.CODIGOESTAB = EE.CODIGOESTAB
                AND SP.DATAINICIAL <= :pDataInicial)               
%0:s

GROUP BY E.CODIGOEMPRESA,
        EE.CODIGOESTAB,
         S.CODIGOSIND,
         S.NOMESIND,
         E.NOMEEMPRESA,
        EE.NOMEESTAB,
        EE.APELIDOESTAB,
        EE.INSCRFEDERAL,
        EE.CAPITALSOCIAL,
        EE.DATAINICIOATIV,
        EE.DATAENCERATIV
ORDER BY 1, 2