select A.CodigoEvento,
       A.ValorEvento,
       A.ReferEvento,
       A.CodigoCentroCusto,
       A.CodigoOutEmp,
       E.CodigoEstrut,
       A.CodigoProfTipoAula,
	   cast('0' as Varchar(1)) BuscarUltValorCalc 
  from EventoFixo A, Evento E
 where A.CodigoEvento = E.CodigoEvento
   and A.CodigoEmpresa = :CodigoEmpresa
   and A.CodigoFuncContr    = :CodigoFuncContr
   and ((A.CompetInicial <= :pCompet) or (A.CompetInicial is null))
   and ((A.CompetFinal   >= :pCompet) or (A.CompetFinal   is null))
   and not exists (Select CodigoEvento
                     from EventoVariavel B
                    where B.CodigoEmpresa    = A.CodigoEmpresa
                      and B.CodigoFuncContr  = A.CodigoFuncContr
                      and B.CodigoEvento     = A.CodigoEvento
                      and (B.CodigoOutEmp    = A.CodigoOutEmp
                       or B.CodigoOutEmp is null)
                      and (B.CodigoCentroCusto=A.CodigoCentroCusto
                       or B.CodigoCentroCusto is null)
                      and (B.CodigoProfTipoAula=A.CodigoProfTipoAula
                       or B.CodigoProfTipoAula is null)
                      and B.CodigoPerCalculo = :CodigoPerCalculo)

union

select A.CodigoEvento,
       A.ValorEvento,
       A.ReferEvento,
       A.CodigoCentroCusto,
       A.CodigoOutEmp,
       E.CodigoEstrut,
       A.CodigoProfTipoAula,
	   cast('0' as Varchar(1)) BuscarUltValorCalc 
  from EventoEmpresa A, Evento E
 where A.CodigoEvento = E.CodigoEvento
   and A.CodigoEmpresa = :CodigoEmpresa
   and ((A.CompetInicial <= :pCompet) or (A.CompetInicial is null))
   and ((A.CompetFinal   >= :pCompet) or (A.CompetFinal   is null))
   and not exists (Select CodigoEvento
                     from EventoFixo B
                    where B.CodigoEmpresa    = A.CodigoEmpresa
                      and B.CodigoFuncContr  = :CodigoFuncContr
                      and B.CodigoEvento     = A.CodigoEvento
                      and (B.CodigoOutEmp     = A.CodigoOutEmp
                       or B.CodigoOutEmp is null)
                      and (B.CodigoCentroCusto=A.CodigoCentroCusto
                       or B.CodigoCentroCusto is null)
                      and (B.CodigoProfTipoAula = A.CodigoProfTipoAula
                       or B.CodigoProfTipoAula is null))

   and not exists (Select CodigoEvento
                     from EventoVariavel B
                    where B.CodigoEmpresa    = A.CodigoEmpresa
                      and B.CodigoFuncContr  = :CodigoFuncContr
                      and B.CodigoEvento     = A.CodigoEvento
                      and (B.CodigoOutEmp    = A.CodigoOutEmp
                       or B.CodigoOutEmp is null)
                      and (B.CodigoCentroCusto = A.CodigoCentroCusto
                       or B.CodigoCentroCusto is null)
                      and (B.CodigoProfTipoAula = A.CodigoProfTipoAula
                       or B.CodigoProfTipoAula is null)
                      and B.CodigoPerCalculo = :CodigoPerCalculo)

union

select A.CodigoEvento,
       A.ValorEvento,
       A.ReferEvento,
       A.CodigoCentroCusto,
       A.CodigoOutEmp,
       E.CodigoEstrut,
       A.CodigoProfTipoAula,
	   A.BuscarUltValorCalc
  from EventoVariavel A, Evento E
 where A.CodigoEvento = E.CodigoEvento
   and A.CodigoEmpresa    = :CodigoEmpresa
   and A.CodigoFuncContr  = :CodigoFuncContr
   and A.CodigoPerCalculo = :CodigoPerCalculo
order by 1
