  select Cast('D' As VarChar(1)) Origem
       , Cast(DF.VALORDEVIDO as numeric(18,2)) Valor
       , min(C.DATAPAGAMENTO) DataPgto
       , D.DATAVENCIMENTO DataVcto
       , DF.DATALCTOCTR Compet
    from DEBITOFGTSFUNC DF
    join DEBITOFGTS D
      on D.CODIGOEMPRESA = DF.CODIGOEMPRESA
     and D.CHAVEDEBITOFGTS = DF.CHAVEDEBITOFGTS
    join CREDITOFGTS C
      on C.CODIGOEMPRESA = D.CODIGOEMPRESA
     and C.CHAVEDEBITOFGTS = D.CHAVEDEBITOFGTS
   where DF.CODIGOEMPRESA = :pCodigoEmpresa
     and DF.CodigoFuncContr = :pCodigoFuncContr
     and D.DATAVENCIMENTO between :pDataIni and :pDataFim

group by DF.VALORDEVIDO
       , D.DATAVENCIMENTO
       , DF.DATALCTOCTR
       , D.CHAVEDEBITOFGTS

UNION ALL

select Cast('Q' As VarChar(1)) Origem,
       Cast((s.Valor * -1) as numeric(18,2)),
       s.DataSaque DataPgto,
       s.DataSaque DataVcto,
       s.DataSaque Compet
  from FGTSFuncSaque s
 where s.CodigoEmpresa = :pCodigoEmpresa
   and s.CodigoFuncContr = :pCodigoFuncContr
   and s.DataSaque between :pDataIni and :pDataFim
 order by 5, 3, 4

