SELECT E.CODIGOEMPRESA,
       EE.CODIGOESTAB,
       S.CODIGOSIND, 
       S.NOMESIND,
       E.NOMEEMPRESA,
       EE.NOMEESTAB,
       EE.APELIDOESTAB,
       TP.CODIGOTABELAPATRONAL,
       TP.DESCRTABELAPATRONAL,
       FP.DATAINICIAL,
       FP.LIMITEDE,
       FP.LIMITEATE,
       FP.ALIQUOTA,
       FP.PARCELAADIC,
       SUM(ES.CAPITALSOCIAL) CAPITALSOCIALSIND
FROM ESTAB EE
 JOIN ESTABSIND ES
        ON EE.CODIGOEMPRESA = ES.CODIGOEMPRESA
       and EE.CODIGOESTAB = ES.CODIGOESTAB
 JOIN SINDICATO S
        ON ES.CODIGOSIND = S.CODIGOSIND
 JOIN EMPRESA E
        ON EE.CODIGOEMPRESA = E.CODIGOEMPRESA
 JOIN FAIXAPATRONAL FP
        ON FP.CODIGOTABELAPATRONAL = ES.CODIGOTABELAPATRONAL
 JOIN TABELAPATRONAL TP
        ON TP.CODIGOTABELAPATRONAL = FP.CODIGOTABELAPATRONAL               
     WHERE ES.DATAINICIAL = (
           SELECT MAX(SP.DATAINICIAL)
             FROM ESTABCONTRIBSINDPER SP
            WHERE SP.CODIGOEMPRESA = E.CODIGOEMPRESA
              AND SP.CODIGOESTAB = EE.CODIGOESTAB
              AND SP.DATAINICIAL <= :pDataInicial)
         AND FP.DATAINICIAL = ( 
           SELECT MAX(TPP.DATAINICIAL) 
             FROM TABELAPATRONALPERIODO TPP
            WHERE TPP.CODIGOTABELAPATRONAL = TP.CODIGOTABELAPATRONAL
              AND TPP.DATAINICIAL <= :pDataInicial)   
%0:s              
GROUP BY E.CODIGOEMPRESA,
         EE.CODIGOESTAB,
         S.CODIGOSIND, 
         S.NOMESIND,
         E.NOMEEMPRESA,
         EE.NOMEESTAB,
         EE.APELIDOESTAB,
         TP.CODIGOTABELAPATRONAL,
         TP.DESCRTABELAPATRONAL,
         FP.DATAINICIAL,
         FP.LIMITEDE,
         FP.LIMITEATE,
         FP.ALIQUOTA,
         FP.PARCELAADIC
HAVING SUM(ES.CAPITALSOCIAL) BETWEEN FP.LIMITEDE AND FP.LIMITEATE                          
ORDER BY 1, 2, 3 