select pc.Compet,
       cast(sum(ce.BaseEvento) as numeric(18,2)) Base,
       cast(sum(ce.ReferEvento) as numeric(16,2)) Refer
  from PeriodoCalculo pc
  join CalculoEvento ce
    on pc.CodigoEmpresa = ce.CodigoEmpresa
   and pc.CodigoPerCalculo = ce.CodigoPerCalculo
  join Evento e
    on ce.CodigoEvento = e.CodigoEvento
 where pc.CodigoEmpresa = :pCodigoEmpresa
   and ce.CodigoFuncContr = :pCodigoFuncContr
   and pc.Compet between :pCompetInicial and :pCompetFinal
   and pc.CodigoTipoCalc = 1
   and (e.CodigoEstrut = '02.07.01.01'
    or e.CodigoEstrut = '02.07.02.01'
    or e.CodigoEstrut = '02.07.01.04'
    or e.CodigoEstrut = '02.07.02.04'
    or e.CodigoEstrut = '02.07.01.05'
    or e.CodigoEstrut = '02.07.02.05')	
 group by pc.Compet
 
 union all
 
select r.DataResc Compet,
   cast(sum(re.BaseEvento) as numeric(18,2)) Base,
   cast(sum(re.ReferEvento) as numeric(16,2)) Refer
  from Rescisao r
  join RescisaoEvento re
    on r.CodigoEmpresa = re.CodigoEmpresa
   and r.CodigoFuncContr = re.CodigoFuncContr
  join Evento e
    on re.CodigoEvento = e.CodigoEvento
 where r.CodigoEmpresa = :pCodigoEmpresa
   and r.CodigoFuncContr = :pCodigoFuncContr
   and r.Complementar = 1
   and (e.CodigoEstrut = '02.07.01.01'
    or e.CodigoEstrut = '02.07.02.01'
    or e.CodigoEstrut = '02.07.01.04'
    or e.CodigoEstrut = '02.07.02.04'
    or e.CodigoEstrut = '02.07.01.05'
    or e.CodigoEstrut = '02.07.02.05') 
   and not exists(
Select 1
  from PeriodoCalculo pc
  join FuncPerCalculo fpc
    on fpc.CodigoEmpresa = pc.CodigoEmpresa
   and fpc.CodigoPerCalculo = pc.CodigoPerCalculo
 where fpc.CodigoEmpresa = R.CodigoEmpresa
   and fpc.CodigoFuncContr = R.CodigoFuncContr
   and pc.Compet between :pDataInicial and :pDataFinal 
  )
group by r.DataResc
