Merge into FeriasEvDcto D
using(
 select CodigoEmpresa, 
        CodigoFuncContr, 
        DataInicial,
        DataInicialFerias, 
        cast(:CodigoPerCalculo as Integer) CodigoPerCalculo, 
        cast(:CodigoEvento as Integer) CodigoEvento, 
        cast(:Seq as Integer) Seq, 
        SeqReciboFerias,
        cast(:CodigoProfTipoAula as Integer) CodigoProfTipoAula, 
        cast(:BaseEvento as Numeric (18,9))BaseEvento, 
        cast(:ReferEvento as Numeric(16,2)) ReferEvento, 
        cast(:ValorEvento as Numeric (14,2)) ValorEvento,
        cast(:OrigemDado as Integer) OrigemDado
  from RECIBOFERIAS 
 where CodigoEmpresa  = :CodigoEmpresa
   and CodigoFuncContr = :CodigoFuncContr
   and DataInicial = :DataInicialPerAquis
   and DataInicialFerias = :DataInicialFerias
   and SeqReciboFerias = :SeqReciboFerias) O 
    ON (D.CodigoEmpresa = O.CodigoEmpresa and 
        D.CodigoFuncContr = O.CodigoFuncContr and 
        D.DataInicial = O.DataInicial and 
        D.DataInicialFerias = O.DataInicialFerias and 
        D.SeqReciboFerias = O.SeqReciboFerias and
        D.CodigoEvento = O.CodigoEvento and
        D.CodigoPerCalculo = O.CodigoPerCalculo and
        D.CodigoProfTipoAula = O.CodigoProfTipoAula)
when not matched THEN 
insert   (CodigoEmpresa, 
          CodigoFuncContr, 
          DataInicial,
          DataInicialFerias, 
          CodigoPerCalculo, 
          CodigoEvento, 
          Seq, 
          SeqReciboFerias, 
          CodigoProfTipoAula, 
          BaseEvento, 
          ReferEvento, 
          ValorEvento,
          OrigemDado)
  values (O.CodigoEmpresa, 
          O.CodigoFuncContr, 
          O.DataInicial,
          O.DataInicialFerias, 
          O.CodigoPerCalculo, 
          O.CodigoEvento, 
          O.Seq,
          O.SeqReciboFerias, 
          O.CodigoProfTipoAula, 
          O.BaseEvento, 
          O.ReferEvento, 
          O.ValorEvento,
          O.OrigemDado)
