  select fhp.CodigoEmpresa,
         fhp.CodigoFuncContr,
         fhp.DiaSemana,
         fhp.CodigoEvento,
         fhp.CodigoCentroCusto,
         fhp.CodigoOutEmp,
         E.CodigoEstrut,
         E.OrdemCalculo,
         E.ValorCalculo,
         sum(fhp.NumeroHoras) NumeroHoras,
         fhp.DataInicial
    from FuncHorProf fhp,
         Evento e
   where fhp.CodigoEmpresa = :CodigoEmpresa
     and fhp.CodigoFuncContr    = :CodigoFuncContr
     and e.CodigoEvento    = fhp.CodigoEvento
     and fhp.DataInicial   = (select max(a.DataInicial)
                                from FuncHorProf a
                               where a.CodigoEmpresa = :CodigoEmpresa
                                 and a.CodigoFuncContr    = :CodigoFuncContr
                                 and a.DiaSemana     = fhp.DiaSemana
                                 and a.DataInicial   <= :Data)
group by fhp.CodigoEmpresa,
         fhp.CodigoFuncContr,
         fhp.DiaSemana,
         fhp.CodigoEvento,
         fhp.CodigoCentroCusto,
         fhp.CodigoOutEmp,
         e.CodigoEstrut,
         E.OrdemCalculo,
         E.ValorCalculo,
         fhp.DataInicial
order by 1, 2, 3, 4, 5, 6
