SELECT FS.DATAINICIAL AS FSDATAINICIAL,
       CAST(NULL AS INTEGER) AS FSPCODIGOPROFTIPOAULA,
       CAST(NULL AS VARCHAR(150)) AS PTADESCRPROFTIPOAULA,
       FS.VALORSAL AS FSVALORSAL,
       FS.TIPOSALARIO AS FSTIPOSALARIO,
       FS.CODIGOESTRUTSAL AS FSCODIGOESTRUTSAL,
       FS.CODIGOTABSAL AS FSCODIGOTABSAL,
       FS.CODIGOMOTIVO AS FSCODIGOMOTIVO,
       FS.COMPLSAL AS FSCOMPLSAL,
       FS.ANTECSAL AS FSANTECSAL,
       M.DESCRMOTIVO AS MOTDESCRMOTIVO,
       FS.CODIGOEMPRESA AS FSCODIGOEMPRESA,
       FS.PERCAUMENTO AS FSPERCAUMENTO,
	   FS.DATAEFEITO AS FSDATAEFEITO,
	   FS.SEQ AS FSSEQ
  FROM FUNCSALARIO FS
  JOIN FUNCCONTRATO FC 
    ON FC.CODIGOEMPRESA = FS.CODIGOEMPRESA
   AND FC.CODIGOFUNCCONTR = FS.CODIGOFUNCCONTR
   AND FC.FORMACALCULO = 1
  JOIN MOTIVO M 
    ON M.CODIGOMOTIVO = FS.CODIGOMOTIVO
 WHERE FS.CODIGOEMPRESA = :CODIGOEMPRESA
   AND FS.CODIGOFUNCCONTR = :CODIGOFUNCCONTR
   AND (FS.DATAINICIAL = (SELECT MAX(FSM.DATAINICIAL)
                            FROM FUNCSALARIO FSM
                           WHERE FSM.CODIGOEMPRESA = :CODIGOEMPRESA
                             AND FSM.CODIGOFUNCCONTR = :CODIGOFUNCCONTR)
    OR (FS.DATAINICIAL = (SELECT MAX(FSS.DATAINICIAL)
                           FROM FUNCSALARIO FSS
                          WHERE FSS.CODIGOEMPRESA = :CODIGOEMPRESA
                            AND FSS.CODIGOFUNCCONTR = :CODIGOFUNCCONTR
                            AND FSS.DATAINICIAL < (SELECT MAX(FSSS.DATAINICIAL)
                                                     FROM FUNCSALARIO FSSS
                                                    WHERE FSSS.CODIGOEMPRESA = :CODIGOEMPRESA 
                                                      AND FSSS.CODIGOFUNCCONTR = :CODIGOFUNCCONTR)
                            AND NOT EXISTS(SELECT 1 
                                             FROM FUNCSALARIO FSM
                                            WHERE FSM.CODIGOEMPRESA = FSS.CODIGOEMPRESA
                                              AND FSM.CODIGOFUNCCONTR = FSS.CODIGOFUNCCONTR
                                              AND FSM.DATAINICIAL > FSS.DATAINICIAL 
                                              AND FSM.SEQ > 1))))
    AND (FS.SEQ = (SELECT MAX(FSM.SEQ)
                     FROM FUNCSALARIO FSM
                    WHERE FSM.CODIGOEMPRESA = :CODIGOEMPRESA
                      AND FSM.CODIGOFUNCCONTR = :CODIGOFUNCCONTR)
    OR FS.SEQ = (SELECT MAX(FSS.SEQ)
                  FROM FUNCSALARIO FSS
                 WHERE FSS.CODIGOEMPRESA = :CODIGOEMPRESA
                   AND FSS.CODIGOFUNCCONTR = :CODIGOFUNCCONTR
                   AND FSS.SEQ < (SELECT MAX(FSSS.SEQ)
                                   FROM FUNCSALARIO FSSS
                                  WHERE FSSS.CODIGOEMPRESA = :CODIGOEMPRESA
                                    AND FSSS.CODIGOFUNCCONTR = :CODIGOFUNCCONTR)))
 GROUP BY FS.DATAINICIAL,
          FS.VALORSAL,
          FS.TIPOSALARIO,
          FS.CODIGOESTRUTSAL,
          FS.CODIGOTABSAL,
          FS.CODIGOMOTIVO,
          FS.COMPLSAL,
          FS.ANTECSAL,
          M.DESCRMOTIVO,
          FS.CODIGOEMPRESA,
          FS.PERCAUMENTO,
	      FS.DATAEFEITO,
		  FS.SEQ		  
 UNION
  
SELECT FSP.DATAINICIAL AS FSDATAINICIAL,
       FSP.CODIGOPROFTIPOAULA AS FSPCODIGOPROFTIPOAULA,
       PTA.DESCRPROFTIPOAULA AS PTADESCRPROFTIPOAULA,
       FSP.VALORAULA AS FSVALORSAL,
       FS.TIPOSALARIO AS FSTIPOSALARIO,
       FS.CODIGOESTRUTSAL AS FSCODIGOESTRUTSAL,
       FS.CODIGOTABSAL AS FSCODIGOTABSAL,
       FS.CODIGOMOTIVO AS FSCODIGOMOTIVO,
       FS.COMPLSAL AS FSCOMPLSAL,
       FS.ANTECSAL AS FSANTECSAL,
       M.DESCRMOTIVO AS MOTDESCRMOTIVO,
       FS.CODIGOEMPRESA AS FSCODIGOEMPRESA,
       FS.PERCAUMENTO AS FSPERCAUMENTO,
	   FS.DATAEFEITO AS FSDATAEFEITO,
	   FS.SEQ AS FSSEQ
  FROM FUNCSALARIO FS
  JOIN FUNCCONTRATO FC 
    ON FC.CODIGOEMPRESA = FS.CODIGOEMPRESA
   AND FC.CODIGOFUNCCONTR = FS.CODIGOFUNCCONTR
   AND FC.FORMACALCULO IN (2, 3)
  JOIN FUNCCONTRATOPROF FCP 
    ON FCP.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FCP.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
   AND FCP.DATAINICIAL <= FS.DATAINICIAL
  JOIN FUNCSALARIOPROF FSP 
    ON FSP.CODIGOEMPRESA = FS.CODIGOEMPRESA
   AND FSP.CODIGOFUNCCONTR = FS.CODIGOFUNCCONTR
   AND FSP.DATAINICIAL = FS.DATAINICIAL
  JOIN MOTIVO M 
    ON M.CODIGOMOTIVO = FS.CODIGOMOTIVO
  JOIN PROFTIPOAULA PTA 
    ON PTA.CODIGOPROFTIPOAULA = FSP.CODIGOPROFTIPOAULA
   AND PTA.CODIGOEMPRESA = FSP.CODIGOEMPRESA
 WHERE FS.CODIGOEMPRESA = :CODIGOEMPRESA
   AND FS.CODIGOFUNCCONTR = :CODIGOFUNCCONTR
   AND (FS.DATAINICIAL = (SELECT MAX(FSM.DATAINICIAL)
                            FROM FUNCSALARIO FSM
                           WHERE FSM.CODIGOEMPRESA = :CODIGOEMPRESA
                             AND FSM.CODIGOFUNCCONTR = :CODIGOFUNCCONTR)
    OR (FS.DATAINICIAL = (SELECT MAX(FSS.DATAINICIAL)
                           FROM FUNCSALARIO FSS
                          WHERE FSS.CODIGOEMPRESA = :CODIGOEMPRESA
                            AND FSS.CODIGOFUNCCONTR = :CODIGOFUNCCONTR
                            AND FSS.DATAINICIAL < (SELECT MAX(FSSS.DATAINICIAL)
                                                     FROM FUNCSALARIO FSSS
                                                    WHERE FSSS.CODIGOEMPRESA = :CODIGOEMPRESA 
                                                      AND FSSS.CODIGOFUNCCONTR = :CODIGOFUNCCONTR)
                            AND NOT EXISTS(SELECT 1 
                                             FROM FUNCSALARIO FSM
                                            WHERE FSM.CODIGOEMPRESA = FSS.CODIGOEMPRESA
                                              AND FSM.CODIGOFUNCCONTR = FSS.CODIGOFUNCCONTR
                                              AND FSM.DATAINICIAL > FSS.DATAINICIAL 
                                              AND FSM.SEQ > 1))))
    AND (FS.SEQ = (SELECT MAX(FSM.SEQ)
                     FROM FUNCSALARIO FSM
                    WHERE FSM.CODIGOEMPRESA = :CODIGOEMPRESA
                      AND FSM.CODIGOFUNCCONTR = :CODIGOFUNCCONTR)
    OR FS.SEQ = (SELECT MAX(FSS.SEQ)
                  FROM FUNCSALARIO FSS
                 WHERE FSS.CODIGOEMPRESA = :CODIGOEMPRESA
                   AND FSS.CODIGOFUNCCONTR = :CODIGOFUNCCONTR
                   AND FSS.SEQ < (SELECT MAX(FSSS.SEQ)
                                   FROM FUNCSALARIO FSSS
                                  WHERE FSSS.CODIGOEMPRESA = :CODIGOEMPRESA
                                    AND FSSS.CODIGOFUNCCONTR = :CODIGOFUNCCONTR)))
GROUP BY FSP.DATAINICIAL,
          FSP.CODIGOPROFTIPOAULA,
          PTA.DESCRPROFTIPOAULA,
          FSP.VALORAULA,
          FS.TIPOSALARIO,
          FS.CODIGOESTRUTSAL,
          FS.CODIGOTABSAL,
          FS.CODIGOMOTIVO,
          FS.COMPLSAL,
          FS.ANTECSAL,
          M.DESCRMOTIVO,
          FS.CODIGOEMPRESA,
          FS.PERCAUMENTO,
	      FS.DATAEFEITO,
		  FS.SEQ
 ORDER BY 1