
insert into FuncaoEmpresa (CodigoEmpresa, CodigoFuncao, DataInicial, Status)
select cast(:CodigoEmpresaDest as Integer) CodigoEmpresaDest,
       FC.CodigoFuncao,
       CAST('01.01.1900' AS DATE) as DataInicial,
       CAST(1 AS INTEGER)
from FuncCargo FC
where FC.CodigoEmpresa = :CodigoEmpresaOrig
  and FC.CodigoFuncContr = :CodigoFuncContrOrig
  and FC.CodigoFuncao > cast(0 as Integer)
  and FC.DataInicial =
    (SELECT MAX(FCMS.DataInicial)
     FROM FuncCargo FCMS
     WHERE FCMS.CodigoEmpresa = FC.CodigoEmpresa
       AND FCMS.CodigoFuncContr = FC.CodigoFuncContr)
  and not exists(select 1 from FuncaoEmpresa FE where FE.CodigoEmpresa = :CodigoEmpresaDest and FE.CodigoFuncao = FC.CodigoFuncao)