SELECT 
	FC.CODIGOEMPRESA,
	FC.CODIGOFUNCCONTR,
	FP.NOMEFUNC,
	UPPER(FP.NOMEFUNC) AS NOMEFUNCMAIUSC,
	FP.DATANASC DataNascimentoFunc,
	FP.SIGLAESTADONASC,
	MNac.NOMEMUNIC,
	FP.ESTADOCIVIL,
	PO.NOMEPAIS AS PaisOrigem,
	FP.NACIONALIDADE,
	FP.DATANATURAL,
	FP.DATACHEGADA,
	FP.TIPOVISTO,
	cast(FTD.NUMEROCTPS as varchar(20)) || '/' || cast(FTD.SERIECTPS as varchar(10)) AS NumeroSerieEcTPS,
	FTD.SERIECTPS,
	FTD.SIGLAESTADOCTPS,
	FTD.EXPEDCTPS,
	FP.PISFUNC, 
	FP.CPFFUNC,
	FC.NUMEROINSCRINSS,
	FP.NUMERORG,
	OM.SIGLAORGAOEMISSOR || '/' || FP.SIGLAESTADORG AS SiglaOrgaoEmissoreEstado,
	FP.EMISSRG DataEmissaoRG,
	FP.CNHFUNC,
	FP.CATEGCNH,
	FP.EXPEDICAOCNH,
	FP.VALIDCNH,
	FP.NUMEROREGIST,
	FP.DATAREGIST,
	FP.VALIDADEREGIST,
	FP.EXPEDICAORNE,
	FP.VALIDRNE,
	TL.DESCRTIPOLOGRAD,
	FP.ENDERFUNC,
	FP.NUMEROENDER,
	FP.COMPLENDER,
	FP.BAIRROFUNC,
	FP.SIGLAESTADO,
	MN.NOMEMUNIC,
	FP.CEPFUNC,
	FP.DDDFONE || '-' || FP.NUMEROFONE AS DddFone,
	FP.DDDCELULAR || '-' || FP.NUMEROCELULAR DddCelular,
	FP.ENDERELETR EmailFunc,
	FC.DATAADM AS DATAADMISSAOFUNC,
	COALESCE(FUNCLOCALDATATRANSDATAINICIAL.DATATRANSF, FUNCLOCALDATATRANSDATAFINAL.DATATRANSF) as DataTransfEntrada,
	FC.DIACONTREXP DiasContratoExp,
	FC.DIAPRORROGCONTREXP DiasProrrogacaoContratoExp,
	FC.DATAADM as DataInicioContratoExp,
	({TIMESTAMPADD('DAY', (FC.DIACONTREXP - 1), (FC.DATAADM))}) DataFimContratoExperiencia,
	({TIMESTAMPADD('DAY', (FC.DIACONTREXP), (FC.DATAADM))}) DataInicioProrrogContratoExp,
	({TIMESTAMPADD('DAY', (FC.DIAPRORROGCONTREXP -1), ({TIMESTAMPADD('DAY', (FC.DIACONTREXP), (FC.DATAADM))}))}) AS DataFimProrrogacaoContratoExp,
	({TIMESTAMPADD('DAY', (FC.DIAPRORROGCONTREXP), ({TIMESTAMPADD('DAY', (FC.DIACONTREXP), (FC.DATAADM))}))}) AS DataFimProrrogacaoContratoExp,
	FC.CHAPEIRA,
	FUNCPRIMEIROSALARIO.TIPOSALARIO as PrimeiroSalarioTipo,
	CAST(FUNCPRIMEIROSALARIO.VALORSAL AS numeric(15, 2)) as PrimeiroSalarioValorSalario,
	case when FUNCADICIONALPRIMEIROSALARIO.PERCINSALUB > 0 then 
		cast(CAST(FUNCPRIMEIROSALARIO.VALORSAL AS numeric(15, 2)) as varchar(30)) || ' Acrescido de ' || cast(FUNCADICIONALPRIMEIROSALARIO.PERCINSALUB as varchar(10)) ||' Porcent. de insalubridade'
		else cast(CAST(FUNCPRIMEIROSALARIO.VALORSAL AS numeric(15, 2)) as varchar(30)) || ' Acrescido de '|| cast(FUNCADICIONALPRIMEIROSALARIO.PERCPERICUL as varchar(10)) ||' Porcent. de periculosidade' 
	end as PrimeiroSalarioAdicional,
	CAST(FUNCPRIMEIROSALARIO.COMPLSAL AS numeric(15, 2)) AS PrimeiroSalarioComplemento,
	CAST(FUNCPRIMEIROSALARIO.ANTECSAL AS numeric(15, 2)) AS PrimeiroSalAntecipacaoSal,
	FUNCULTIMOSALARIO.TIPOSALARIO UltimoSalarioTipoSalario,
	CAST(FUNCULTIMOSALARIO.VALORSAL AS numeric(15, 2)) AS UltimoSalarioValorSalario,      
	case when FUNCADICIONALULTIMOSALARIO.PERCINSALUB > 0 then 
		cast(CAST(FUNCULTIMOSALARIO.VALORSAL AS numeric(15, 2)) as varchar(30)) || ' Acrescido de '|| cast(FUNCADICIONALULTIMOSALARIO.PERCINSALUB as varchar(10)) ||' Porcent. de insalubridade'
		else cast(CAST(FUNCULTIMOSALARIO.VALORSAL AS numeric(15, 2)) as varchar(30)) || ' Acrescido de '|| cast(FUNCADICIONALULTIMOSALARIO.PERCPERICUL as varchar(10)) ||' Porcent. de periculosidade' 
	end as UltimoSalarioSalarioAdicional,
	CAST(FUNCULTIMOSALARIO.COMPLSAL AS numeric(15, 2)) AS UltimoSalarioComplemento,       
	CAST(FUNCULTIMOSALARIO.ANTECSAL AS numeric(15, 2)) AS UltimoSalAntecipacaoSal,
	FUNCSALARIONADATAEMISSAO.TIPOSALARIO DataEmissaoUltimoSalario,
	CAST(FUNCSALARIONADATAEMISSAO.VALORSAL AS numeric(15, 2)) AS DataEmissaoValorSalario,   
	case when FUNCADICIONALSALDATAEMISSAO.PERCINSALUB > 0 then 
		cast(CAST(FUNCSALARIONADATAEMISSAO.VALORSAL AS numeric(15, 2)) as varchar(15)) || ' Acrescido de ' || cast(FUNCADICIONALSALDATAEMISSAO.PERCINSALUB as varchar(10)) || ' Porcent. de insalubridade'
		else cast(CAST(FUNCSALARIONADATAEMISSAO.VALORSAL AS numeric(15, 2)) as varchar(15)) || ' Acrescido de ' || cast(FUNCADICIONALSALDATAEMISSAO.PERCPERICUL as varchar(10)) || ' Porcent. de periculosidade' 
	end as DataEmissaoSalarioAdicional,
	CAST(FUNCSALARIONADATAEMISSAO.COMPLSAL AS numeric(15, 2)) DataEmissaoComplementoSalario,
	CAST(FUNCSALARIONADATAEMISSAO.ANTECSAL AS numeric(15, 2)) DataEmissaoAntecipacaoSalario,
	PRIMEIRAESCALA.CARGAHORMENSAL  as PrimeiraEscalaCargaHoraMensal, 
	PRIMEIRAESCALA.CARGAHORSEMANAL  as PrimeiraEscalaCargaHoraSemanal,
	PRIMEIRAESCALA.CARGAHORDIARIA  as PrimeiraEscalaCargaHoraDiaria,
	ULTIMAESCALA.CARGAHORMENSAL  UltimaEscalaCargaHoraMensal,
	ULTIMAESCALA.CARGAHORSEMANAL  UltimaEscalaCargaHoraSemanal,
	ULTIMAESCALA.CARGAHORDIARIA  UltimaEscalaCargaHoraDiaria,     
	ESCALADATAEMISSAO.CARGAHORMENSAL  EscalaDataEmissaoCargaHoraM,
	ESCALADATAEMISSAO.CARGAHORSEMANAL  EscalaDataEmissaoCargaHoraS,
	ESCALADATAEMISSAO.CARGAHORDIARIA  EscalaDataEmissaoCargaHoraD,
	CARGOPRIMEIROFUNC.DESCRCARGO PrimeiroCargoDesc,
	CBOPRIMEIROCARGO.CBO PrimeiroCargoCBO,
	CBOPRIMEIROCARGO.DESCRCBO PrimeiroCargoDescCbo,
	CARGOULTIMOFUNC.DESCRCARGO UltimOCargoDescCargo,
	CBOULTIMOCARGO.CBO UltimOCargoCBO,
	CBOULTIMOCARGO.DESCRCBO UltimOCargoDescCBO,
	CARGONADATAEMISSAO.DESCRCARGO DataEmissaoCargoDesc,
	CBOCARGODATAEMISSAO.CBO DataEmissaoCargoCBO,
	CBOCARGODATAEMISSAO.DESCRCBO DataEmissaoCargoDescCBO, 
	ORGANOGRAMAPRIMEIRO.CLASSIFORGAN OrganogPrimeiroClassifOrg,
	ORGANOGRAMAPRIMEIRO.DESCRORGAN OrganogPrimeiroDescOrg,
	ORGANOGRAMAULTIMO.CLASSIFORGAN OrganogUltimoClassOrg,
	ORGANOGRAMAULTIMO.DESCRORGAN OrganogUltimoDescOrg,
	ORGANOGRAMAATUAL.CLASSIFORGAN OrganogDataEmissaoClassOrg,
	ORGANOGRAMAATUAL.DESCRORGAN OrganogDataEmissaoDescOrg,
	FC.DATAADM AS DataAdmissaoPorExtenso,
	case when FC.DATATRANSFEMP is null then ''
		else
		cast((
			Lpad(cast({extract(day, FC.DATAADM)} as varchar(2)),2, '0') ||'-'||
			Lpad(cast({extract(month, FC.DATAADM)} as varchar(2)),2, '0') ||'-'||
			Lpad(cast({extract(year, FC.DATAADM)} as varchar(4)),4, '0') || ' / ' ||
			Lpad(cast({extract(day, FC.DATATRANSFEMP)} as varchar(2)),2, '0') ||'-'||
			Lpad(cast({extract(month, FC.DATATRANSFEMP)} as varchar(2)),2, '0') ||'-'||
			Lpad(cast({extract(year, FC.DATATRANSFEMP)} as varchar(4)),4, '0')
		) as varchar(25))
	end DataAdmissaoTransfporExtenso,
	FUNCULTIMOCARGO.DATAINICIAL AS DataUltimoCargoPorExtenso,
	FUNCULTIMOSALARIO.DATAINICIAL AS DataUltimoSalarioPorExtenso,
	FL.CODIGOESTAB CodigoEstab,
	ES.NOMEESTAB NomeEstab,
	UPPER(ES.NOMEESTAB) AS NomeEstabMaiusc,
	ES.NOMEFANTASIA NomeFantasiaEstab,
	TLE.DESCRTIPOLOGRAD as LogradouroEstab,
	ES.ENDERECOESTAB,
	ES.NUMENDERESTAB,
	ES.COMPLENDERESTAB,
	ES.BAIRROENDERESTAB,
	ES.SIGLAESTADO,
	M.NOMEMUNIC,
	ES.CEPENDERESTAB,
	ES.DDDFONE || '-' || ES.NUMEROFONE,
	ES.EMAIL,
	ES.TIPOINSCR,
	ES.INSCRFEDERAL,
	ES.INSCRESTAD,
	ES.INSCRMUNIC,
	ES.CODIGOATIVFEDERAL,
	ATF.DESCRATIVFEDERAL,       
	case when ES.TIPOREGIST = 1 then 'Junta Comercial' else
	case when ES.TIPOREGIST = 2 then 'Cartrio' else
	case when ES.TIPOREGIST = 3 then 'OAB' else
	case when ES.TIPOREGIST = 6 then 'Cartrio Pessoas Jurdicas' else
	case when ES.TIPOREGIST = 4 then 'CEI' else 'Em Branco' end end end end end TIPOREGIST, 
	ES.NUMEROREGIST,
	ES.DATAREGIST,
	ES.DATAINICIOATIV,
	UPPER(ES.NOMEFANTASIA) AS NOMEFANTASIAMAIUSC,
	MN.CODIGOMUNIC       
	,EMP.CODIGOEMPRESA
	,EMP.NOMEEMPRESA
	,UPPER(EMP.NOMEEMPRESA) AS NOMEEMPRESAMAIUSC
	,ESTAB1.NOMEFANTASIA AS FANTASIA
	,UPPER(ESTAB1.NOMEFANTASIA) AS FANTASIAMAIUSC
	,TL1.DESCRTIPOLOGRAD LOGRADESTAB
	,ESTAB1.ENDERECOESTAB
	,ESTAB1.NUMENDERESTAB
	,ESTAB1.COMPLENDERESTAB
	,ESTAB1.BAIRROENDERESTAB
	,ESTAB1.SIGLAESTADO
	,MUNESTAB1.NOMEMUNIC
	,ESTAB1.CEPENDERESTAB
	,ESTAB1.DDDFONE || '-' || ESTAB1.NUMEROFONE  AS DDDTELEFONE
	,ESTAB1.EMAIL
	,ESTAB1.TIPOINSCR
	,ESTAB1.INSCRFEDERAL
	,ESTAB1.INSCRESTAD
	,ESTAB1.INSCRMUNIC
	,ESTAB1.CODIGOATIVFEDERAL
	,ESTAB1.DESCRATIVFEDESTAB
	,case when ESTAB1.TIPOREGIST = 1 then 'Junta Comercial' else
	case when ESTAB1.TIPOREGIST = 2 then 'Cartrio' else
	case when ESTAB1.TIPOREGIST = 3 then 'OAB' else
	case when ESTAB1.TIPOREGIST = 6 then 'Cartrio Pessoas Jurdicas' else
	case when ESTAB1.TIPOREGIST = 4 then 'CEI' else 'Em Branco' end end end end 
	end TIPOREGIST 
	,ESTAB1.NUMEROREGIST
	,ESTAB1.DATAREGIST
	,ESTAB1.DATAINICIOATIV
	,case when CEMPGESTAB1.TIPOENQUAD = 1 then 'Normal' else
	case when CEMPGESTAB1.TIPOENQUAD = 2 then 'Empresa de Pequeno Porte' else
	case when CEMPGESTAB1.TIPOENQUAD = 3 then 'Microempresa' else 'Micro Empreendedor Individual' end end end TIPOENQUAD
	,ES.CODIGOESTAB
	,ES.NOMEESTAB
	,UPPER(ES.NOMEESTAB) AS NOMEESTABMAIUSC
	,ES.NOMEFANTASIA
	,UPPER(ES.NOMEFANTASIA) AS NOMEFANTASIAMAIUSC
	,TLE.DESCRTIPOLOGRAD LOGRADESTAB
	,ES.ENDERECOESTAB
	,ES.NUMENDERESTAB
	,ES.COMPLENDERESTAB
	,ES.BAIRROENDERESTAB
	,ES.SIGLAESTADO
	,M.NOMEMUNIC
	,M.CEPMUNIC
	,ES.DDDFONE || '-' || ES.NUMEROFONE AS DDDTELEFONE
	,ES.EMAIL
	,ES.TIPOINSCR
	,ES.INSCRFEDERAL
	,ES.INSCRESTAD
	,ES.INSCRMUNIC
	,ES.CODIGOATIVMUNIC
	,ES.DESCRATIVFEDESTAB
	,case when ES.TIPOREGIST = 1 then 'Junta Comercial' else
	case when ES.TIPOREGIST = 2 then 'Cartrio' else
	case when ES.TIPOREGIST = 3 then 'OAB' else
	case when ES.TIPOREGIST = 6 then 'Cartrio Pessoas Jurdicas' else
	case when ES.TIPOREGIST = 4 then 'CEI' else 'Em Branco' end end end end end TIPOREGIST
	,ES.DATAREGIST
	,ES.DATAINICIOATIV
	,CONT.NOMECONT
	,UPPER(CONT.NOMECONT) AS NOMECONTADORMAIUSC
	,CONT.INSCRFEDERAL
	,CONT.NUMSEQCRC
	,CONT.TITULOPROFIS
	,SOC.NOMESOCIO
	,UPPER(SOC.NOMESOCIO) AS NOMESOCIOMAIUSC
	,case when SOC.TIPOINSCR = 1 then 'CPF' else
	case when SOC.TIPOINSCR = 2 then 'CNPJ' end end TIPOINSCR
	,SOC.INSCRFEDERAL
	,SOC.DESCRCARGO as CARGOSOCIO
	,CFE2.NOMEPREPOSTO AS RESPONSAVELPREPOSTOEMPRESA
	,CFE.NOMEPREPOSTO AS RESPONSAVELPREPOSTOFILIAL
	,MUNESTAB1.NOMEMUNIC || '-' || MUNESTAB1.SIGLAESTADO AS LOCALEMPRESAPOREXTENSO
	,M.NOMEMUNIC || '-' || M.SIGLAESTADO AS LOCALFILIALPOREXTENSO
	,FC.DATAADM DataAdmPorExtenso
	,FUNCULTIMOCARGO.DATAINICIAL AS DataUltimoCargoPorExtenso
	,FUNCULTIMOSALARIO.DATAINICIAL AS DataUltimoSalarioPorExtenso
	,FUNCULTIMAESCALA.DATAINICIAL as DataUltimaEscalaPorExtenso
	,({TIMESTAMPADD('DAY', FC.DIACONTREXP, (FC.DATAADM))}) AS DataIniciOProrrogacaoPorExt
	,({TIMESTAMPADD('DAY', (FC.DIAPRORROGCONTREXP -1), (({TIMESTAMPADD('DAY', FC.DIACONTREXP, (FC.DATAADM))})))}) AS DataFimProrrogacaoPorExtenso
	,({TIMESTAMPADD('DAY', FC.DIAPRORROGCONTREXP, (({TIMESTAMPADD('DAY', FC.DIACONTREXP, (FC.DATAADM))})))}) AS DataSeguinteFimProrrogPorExt
	,COALESCE(FUNCLOCALDATATRANSDATAINICIAL.DATATRANSF, FUNCLOCALDATATRANSDATAFINAL.DATATRANSF) AS DataTransPorExtenso
	,FP.CARTRNE
	,CONSPROF.NOMECONSELHO
	,PRIMEIRAESCALA.CODIGOESCALA AS CODPRIMESCALAMENSAL
	,PRIMEIRAESCALA.CODIGOESCALA AS CODPRIMESCALADETALHADO
	,PRIMEIRAESCALA.CODIGOESCALA AS CODPRIMESCALADETALHADOINTER
	,ULTIMAESCALA.CODIGOESCALA AS CODULTIMAESCALAMENSAL
	,ULTIMAESCALA.CODIGOESCALA AS CODULTIMAESCALADETALHADO
	,ULTIMAESCALA.CODIGOESCALA AS CODULTIMAESCALADETALHADOINTER
	,ESCALADATAEMISSAO.CODIGOESCALA AS CODESCDATAEMMENSAL
	,ESCALADATAEMISSAO.CODIGOESCALA AS CODESCDATAEMDETALHADO
	,ESCALADATAEMISSAO.CODIGOESCALA AS CODESCDATAEMDETALHADOINTERVALO
	,({TIMESTAMPADD('DAY', (FC.DIACONTREXP - 1), (FC.DATAADM))}) DataFimContratoExperiencia
	,CAST('01/01/1900' AS DATE) as DataEmissao
	,CAST('01/01/1900' AS DATE) as DataEmissaoPorExtenso
	,CAST(FUNCPRIMEIROSALARIO.VALORSAL AS numeric(15, 2)) as PrimeiroSalarioPorExtenso
	,CAST(FUNCPRIMEIROSALARIO.VALORSAL AS numeric(15, 2)) 
	,case when FUNCADICIONALPRIMEIROSALARIO.PERCINSALUB > 0 then FUNCADICIONALPRIMEIROSALARIO.PERCINSALUB else FUNCADICIONALPRIMEIROSALARIO.PERCPERICUL end as PrimeiroSalarioAdicPorExt
	,CAST(FUNCULTIMOSALARIO.VALORSAL AS numeric(15, 2)) as PrimeiroSalarioPorExtenso
	,case when FUNCADICIONALULTIMOSALARIO.PERCINSALUB > 0 then FUNCADICIONALULTIMOSALARIO.PERCINSALUB else FUNCADICIONALULTIMOSALARIO.PERCPERICUL end as UltimoSalarioAdicPorExt
	,CAST(FUNCSALARIONADATAEMISSAO.VALORSAL AS numeric(15, 2)) as DataEmissaoSalarioPorExtenso
	,case when FUNCADICIONALSALDATAEMISSAO.PERCINSALUB > 0 then FUNCADICIONALSALDATAEMISSAO.PERCINSALUB else FUNCADICIONALSALDATAEMISSAO.PERCPERICUL end as DataEmissaoSalarioAdicPorExt
	,case when FUNCADICIONALPRIMEIROSALARIO.PERCINSALUB > 0 then 'insalubridade' else 'Periculosidade' end as PRIMEIROSALINSALUBPERICU
	,case when FUNCADICIONALULTIMOSALARIO.PERCINSALUB > 0 then 'insalubridade' else 'Periculosidade' end as ULTIMOSALINSALUBPERICU
	,case when FUNCADICIONALSALDATAEMISSAO.PERCINSALUB > 0 then 'insalubridade' else 'Periculosidade' end as DATAEMISSAOSALINSALUBPERICU
	,FTD.SIGLAESTADOCTPS as UFCTPS
	,FP.TITELEIT
	,FP.ZONATITELEIT
	,FP.SECAOTITELEIT
	,FP.GRAUINSTR
	,DEPMAE.NOMEDEPEND NOMEMAE
	,DEPMAE.CPFDEPEND  CPFMAE
	,DEPCONJUGE.NOMEDEPEND NOMECONJUGE
	,DEPCONJUGE.CPFDEPEND  CPFCONJUGE    
	,SIND.NOMESIND SINDICATONOME
	,SIND.SIGLASIND SINDICATOSIGLA
	,SIND.CODIGOENTID SINDICATOCODIGOENTIDADE
	,SIND.INSCRFEDERAL SINDICATOINSCRFEDERAL
	,PRIMEIRAESCALA.CODIGOESCALA AS CODPRIESCRESHORINIFIMINTER
	,ULTIMAESCALA.CODIGOESCALA AS CODULTESCRESHORINIFIMINTER
	,ESCALADATAEMISSAO.CODIGOESCALA AS CODESCEMIRESHORINIFIMINTER
	,DEPPAI.NOMEDEPEND NOMEPAI
	,DEPPAI.CPFDEPEND  CPFPAI
	,CASE WHEN FP.NOMESOCIAL IS NULL THEN FP.NOMEFUNC ELSE FP.NOMESOCIAL END AS NOMESOCIAL
    ,FUNCPRIMEIRAESCALA.DESCRTIPOJORNADA AS DESCRTIPOJORNADAPRIESC 
    ,FUNCULTIMAESCALA.DESCRTIPOJORNADA AS DESCRTIPOJORNADAULTIESC
    ,FUNCESCALADATAEMISSAO.DESCRTIPOJORNADA AS DESCRTIPOJORNADAATUALESC
	,FC.MATRICULAESOCIAL
  FROM FUNCCONTRATO FC
  JOIN EMPRESA EMP 
    ON EMP.CODIGOEMPRESA = FC.CODIGOEMPRESA
  JOIN FUNCPESSOA FP 
    ON FP.CODIGOFUNCPESSOA = FC.CODIGOFUNCPESSOA
  JOIN (SELECT CODIGOEMPRESA,
               CODIGOFUNCCONTR, 
               MAX(DATATRANSF) DATATRANSF  
          FROM FUNCLOCAL 
         WHERE DATATRANSF <= %s
         GROUP BY CODIGOEMPRESA, CODIGOFUNCCONTR) FLS 
    ON FLS.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FLS.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
  JOIN FUNCLOCAL FL 
    ON FL.CODIGOEMPRESA = FLS.CODIGOEMPRESA
   AND FL.CODIGOFUNCCONTR = FLS.CODIGOFUNCCONTR
   AND FL.DATATRANSF =  FLS.DATATRANSF
/*FUNCCTPS*/
  LEFT JOIN (SELECT FTD.CODIGOEMPRESA,
                    FTD.CODIGOFUNCCONTR, 
                    MAX(FTD.DATAINICIAL) DATAINICIAL 
                FROM FUNCCTPS FTD 
                GROUP BY FTD.CODIGOEMPRESA, FTD.CODIGOFUNCCONTR) FCTD 
    ON FCTD.CODIGOEMPRESA = FC.CODIGOEMPRESA 
   AND FCTD.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR 
  LEFT JOIN FUNCCTPS FTD 
    ON FTD.CODIGOEMPRESA = FC.CODIGOEMPRESA 
   AND FTD.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR 
   AND FTD.DATAINICIAL = FCTD.DATAINICIAL
  JOIN ESTAB ES 
    ON ES.CODIGOEMPRESA = FL.CODIGOEMPRESA
   AND ES.CODIGOESTAB = FL.CODIGOESTAB
  JOIN TIPOLOGRADOURO  TLE
    ON TLE.CODIGOTIPOLOGRAD = ES.CODIGOTIPOLOGRAD
  JOIN ATIVFEDERAL ATF 
    ON (ATF.CODIGOATIVFEDERAL = ES.CODIGOATIVFEDERAL)
/*PRIMEIRO CARGO*/
  LEFT JOIN (SELECT CODIGOEMPRESA,
                    CODIGOFUNCCONTR, 
                    MIN(DATAINICIAL) DATAINICIAL
               FROM FUNCCARGO
              GROUP BY CODIGOEMPRESA, CODIGOFUNCCONTR) FCS 
    ON FCS.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FCS.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
  LEFT JOIN FUNCCARGO FUNCPRIMEIROCARGO 
    ON FUNCPRIMEIROCARGO.CODIGOEMPRESA = FCS.CODIGOEMPRESA
   AND FUNCPRIMEIROCARGO.CODIGOFUNCCONTR = FCS.CODIGOFUNCCONTR
   AND FUNCPRIMEIROCARGO.DATAINICIAL = FCS.DATAINICIAL
/*ULTIMO CARGO*/
  LEFT JOIN (SELECT CODIGOEMPRESA,
                    CODIGOFUNCCONTR, 
                    MAX(DATAINICIAL) DATAINICIAL
               FROM FUNCCARGO
              GROUP BY CODIGOEMPRESA, CODIGOFUNCCONTR) FCU 
    ON FCU.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FCU.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
  LEFT JOIN FUNCCARGO FUNCULTIMOCARGO 
    ON FUNCULTIMOCARGO.CODIGOEMPRESA = FCU.CODIGOEMPRESA
   AND FUNCULTIMOCARGO.CODIGOFUNCCONTR = FCU.CODIGOFUNCCONTR
   AND FUNCULTIMOCARGO.DATAINICIAL = FCU.DATAINICIAL
/*CARGO ATUAL*/
  LEFT JOIN (SELECT CODIGOEMPRESA,
                    CODIGOFUNCCONTR, 
                    MAX(DATAINICIAL) DATAINICIAL
               FROM FUNCCARGO
              WHERE DATAINICIAL <= :PDATAEMISSAO
              GROUP BY CODIGOEMPRESA, CODIGOFUNCCONTR) FCA 
    ON FCA.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FCA.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
  LEFT JOIN FUNCCARGO FUNCCARGONADATAEMISSAO 
    ON FUNCCARGONADATAEMISSAO.CODIGOEMPRESA = FCA.CODIGOEMPRESA
   AND FUNCCARGONADATAEMISSAO.CODIGOFUNCCONTR = FCA.CODIGOFUNCCONTR
   AND FUNCCARGONADATAEMISSAO.DATAINICIAL = FCA.DATAINICIAL
  JOIN CARGO CARGOPRIMEIROFUNC 
    ON CARGOPRIMEIROFUNC.CODIGOCARGO = FUNCPRIMEIROCARGO.CODIGOCARGO
  JOIN CARGO CARGOULTIMOFUNC 
    ON CARGOULTIMOFUNC.CODIGOCARGO = FUNCULTIMOCARGO.CODIGOCARGO
  JOIN CARGO CARGONADATAEMISSAO 
    ON CARGONADATAEMISSAO.CODIGOCARGO = FUNCCARGONADATAEMISSAO.CODIGOCARGO
  JOIN CBO CBOPRIMEIROCARGO 
    ON CBOPRIMEIROCARGO.CBO = CARGOPRIMEIROFUNC.CBO
  JOIN CBO CBOULTIMOCARGO 
    ON CBOULTIMOCARGO.CBO = CARGOULTIMOFUNC.CBO
  JOIN CBO CBOCARGODATAEMISSAO 
    ON CBOCARGODATAEMISSAO.CBO = CARGONADATAEMISSAO.CBO
    
    
/*PRIMEIRO SALRIO*/
  LEFT JOIN (SELECT CODIGOEMPRESA,
                    CODIGOFUNCCONTR, 
                    MIN(DATAINICIAL) DATAINICIAL
               FROM FUNCSALARIO
              GROUP BY CODIGOEMPRESA, CODIGOFUNCCONTR) FSP 
    ON FSP.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FSP.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
  LEFT JOIN FUNCSALARIO FUNCPRIMEIROSALARIO 
    ON FUNCPRIMEIROSALARIO.CODIGOEMPRESA = FSP.CODIGOEMPRESA
   AND FUNCPRIMEIROSALARIO.CODIGOFUNCCONTR = FSP.CODIGOFUNCCONTR
   AND FUNCPRIMEIROSALARIO.DATAINICIAL = FSP.DATAINICIAL
   
   
/*ULTIMO SALARIO*/
  LEFT JOIN (SELECT CODIGOEMPRESA,
                    CODIGOFUNCCONTR, 
                    MAX(DATAINICIAL) DATAINICIAL
               FROM FUNCSALARIO
              GROUP BY CODIGOEMPRESA, CODIGOFUNCCONTR) FSU 
    ON FSU.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FSU.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
  LEFT JOIN FUNCSALARIO FUNCULTIMOSALARIO 
    ON FUNCULTIMOSALARIO.CODIGOEMPRESA = FSU.CODIGOEMPRESA
   AND FUNCULTIMOSALARIO.CODIGOFUNCCONTR = FSU.CODIGOFUNCCONTR
   AND FUNCULTIMOSALARIO.DATAINICIAL = FSU.DATAINICIAL
   
   
/*SALARIO ATUAL*/
  LEFT JOIN (SELECT CODIGOEMPRESA,
                    CODIGOFUNCCONTR, 
                    MAX(DATAINICIAL) DATAINICIAL
               FROM FUNCSALARIO
              WHERE DATAINICIAL <= :PDATAEMISSAO
              GROUP BY CODIGOEMPRESA, CODIGOFUNCCONTR) FSA 
    ON FSA.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FSA.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
  LEFT JOIN FUNCSALARIO FUNCSALARIONADATAEMISSAO 
    ON FUNCSALARIONADATAEMISSAO.CODIGOEMPRESA = FSA.CODIGOEMPRESA
   AND FUNCSALARIONADATAEMISSAO.CODIGOFUNCCONTR = FSA.CODIGOFUNCCONTR
   AND FUNCSALARIONADATAEMISSAO.DATAINICIAL = FSA.DATAINICIAL
  LEFT JOIN MUNICIPIO M 
    ON M.CODIGOMUNIC = ES.CODIGOMUNIC
   AND M.SIGLAESTADO = ES.SIGLAESTADO
   
   LEFT JOIN MUNICIPIO MNac
    ON MNac.CODIGOMUNIC = FP.CODIGOMUNICNASC 
   AND MNac.SIGLAESTADO = FP.SIGLAESTADONASC
 
 LEFT JOIN MUNICIPIO MN 
    ON MN.CODIGOMUNIC = FP.CODIGOMUNIC
   AND MN.SIGLAESTADO = FP.SIGLAESTADO

   LEFT JOIN TIPOLOGRADOURO TL 
    ON TL.CODIGOTIPOLOGRAD = FP.CODIGOTIPOLOGRAD
  LEFT JOIN ESTADO ECC 
    ON ECC.SIGLAESTADO = FP.CERTCIVILSIGLAESTADO
  LEFT JOIN PAIS PO 
    ON PO.CODIGOPAIS = FP.PAISORIGEM
  LEFT JOIN (SELECT CODIGOEMPRESA,
                    CODIGOFUNCCONTR,
                    MAX(DATAINICIAL) DATAINICIAL  
               FROM FUNCADICIONAL
              GROUP BY CODIGOEMPRESA, CODIGOFUNCCONTR) FAI 
    ON FAI.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FAI.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
  LEFT JOIN FUNCADICIONAL FA 
    ON (FA.CODIGOEMPRESA = FAI.CODIGOEMPRESA)
   AND (FA.CODIGOFUNCCONTR = FAI.CODIGOFUNCCONTR)
   AND (FA.DATAINICIAL = FAI.DATAINICIAL)
  LEFT JOIN ORGAOEMISSOR OM 
    ON OM.CODIGOORGAOEMISSOR = FP.CODIGOORGAOEMISSORRG
  LEFT JOIN ORGAOEMISSOR OEPASS 
    ON OEPASS.CODIGOORGAOEMISSOR = FP.CODIGOORGAOEMISSORPASPORT
  LEFT JOIN ORGAOEMISSOR OERIC ON OERIC.CODIGOORGAOEMISSOR = FP.CODIGOORGAOEMISSORRIC
/* FUNCSINDICATO */ 
  LEFT JOIN FUNCSINDICATO FS 
    ON FS.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FS.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
/* SINDICATO */          
  LEFT JOIN SINDICATO SIND
    ON SIND.CODIGOSIND = FS.CODIGOSIND    
/*PRIMEIRO ORGANOGRAMA*/
  LEFT JOIN (SELECT CODIGOEMPRESA, 
                    CODIGOFUNCCONTR, 
                    MIN(DATATRANSF) DATATRANSF  
               FROM FUNCLOCAL 
              GROUP BY CODIGOEMPRESA, CODIGOFUNCCONTR) FUNCLOCALPRIMEIRORGANOGRAMA_S 
    ON FUNCLOCALPRIMEIRORGANOGRAMA_S.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FUNCLOCALPRIMEIRORGANOGRAMA_S.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
  LEFT JOIN FUNCLOCAL FUNCLOCALPRIMEIRORGANOGRAMA 
    ON FUNCLOCALPRIMEIRORGANOGRAMA.CODIGOEMPRESA = FUNCLOCALPRIMEIRORGANOGRAMA_S.CODIGOEMPRESA
   AND FUNCLOCALPRIMEIRORGANOGRAMA.CODIGOFUNCCONTR = FUNCLOCALPRIMEIRORGANOGRAMA_S.CODIGOFUNCCONTR
   AND FUNCLOCALPRIMEIRORGANOGRAMA.DATATRANSF = FUNCLOCALPRIMEIRORGANOGRAMA_S.DATATRANSF
  LEFT JOIN ORGANOGRAMA ORGANOGRAMAPRIMEIRO 
    ON ORGANOGRAMAPRIMEIRO.CODIGOEMPRESA = FUNCLOCALPRIMEIRORGANOGRAMA.CODIGOEMPRESA
   AND ORGANOGRAMAPRIMEIRO.CODIGOESTAB = FUNCLOCALPRIMEIRORGANOGRAMA.CODIGOESTAB
   AND ORGANOGRAMAPRIMEIRO.TIPOCONTA = 2
   AND ORGANOGRAMAPRIMEIRO.CLASSIFORGAN = FUNCLOCALPRIMEIRORGANOGRAMA.CLASSIFORGAN
/*ULTIMO ORGANOGRAMA*/
  LEFT JOIN (SELECT CODIGOEMPRESA, 
                    CODIGOFUNCCONTR, 
                    MAX(DATATRANSF) DATATRANSF  
               FROM FUNCLOCAL 
              GROUP BY CODIGOEMPRESA, CODIGOFUNCCONTR) FUNCLOCALULTIMOORGANOGRAMA_S 
    ON FUNCLOCALULTIMOORGANOGRAMA_S.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FUNCLOCALULTIMOORGANOGRAMA_S.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
  LEFT JOIN FUNCLOCAL FUNCLOCALULTIMOORGANOGRAMA 
    ON FUNCLOCALULTIMOORGANOGRAMA.CODIGOEMPRESA = FUNCLOCALULTIMOORGANOGRAMA_S.CODIGOEMPRESA
   AND FUNCLOCALULTIMOORGANOGRAMA.CODIGOFUNCCONTR = FUNCLOCALULTIMOORGANOGRAMA_S.CODIGOFUNCCONTR
   AND FUNCLOCALULTIMOORGANOGRAMA.DATATRANSF = FUNCLOCALULTIMOORGANOGRAMA_S.DATATRANSF
  LEFT JOIN ORGANOGRAMA ORGANOGRAMAULTIMO 
    ON ORGANOGRAMAULTIMO.CODIGOEMPRESA = FUNCLOCALULTIMOORGANOGRAMA.CODIGOEMPRESA
   AND ORGANOGRAMAULTIMO.CODIGOESTAB = FUNCLOCALULTIMOORGANOGRAMA.CODIGOESTAB
   AND ORGANOGRAMAULTIMO.TIPOCONTA = 2
   AND ORGANOGRAMAULTIMO.CLASSIFORGAN = FUNCLOCALULTIMOORGANOGRAMA.CLASSIFORGAN
/*ORGANOGRAMA AUTAL */
  LEFT JOIN ORGANOGRAMA ORGANOGRAMAATUAL 
    ON ORGANOGRAMAATUAL.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND ORGANOGRAMAATUAL.CODIGOESTAB = FL.CODIGOESTAB
   AND ORGANOGRAMAATUAL.TIPOCONTA = 2
   AND ORGANOGRAMAATUAL.CLASSIFORGAN = FL.CLASSIFORGAN
   
   
/*PRIMEIRA ESCALA*/
  LEFT JOIN FUNCESCALA FUNCPRIMEIRAESCALA 
    ON (FUNCPRIMEIRAESCALA.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR)
   AND(FUNCPRIMEIRAESCALA.CODIGOEMPRESA = FC.CODIGOEMPRESA)
   AND exists(SELECT 1
              FROM FUNCESCALA FS
              WHERE FS.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
                AND FS.CODIGOEMPRESA = FC.CODIGOEMPRESA
              HAVING(MIN(FS.DATAINICIAL)) >=  FUNCPRIMEIRAESCALA.DATAINICIAL)  
                                             
  LEFT JOIN ESCALA PRIMEIRAESCALA 
    ON PRIMEIRAESCALA.CODIGOESCALA = FUNCPRIMEIRAESCALA.CODIGOESCALA
    
/*ULTIMA ESCALA*/
  LEFT JOIN FUNCESCALA FUNCULTIMAESCALA 
    ON (FUNCULTIMAESCALA.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR)
   AND(FUNCULTIMAESCALA.CODIGOEMPRESA = FC.CODIGOEMPRESA)  
   AND EXISTS (SELECT 1
               FROM FUNCESCALA FS
               WHERE FS.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
                 AND FS.CODIGOEMPRESA = FC.CODIGOEMPRESA
               HAVING (MAX(FS.DATAINICIAL)) = FUNCULTIMAESCALA.DATAINICIAL)   
                                                                                    
  JOIN ESCALA ULTIMAESCALA 
    ON ULTIMAESCALA.CODIGOESCALA = FUNCULTIMAESCALA.CODIGOESCALA
    
/* ESCALA ATUAL*/
  LEFT JOIN FUNCESCALA FUNCESCALADATAEMISSAO 
    ON (FUNCESCALADATAEMISSAO.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR)
   AND(FUNCESCALADATAEMISSAO.CODIGOEMPRESA = FC.CODIGOEMPRESA)   
   AND EXISTS (SELECT 1
               FROM FUNCESCALA FE
               WHERE FE.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
                 AND FE.CODIGOEMPRESA = FC.CODIGOEMPRESA
                 AND FE.DATAINICIAL <= :PDATAEMISSAO
               HAVING (MAX(FE.DATAINICIAL)) = FUNCESCALADATAEMISSAO.DATAINICIAL)
                                                
  LEFT JOIN ESCALA ESCALADATAEMISSAO 
    ON ESCALADATAEMISSAO.CODIGOESCALA = FUNCESCALADATAEMISSAO.CODIGOESCALA
  LEFT JOIN ESTAB ESTAB1 
    ON(ESTAB1.CODIGOEMPRESA = FC.CODIGOEMPRESA) 
  LEFT JOIN TIPOLOGRADOURO  TL1 
    ON  TL1.CODIGOTIPOLOGRAD = ESTAB1.CODIGOTIPOLOGRAD  
  LEFT JOIN MUNICIPIO MUNESTAB1 
    ON (MUNESTAB1.CODIGOMUNIC = ESTAB1.CODIGOMUNIC) 
   AND (MUNESTAB1.SIGLAESTADO = ESTAB1.SIGLAESTADO)
  LEFT JOIN ESTADO ESTADOESTAB1 
    ON (ESTADOESTAB1.SIGLAESTADO = MUNESTAB1.SIGLAESTADO)
  LEFT JOIN CFGEMPRESAGEM CEMPGESTAB1 
    ON(CEMPGESTAB1.CODIGOEMPRESA = ESTAB1.CODIGOEMPRESA)
  LEFT JOIN CFGEMPRESAGEM CFGEMPGEM 
    ON(CFGEMPGEM.CODIGOEMPRESA = ES.CODIGOEMPRESA)
  LEFT JOIN CONTADOR CONT 
    ON CFGEMPGEM.CONTADORRESPPREENCHFEDERAL = CONT.CODIGOCONT
  LEFT JOIN SOCIO SOC 
    ON CFGEMPGEM.CODIGOEMPRESA = SOC.CODIGOEMPRESA 
   AND CFGEMPGEM.SOCIORESPCNPJ = SOC.CODIGOSOCIO
  LEFT JOIN CFGESTABFPA CFE 
    ON CFE.CODIGOEMPRESA = ES.CODIGOEMPRESA 
   AND CFE.CODIGOESTAB = ES.CODIGOESTAB
  LEFT JOIN CFGESTABFPA CFE2 
    ON CFE2.CODIGOEMPRESA = ESTAB1.CODIGOEMPRESA 
   AND CFE2.CODIGOESTAB = ESTAB1.CODIGOESTAB
  LEFT JOIN (SELECT CODIGOEMPRESA,
                    CODIGOESTAB,
                    CODIGOFUNCCONTR,
                    MIN(DATATRANSF) DATATRANSF
               FROM FUNCLOCAL
              WHERE DATATRANSF >= :PDATAINICIALADMISSAO
              GROUP BY CODIGOEMPRESA,
                       CODIGOESTAB,
                       CODIGOFUNCCONTR) FLIA 
    ON FLIA.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FLIA.CODIGOESTAB = FL.CODIGOESTAB
   AND FLIA.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
   
  LEFT JOIN FUNCLOCAL FUNCLOCALDATATRANSDATAINICIAL 
    ON (FUNCLOCALDATATRANSDATAINICIAL.CODIGOEMPRESA = FLIA.CODIGOEMPRESA)
   AND(FUNCLOCALDATATRANSDATAINICIAL.CODIGOESTAB = FLIA.CODIGOESTAB)
   AND(FUNCLOCALDATATRANSDATAINICIAL.CODIGOFUNCCONTR = FLIA.CODIGOFUNCCONTR)
   AND (FUNCLOCALDATATRANSDATAINICIAL.DATATRANSF = FLIA.DATATRANSF) 
   
  LEFT JOIN (SELECT CODIGOEMPRESA,
                    CODIGOESTAB,
                    CODIGOFUNCCONTR,
                    MIN(DATATRANSF) DATATRANSF
               FROM FUNCLOCAL
              GROUP BY CODIGOEMPRESA, 
                       CODIGOESTAB,
                       CODIGOFUNCCONTR) FLIB 
    ON FLIB.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND FLIB.CODIGOESTAB = FL.CODIGOESTAB
   AND FLIB.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
   
  LEFT JOIN FUNCLOCAL FUNCLOCALDATATRANSDATAFINAL 
    ON (FUNCLOCALDATATRANSDATAFINAL.CODIGOEMPRESA = FLIB.CODIGOEMPRESA)
   AND(FUNCLOCALDATATRANSDATAFINAL.CODIGOESTAB = FLIB.CODIGOESTAB)
   AND(FUNCLOCALDATATRANSDATAFINAL.CODIGOFUNCCONTR = FLIB.CODIGOFUNCCONTR)
   AND(FUNCLOCALDATATRANSDATAFINAL.DATATRANSF = FLIB.DATATRANSF)
   
  LEFT JOIN FUNCADICIONAL FUNCADICIONALPRIMEIROSALARIO 
    ON (FUNCADICIONALPRIMEIROSALARIO.CODIGOEMPRESA = FUNCPRIMEIROSALARIO.CODIGOEMPRESA)
   AND (FUNCADICIONALPRIMEIROSALARIO.CODIGOFUNCCONTR = FUNCPRIMEIROSALARIO.CODIGOFUNCCONTR)
   AND (FUNCADICIONALPRIMEIROSALARIO.DATAINICIAL = FUNCPRIMEIROSALARIO.DATAINICIAL)
   
  LEFT JOIN FUNCADICIONAL FUNCADICIONALULTIMOSALARIO 
    ON (FUNCADICIONALULTIMOSALARIO.CODIGOEMPRESA = FUNCULTIMOSALARIO.CODIGOEMPRESA)
   AND (FUNCADICIONALULTIMOSALARIO.CODIGOFUNCCONTR = FUNCULTIMOSALARIO.CODIGOFUNCCONTR)
   AND (FUNCADICIONALULTIMOSALARIO.DATAINICIAL = FUNCULTIMOSALARIO.DATAINICIAL)
   
  LEFT JOIN FUNCADICIONAL FUNCADICIONALSALDATAEMISSAO 
    ON (FUNCADICIONALSALDATAEMISSAO.CODIGOEMPRESA = FUNCSALARIONADATAEMISSAO.CODIGOEMPRESA)
   AND (FUNCADICIONALSALDATAEMISSAO.CODIGOFUNCCONTR = FUNCSALARIONADATAEMISSAO.CODIGOFUNCCONTR)
   AND (FUNCADICIONALSALDATAEMISSAO.DATAINICIAL = FUNCSALARIONADATAEMISSAO.DATAINICIAL)
   
  LEFT JOIN CONSELHOPROFIS CONSPROF 
    ON (FP.CODIGOCONSELHO = CONSPROF.CODIGOCONSELHO)
    
/* DEPENDENTE ME*/  
  LEFT JOIN DEPENDENTE DEPMAE 
    ON DEPMAE.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND DEPMAE.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
   AND DEPMAE.PARENTESCO = '03'
   AND DEPMAE.SEXO = 2
   
/* DEPENDENTE PAI*/  
  LEFT JOIN DEPENDENTE DEPPAI 
    ON DEPPAI.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND DEPPAI.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR
   AND DEPPAI.PARENTESCO = '03'
   AND DEPPAI.SEXO = 1 
      
   
/* DEPENDENTE CONJUGE*/          
  LEFT JOIN (SELECT CODIGOEMPRESA,
                    CODIGOFUNCCONTR,
                    PARENTESCO,
                    NOMEDEPEND,
                    CPFDEPEND 
               FROM DEPENDENTE DP
              WHERE PARENTESCO = '02'
                AND CODIGODEPEND = (SELECT MIN(DPS.CODIGODEPEND) 
                                      FROM DEPENDENTE DPS 
                                     WHERE DPS.CODIGOEMPRESA = DP.CODIGOEMPRESA 
                                       AND DPS.CODIGOFUNCCONTR = DP.CODIGOFUNCCONTR
                                       AND DPS.PARENTESCO = '02')) DEPCONJUGE 
    ON DEPCONJUGE.CODIGOEMPRESA = FC.CODIGOEMPRESA
   AND DEPCONJUGE.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR  
   AND DEPCONJUGE.PARENTESCO = '02'  

         
 
          