insert into HorarioEmpresa (CodigoEmpresa, CodigoHorario, DataInicial, Status)
select distinct cast(:CodigoEmpresaDest as Integer) CodigoEmpresaDest,
                H.CodigoHorario,
                cast({CURDATE()} as date) as DataInicial,
                1
from FuncEscala FE
join escaladetalhe ED on FE.CodigoEscala = ED.CodigoEscala
join Horario H on h.codigohorario = ED.codigohorario
where FE.CodigoEmpresa = :CodigoEmpresaOrig
  and FE.CodigoFuncContr = :CodigoFuncContrOrig
  and FE.datainicial =
    (SELECT MAX(FEMS.DataInicial)
     FROM FuncEscala FEMS
     WHERE FEMS.CodigoEmpresa = FE.CodigoEmpresa
       AND FEMS.CodigoFuncContr = FE.CodigoFuncContr)
 and not exists(select 1 from HorarioEmpresa HE where HE.CodigoEmpresa = :CodigoEmpresaDest and HE.CodigoHorario = ED.CodigoHorario)