  select oep.GPSOrigem,
         oep.CodigoOutEmpGps,
         oep.ClassifOrgan,
         sum(oeps.GPSValor) GPSValor,
         sum(oeps.ValorSAT15Anos+oeps.ValorSAT20Anos+oeps.ValorSAT25Anos) ValorSAT
    from OutraEmpPgto oep,
         CfgEmpresaFpa cef
	join OutraEmpPgtoServico oeps
       on  oep.CodigoEmpresa = oeps.CodigoEmpresa
       and oep.codigooutemp = oeps.codigooutemp
       and oep.compet = oeps.compet
       and oep.seq = oeps.seq
   where oep.CodigoEmpresa = :CodigoEmpresa
     and oep.CodigoEstab = :CodigoEstab
     and oep.Compet = :Compet
     and oep.GPSOrigem in (1,3)
     and oep.CodigoEmpresa = cef.CodigoEmpresa
     and (oep.CodigoOutEmpGps = :CodigoOutEmp
      or oep.CodigoOutEmpGps is null)
group by oep.GPSOrigem,
         oep.CodigoOutEmpGps,
         oep.ClassifOrgan
order by 1