select oep.TipoArrec,
       sum(OEPS.BASEGPS) Valor
  from CfgEstabFpa cef,
       OutraEmpPgto oep,
       Organograma o,
       GPS gps,
       OutraEmpPgtoServico OEPS
 where cef.CodigoEmpresa = :pCodigoEmpresa
   and cef.CodigoEstab = :pCodigoEstab
   and cef.CategFGTS = 2
   and oep.CodigoEmpresa = cef.CodigoEmpresa
   and oep.CodigoEstab = cef.CodigoEstab
   and oep.Compet = :pCompet
   and oep.GPSOrigem between 1 and 2
   and oep.CodigoOutEmpGps is null
   and oep.CodigoEmpresa = o.CodigoEmpresa
   and oep.CodigoEstab   = o.CodigoEstab
   and oep.ClassifOrgan  = o.ClassifOrgan
   and oep.CodigoEmpresa = OEPS.CodigoEmpresa
   and oep.codigooutemp = OEPS.codigooutemp
   and oep.compet = OEPS.compet
   and oep.seq = OEPS.seq   
   and o.CodigoEmpresa = gps.CodigoEmpresa
   and o.CodigoTabGPS  = gps.CodigoTabGPS
   and gps.CodigoFpas  = :pCodigoFpas
   and gps.DataInicial = (select max(gps2.DataInicial)
                            from GPS gps2
                           where gps2.CodigoEmpresa = o.CodigoEmpresa
                             and gps2.CodigoTabGPS = o.CodigoTabGPS
                             and gps2.DataInicial < :pMesSeg)
 group by oep.TipoArrec
union
select 'P' IndicOrigem,
       sum(recs.ValorRcto) Valor
  from CfgEstabFpa cef,                  
       Recebimento rcb,
       Organograma o,
       GPS gps,
       RecebimentoServico recs
 where cef.CodigoEmpresa = :pCodigoEmpresa
   and cef.CodigoEstab = :pCodigoEstab
   and cef.CategFGTS <> 2
   and rcb.CodigoEmpresa = cef.CodigoEmpresa
   and rcb.CodigoEstab = cef.CodigoEstab
   and rcb.Compet = :pCompet
   and rcb.GPSOrigem = 5
   and rcb.CodigoOutEmp is null
   and rcb.CodigoEmpresa = o.CodigoEmpresa
   and rcb.CodigoEstab   = o.CodigoEstab
   and rcb.ClassifOrgan  = o.ClassifOrgan
   and rcb.CodigoEmpresa = recs.CodigoEmpresa
   and rcb.CodigoEstab = recs.CodigoEstab
   and rcb.Compet = recs.Compet
   and rcb.seq = recs.seq    
   and o.CodigoEmpresa = gps.CodigoEmpresa
   and o.CodigoTabGPS  = gps.CodigoTabGPS
   and gps.CodigoFpas  = :pCodigoFpas
   and gps.DataInicial = (select max(gps2.DataInicial)
                            from GPS gps2
                           where gps2.CodigoEmpresa = o.CodigoEmpresa
                             and gps2.CodigoTabGPS = o.CodigoTabGPS
                             and gps2.DataInicial < :pMesSeg)
union
select oep.TipoArrec,
       sum(OEPS.BASEGPS) Valor
  from CfgEstabFpa cef,
       OutraEmpPgto oep,
       Organograma o,
       GPS gps,
       OutraEmpPgtoServico OEPS
 where cef.CodigoEmpresa = :pCodigoEmpresa
   and cef.CodigoEstab = :pCodigoEstab
   and oep.CodigoEmpresa = cef.CodigoEmpresa
   and oep.CodigoEstab = cef.CodigoEstab
   and oep.Compet = :pCompet
   and oep.GPSOrigem = 5
   and oep.CodigoOutEmpGps is null
   and oep.CodigoEmpresa = o.CodigoEmpresa
   and oep.CodigoEstab   = o.CodigoEstab
   and oep.ClassifOrgan  = o.ClassifOrgan
	 and oep.CodigoEmpresa = OEPS.CodigoEmpresa
	 and oep.codigooutemp = OEPS.codigooutemp
	 and oep.compet = OEPS.compet
	 and oep.seq = OEPS.seq   
   and o.CodigoEmpresa = gps.CodigoEmpresa
   and o.CodigoTabGPS  = gps.CodigoTabGPS
   and gps.CodigoFpas  = :pCodigoFpas
   and gps.DataInicial = (select max(gps2.DataInicial)
                            from GPS gps2
                           where gps2.CodigoEmpresa = o.CodigoEmpresa
                             and gps2.CodigoTabGPS = o.CodigoTabGPS
                             and gps2.DataInicial < :pMesSeg)
 group by oep.TipoArrec
order by 1                     