select C.CODIGOEMPRESA
, C.CodigoFuncContr
, C.CODIGOESTRUT
, C.DATAINICIALFERIAS
, RF.DataFinalFerias
, RF.DataAbono
, C.CODIGOBENEF
, P.NomeBenef
, CAST(MAX(P.PercValor) as NUMERIC(16,4)) PercValor
, MAX(P.TIPOPGTO) as TIPOPGTO
, CAST(SUM(C.VALORPENSAO) as NUMERIC(14,2)) Valor
, CAST(MAX(RF.DiasFerias) as NUMERIC(4,2)) DiasFerias
, CAST(MAX(RF.DiasAbono) as NUMERIC(4,2)) DiasAbono
from CALCULOPENSAO C
left join Periodocalculo PC
on PC.CodigoEmpresa = C.CodigoEmpresa
and PC.CodigoPerCalculo = C.CodigoPerCalculo
left join PensaoJud P
on P.CodigoEmpresa = C.CodigoEmpresa
and P.CodigoFuncContr = C.CodigoFuncContr
and P.CodigoBenef = C.CODIGOBENEF
left join reciboferias rf on
rf.codigoempresa = c.codigoempresa and
rf.CodigoFuncContr = c.CodigoFuncContr and
rf.datainicialferias = c.datainicialferias and
RF.seqreciboferias = C.seqreciboferias
left join rescisao r on
r.codigoempresa = C.codigoempresa and
r.CodigoFuncContr = C.CodigoFuncContr and
r.complementar = C.Complementar
where ((PC.Compet between :pDataInicial and :pDataFinal and PC.CodigoTipoCalc = :pCodigoTipoCalc) or
( ((21 = :pCodigoTipoCalc) or (23 = :pCodigoTipoCalc)) and (PC.CodigoTipoCalc = 20 and (PC.Compet between :pDataInicialAno and :pDataFinalAno))) or
(R.DataResc between :pDataInicial and :pDataFinal and C.CodigoPerCalculo is null) OR
(C.DataInicialFERIAS between :pDataInicial and :pDataFinal  or
rf.DataFinalFERIAS between :pDataInicial and :pDataFinal))
and coalesce(C.SeqReciboFerias, 1) = 1
%s
group by C.CODIGOEMPRESA
, C.CodigoFuncContr
, C.CODIGOESTRUT
, C.DATAINICIALFERIAS
, RF.DataFinalFerias
, RF.DataAbono
, C.CODIGOBENEF
, P.NomeBenef
order by 1, 2, 3, 4