select R.CodigoOutEmp,
       O.NomeOutEmp,
       R.Seq,
       sum(Rs.ValorRcto) ValorRcto,
       sum(Rs.RetencGPS) RetencGPS,
       R.NotaFiscal,
       R.GPSOrigem
  from Recebimento R
       join RecebimentoServico Rs
         on R.CodigoEmpresa = Rs.CodigoEmpresa
        and R.CodigoEstab = Rs.CodigoEstab
        and R.Compet = Rs.Compet
        and R.Seq = Rs.Seq
       join OutraEmpresa O
         on R.CodigoOutEmp = O.CodigoOutEmp
 where R.CodigoEmpresa = :pCodigoEmpresa
   and R.CodigoEstab = :pCodigoEstab
   and R.Compet = :pCompet
   and R.CodigoOutEmp = :pCodigoOutEmp
   and R.CodigoImposto = :pCodigoImposto
   and R.VariacaoImposto = :pVariacaoImposto
 group by R.codigoOutEmp,
       O.nomeOutEmp,
       R.Seq,
       R.NotaFiscal,
       R.GPSOrigem
 order by 1,
          2