  select F.TipoAliquota,
         F.LimiteDe,
         F.LimiteAte,
         A.DeducaoDepend,
         A.ValorMinRecol,
         A.ValorMinRecol13,
         F.Aliquota,
         F.Deduzir,
     A.CodigoImposto,
     A.VariacaoImposto,
     A.CodigoImpostoDez,
     A.VariacaoImpostoDez,
     A.CodigoImpostoCoop,
     A.VariacaoImpostoCoop,
     A.CodigoImpostoCoopDez,
     A.VariacaoImpostoCoopDez,
     A.CodigoImpostoDomestico,
     A.VariacaoImpostoDomestico,
     A.CodigoImpostoAutonomo,
     A.VariacaoImpostoAutonomo,
	 A.DataInicial,
     A.DeducaoSimplificada
    from TabelaIRRF A,
         FaixaIRRF F
   where F.TipoAliquota = 1 
     and A.DataInicial = F.DataInicial
     and A.DataInicial = (select max(B.DataInicial)
                            from TabelaIRRF B, FaixaIRRF C
                           where B.DataInicial = C.DataInicial 
                             and C.TipoAliquota = 1 
                             and B.DataInicial <= Cast(:Data as date))
                           
union
                           
  select F.TipoAliquota,
         F.LimiteDe,
         F.LimiteAte,
         A.DeducaoDepend,
         A.ValorMinRecol,
         A.ValorMinRecol13,
         F.Aliquota,
         F.Deduzir,
     A.CodigoImpostoPLR CodigoImposto,
     A.VariacaoImpostoPLR VariacaoImposto,
     A.CodigoImpostoDez,
     A.VariacaoImpostoDez,
     A.CodigoImpostoCoop,
     A.VariacaoImpostoCoop,
     A.CodigoImpostoCoopDez,
     A.VariacaoImpostoCoopDez,
     A.CodigoImpostoDomestico,
     A.VariacaoImpostoDomestico,
     A.CodigoImpostoAutonomo,
     A.VariacaoImpostoAutonomo,
	 A.DataInicial,
     A.DeducaoSimplificada
    from TabelaIRRF A,
         FaixaIRRF F
   where F.TipoAliquota = 2 
     and A.DataInicial = F.DataInicial
     and A.DataInicial = (select max(B.DataInicial)
                            from TabelaIRRF B, FaixaIRRF C
                           where B.DataInicial = C.DataInicial 
                             and C.TipoAliquota = 2 
                             and B.DataInicial <= Cast(:Data as date))
order by 1, 2