select sum(T.BASEINSSFUNC) BASEINSSFUNC,
       sum(T.VALORINSS) VALORINSS

from (
select I.BASEINSSFUNC BASEINSSFUNC,
       I.VALORINSS VALORINSS
  from Terceiro T
  join TerceiroBanco TB
    on TB.CodigoTerc = T.CodigoTerc
    
  join MultiploVinculo MV
    on MV.inscrfederal = T.CpfTerc

  join MultiploVinculoTerc MT
    on MT.tipomultvinculo = MV.tipomultvinculo
   and MT.inscrfederal = MV.inscrfederal
   and MT.CodigoEmpresa = TB.CodigoEmpresa
   and MT.CodigoTerc = TB.CodigoTerc

  join multiplovinculofunc MVF
    on MVF.tipomultvinculo = MV.tipomultvinculo
   and MVF.inscrfederal = MV.inscrfederal

  join FuncContrato FC
    on FC.CodigoEmpresa = MVF.CodigoEmpresa
   and FC.codigofunccontr = MVF.codigofunccontr
   
  join FuncPerCalculo FPC
   on FPC.CodigoEmpresa = FC.CodigoEmpresa
  and FPC.CodigoFuncContr = FC.CodigoFuncContr
 
 join PeriodoCalculo P
   on P.CodigoEmpresa = FPC.CodigoEmpresa
  and P.CodigoPerCalculo = FPC.CodigoPerCalculo

  join ImpostoCalculo I
   on I.CodigoEmpresa = FPC.CodigoEmpresa
  and I.CodigoPerCalculo = FPC.CodigoPerCalculo
  and I.CodigoFuncContr = FPC.CodigoFuncContr
where T.MultVincTerc = '1'
  and MT.TipoVinculo in (1,3)
  and (T.CpfTerc = :pCpfTer
   or T.CodigoTerc = :pCodigoTerc)
 
 and MT.CompetIni <= :pDataFinal
  and (MT.CompetFim >= :pDataInicial
   or MT.CompetFim is null)
  and P.CodigoTipoCalc = 1
  and P.compet = :pDataInicial
  
  and MVF.TipoVinculo in (1,3)
  and MVF.ordemcalculo < MT.ordemcalculo
  and MVF.CompetIni <= :pDataFinal
  and (MVF.CompetFim >= :pDataInicial
   or MVF.CompetFim is null)
  GROUP BY I.CODIGOEMPRESA, 
           I.CODIGOPERCALCULO, 
           I.CODIGOFUNCCONTR, 
           I.SEQ,
           I.BASEINSSFUNC,
           I.VALORINSS    
union 
SELECT sum(FB.INSSBASEMENSAL) BASEINSSFUNC,
       sum(FB.INSSRETIDOMENSAL) VALORINSS
  FROM MULTIPLOVINCFORAQUESTOR MVFQ
  JOIN MULTVINCFORAQUESTORBASE FB
   ON FB.TIPOMULTVINCULO = MVFQ.TIPOMULTVINCULO
  AND FB.INSCRFEDERAL = MVFQ.INSCRFEDERAL
  AND FB.CODIGOOUTEMP = MVFQ.CODIGOOUTEMP
  AND FB.DATAINICIAL = MVFQ.DATAINICIAL
  JOIN TERCEIRO TERC 
    ON TERC.CPFTERC = FB.INSCRFEDERAL
 WHERE TERC.MultVincTerc = '1'
   and exists(select 1 
                from MultiploVinculoTerc MT
               where MT.tipomultvinculo = MVFQ.tipomultvinculo
                 and MT.inscrfederal = MVFQ.inscrfederal
                 and MT.ORDEMCALCULO > MVFQ.ORDEMCALCULO) 
   
   and (TERC.CpfTerc = :pCpfTer
     or TERC.CodigoTerc = :pCodigoTerc)
   AND MVFQ.DATAINICIAL <= :pDataFinal
   AND (MVFQ.DATAFINAL >= :pDataInicial
    OR MVFQ.DATAFINAL IS NULL)
   AND (CAST(:pDataFinal AS DATE) <= CAST({TIMESTAMPADD(DAY, - {EXTRACT(DAY, {TIMESTAMPADD(MONTH, 1, cast(FB.COMPETFINAL as date))})} , {TIMESTAMPADD(MONTH, 1,  cast(FB.COMPETFINAL as date))})} AS DATE))
   AND (FB.COMPETINICIAL <= CAST(:pDataFinal AS DATE))
 ) T
  