SELECT SUM(VB.VALOR) VALOR
FROM TERCEIROPGTO TP
JOIN ORGANOGRAMA O
  ON TP.CODIGOEMPRESA = O.CODIGOEMPRESA
  AND TP.CODIGOESTAB   = O.CODIGOESTAB
  AND TP.CLASSIFORGAN  = O.CLASSIFORGAN
JOIN GPS GPS
 ON O.CODIGOEMPRESA = GPS.CODIGOEMPRESA
 AND O.CODIGOTABGPS  = GPS.CODIGOTABGPS
LEFT JOIN TERCEIROPGTOSERVICO VB
  ON VB.CODIGOEMPRESA = TP.CODIGOEMPRESA
  AND VB.CODIGOTERC = TP.CODIGOTERC
  AND VB.COMPET = TP.COMPET
  AND VB.SEQ = TP.SEQ
  AND VB.CODIGOSERVICO BETWEEN 9000 AND 9013
WHERE TP.CODIGOEMPRESA = :PCODIGOEMPRESA
  AND TP.CODIGOESTAB = :PCODIGOESTAB
  AND TP.COMPET = :PCOMPET
  AND TP.GPSORIGEM = :PGPSORIGEM
  AND GPS.CODIGOFPAS  = :PCODIGOFPAS
  AND (TP.INDOPCCP = :INDOPCCP or (:INDOPCCP = 0))
  AND GPS.DATAINICIAL = (SELECT MAX(GPS2.DATAINICIAL)
                         FROM GPS GPS2
                         WHERE GPS2.CODIGOEMPRESA = O.CODIGOEMPRESA
                           AND GPS2.CODIGOTABGPS = O.CODIGOTABGPS
                           AND GPS2.DATAINICIAL < :PMESSEG)
                                                     
ORDER BY 1