INSERT INTO TerceiroPgto (CodigoEmpresa, CodigoTerc, Compet,
                          Seq, CodigoEstab, ClassifOrgan,
                          SiglaEstado, CodigoMunic, DescrServico,
                          NumeroRPA, GPSOrigem, PercGPS,
                          AcresSat, DataPgto, DataVctoGPS,
                          NumeroDependIR, CodigoOutEmp, CodigoCentroCusto,
                          CodigoLocalCtb, OrigemDado, Numero,
                          Serie, TipoPagamento, DiasTrabalhados,
                          DataEmissao, ValorOrigemGps, VALORDEDUZIRINSSCARNE)
SELECT                    tp.CodigoEmpresa, tp.CodigoTerc, {fn Convert(:pCompet, SQL_Date)} Compet,
                          tp.Seq, tp.CodigoEstab, tp.ClassifOrgan,
                          tp.SiglaEstado, tp.CodigoMunic, tp.DescrServico,
                          tp.NumeroRPA, tp.GPSOrigem, tp.PercGPS,
                          tp.AcresSat, {fn Convert(:pDataPgto, SQL_Date)} DataPgto, {fn Convert(:pDataVctoGPS, SQL_Date)} DataVctoGPS,
                          tp.NumeroDependIR, tp.CodigoOutEmp, tp.CodigoCentroCusto,
                          tp.CodigoLocalCtb, tp.OrigemDado, tp.Numero,
                          tp.Serie, tp.TipoPagamento, tp.DiasTrabalhados,
                          tp.DataEmissao, tp.ValorOrigemGps, tp.VALORDEDUZIRINSSCARNE
FROM TerceiroPgto tp
JOIN TerceiroBanco tb
  ON tp.CodigoEmpresa = tb.CodigoEmpresa
  AND tp.CodigoTerc = tb.CodigoTerc
  AND tb.CalculoMensal = 1
where tp.Compet = :pCompetOrig
  and tp.CodigoEmpresa = :pCodigoEmpresa
  and tp.CodigoTerc = :pCodigoTerc