/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import com.healthmarketscience.jackcess.impl.query.AppendQueryImpl;
import com.healthmarketscience.jackcess.impl.query.QueryImpl;
import com.healthmarketscience.jackcess.query.Query;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.ucanaccess.converters.AppendQueryTemp;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.converters.TypesMap;

public class ParametricQuery {
    private Connection hsqldb;
    private QueryImpl qi;
    private boolean loaded;
    private PreparedStatement ps;
    private String parameters;
    private String defaultParameterValues;
    private boolean conversionOk;
    private boolean issueWithParameterName;
    private Map<String, String> aposMap;
    private List<String> parameterList;
    private Exception exception;
    private boolean isProcedure;
    private String sqlContent;
    private String signature;
    private StringBuffer originalParameters = new StringBuffer();

    public ParametricQuery(Connection _hsqldb, QueryImpl _qi) throws SQLException {
        this.hsqldb = _hsqldb;
        this.qi = _qi.getType() == Query.Type.APPEND ? new AppendQueryTemp((AppendQueryImpl)_qi) : _qi;
    }

    public boolean isIssueWithParameterName() {
        return this.issueWithParameterName;
    }

    public void setIssueWithParameterName(boolean _issueWithParameterName) {
        this.issueWithParameterName = _issueWithParameterName;
    }

    private List<String> queryParameters() {
        List l = this.qi.getParameters();
        if (this.aposMap != null) {
            return this.parameterList;
        }
        this.aposMap = new HashMap<String, String>();
        int i = 0;
        this.parameterList = new ArrayList<String>();
        this.parameterList.addAll(l);
        for (String par : this.parameterList) {
            if (par.indexOf("'") >= 0 || par.indexOf("\"") >= 0) {
                int index = Math.max(Math.max(par.lastIndexOf(32), par.lastIndexOf(10)), par.lastIndexOf(13));
                String decl = par.substring(0, index).trim();
                if (decl.startsWith("[")) {
                    decl = decl.substring(1, decl.length() - 1);
                }
                String h = this.treatApos(decl);
                this.aposMap.put(h, decl);
                this.parameterList.set(i, this.treatApos(par));
            }
            ++i;
        }
        return this.parameterList;
    }

    public void createProcedure() throws SQLException {
        this.isProcedure = true;
        String sql = null;
        try {
            List<String> l = this.queryParameters();
            sql = this.getSQL();
            if (l == null || l.size() == 0) {
                this.parametersEmpiric();
            } else {
                sql = SQLConverter.removeParameters(sql);
                this.parametersDeclared();
                if (!this.conversionOk) {
                    this.parametersEmpiric(true);
                }
            }
            if (!this.conversionOk) {
                return;
            }
            this.exception = null;
            String inside = this.convertSQL(this.convertApos(sql)).trim();
            if (!inside.endsWith(";")) {
                inside = inside + ";";
            }
            String procedureName = SQLConverter.escapeIdentifier(this.qi.getName(), this.hsqldb);
            String procedure = "CREATE PROCEDURE " + procedureName + "(" + this.parameters + ") MODIFIES SQL DATA \n BEGIN ATOMIC " + inside + "\n END";
            if (this.exec(procedure)) {
                this.signature = this.qi.getName() + "(" + this.originalParameters + ")";
                this.loaded = true;
            }
        }
        catch (Exception _ex) {
            this.exception = _ex;
        }
    }

    public void createSelect() throws SQLException {
        String qnn = null;
        String sql = null;
        try {
            List<String> l = this.queryParameters();
            qnn = SQLConverter.escapeIdentifier(this.qi.getName(), this.hsqldb);
            sql = this.getSQL();
            if (l == null || l.size() == 0) {
                this.parametersEmpiric();
            } else {
                sql = SQLConverter.removeParameters(sql);
                this.parametersDeclared();
                if (!this.conversionOk) {
                    this.parametersEmpiric();
                }
            }
            if (!this.conversionOk) {
                return;
            }
            this.exception = null;
            String inside = this.convertSQL(this.convertApos(sql)).trim();
            if (inside.endsWith(";")) {
                inside = inside.substring(0, inside.length() - 1);
            }
            String funName = qnn;
            String function = "CREATE FUNCTION " + funName + "(" + this.parameters + ") RETURNS TABLE (" + this.getTableDefinition() + ") READS SQL DATA \n RETURN (TABLE(" + inside + "));";
            if (!this.exec(function)) {
                return;
            }
            String createView = "CREATE VIEW " + qnn + " AS SELECT * FROM TABLE(" + funName + "(" + this.defaultParameterValues + "))";
            if (!this.exec(createView)) {
                return;
            }
            this.loaded = true;
        }
        catch (Exception _ex) {
            this.exception = _ex;
        }
    }

    private String convertApos(String sql) {
        if (this.aposMap != null) {
            for (Map.Entry<String, String> me : this.aposMap.entrySet()) {
                sql = sql.replaceAll("(?i)" + Pattern.quote("[" + me.getValue() + "]"), "[" + me.getKey() + "]");
            }
        }
        return sql;
    }

    private String getTableDefinition() throws SQLException {
        ResultSet rs = this.ps.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        StringBuffer sb = new StringBuffer();
        String comma = "";
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String type = this.completeTypeName(rsmd.getColumnTypeName(i), rsmd.getPrecision(i), rsmd.getScale(i), false);
            sb.append(comma).append(SQLConverter.escapeIdentifier(rsmd.getColumnLabel(i), this.hsqldb)).append(" ").append(type);
            comma = ",";
        }
        return sb.toString();
    }

    private String completeTypeName(String type, int i, int j, boolean useDefault) {
        if ("VARCHAR".equals(type)) {
            type = type + "(" + i + ")";
        }
        if ("NUMERIC".equals(type)) {
            type = useDefault ? type + "(100,10)" : type + "(" + i + "," + j + ")";
        }
        return type;
    }

    private String treatApos(String s) {
        s = s.replaceAll("'", "").replaceAll("\"", "").toUpperCase();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exec(String expression) throws SQLException {
        Statement st = null;
        try {
            st = this.hsqldb.createStatement();
            st.execute(expression);
            boolean bl = true;
            return bl;
        }
        catch (SQLException _ex) {
            this.exception = _ex;
            boolean bl = false;
            return bl;
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    private String getSQL() {
        if (this.sqlContent == null) {
            this.sqlContent = ParametricQuery.transalteFormFields(this.qi.toSQLString());
        }
        return this.sqlContent;
    }

    private static String transalteFormFields(String sqlString) {
        return sqlString.replaceAll("\\[([^\\]]*)\\]\\!\\[([^\\]]*)\\]\\!\\[([^\\]]*)\\]", "[$1_$2_$3]").replaceAll("\\[(\\w*)\\]\\!\\[(\\w*)\\]\\!\\[(\\w*)\\]", "[$1_$2_$3]").replaceAll("((?i)FORMS)\\.(\\w*)\\.(\\w*)", "[$1_$2_$3]");
    }

    private void parametersEmpiric() {
        this.parametersEmpiric(false);
    }

    private void parametersEmpiric(boolean partialParDecl) {
        this.aposMap = new HashMap<String, String>();
        LinkedHashMap<String, Integer> hm = new LinkedHashMap<String, Integer>();
        String s = this.getSQL();
        if (partialParDecl) {
            s = SQLConverter.removeParameters(s);
        }
        List<String> params = SQLConverter.getParameters(s);
        HashMap<String, String> parem = new HashMap<String, String>();
        this.getParametersEmpiric(hm, params, parem, s, true);
    }

    public Exception getException() {
        return this.exception;
    }

    private void parametersDeclared() {
        List<String> ls = this.queryParameters();
        StringBuffer args = new StringBuffer();
        String comma = "";
        ArrayList<String> ar = new ArrayList<String>();
        for (String string : ls) {
            String string2 = string.trim();
            int index = Math.max(Math.max(string2.lastIndexOf(32), string2.lastIndexOf(10)), string2.lastIndexOf(13));
            String decl = string2.substring(0, index).trim();
            String type = string2.substring(index).trim();
            if (!decl.startsWith("[")) {
                decl = "[" + decl + "]";
            }
            ar.add(decl);
            String type0 = type.indexOf("(") > 0 ? type.substring(0, type.indexOf("(")) : type;
            String typeS = type.indexOf("(") > 0 ? type.substring(type.indexOf("(")) : "";
            Map<String, String> hm = TypesMap.getAccess2HsqlTypesMap();
            type = hm.get(type0.toUpperCase()) + typeS;
            if (type.equalsIgnoreCase("VARCHAR")) {
                type = type + "(255)";
            }
            args.append(comma).append(decl).append(" ").append(type);
            comma = ",";
        }
        String sql = this.getSQL();
        sql = this.convertApos(SQLConverter.removeParameters(sql));
        for (String var : ar) {
            sql = sql.replaceAll("(?i)" + Pattern.quote(var), "?");
        }
        try {
            this.ps = this.hsqldb.prepareStatement(this.convertSQL(sql));
            if (!this.isProcedure) {
                ParameterMetaData parameterMetaData = this.ps.getParameterMetaData();
                StringBuffer defPar = new StringBuffer();
                comma = "";
                for (int i = 1; i <= parameterMetaData.getParameterCount(); ++i) {
                    if (!this.isProcedure) {
                        this.ps.setNull(i, parameterMetaData.getParameterType(i));
                    }
                    defPar.append(comma).append("NULL");
                    comma = ",";
                }
                this.defaultParameterValues = defPar.toString();
            }
            this.originalParameters = args;
            this.parameters = SQLConverter.convertSQL(args.toString()).getSql();
            this.conversionOk = true;
        }
        catch (SQLException sQLException) {
            this.exception = sQLException;
        }
    }

    private List<Integer> parIndexes(String s) {
        ArrayList<Integer> ar = new ArrayList<Integer>();
        char character = '?';
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != character) continue;
            ar.add(i);
        }
        return ar;
    }

    private String convertSQL(String sql) {
        String h = SQLConverter.convertSQL(sql, true).getSql();
        return h;
    }

    private String convertSQL(String sql, List<String> parameters2) {
        for (String s : parameters2) {
            if (s.indexOf("'") <= 0 && s.indexOf("\"") <= 0) continue;
            String src = Pattern.quote(s);
            String target = this.treatApos(s);
            sql = sql.replaceAll(src, target);
            this.aposMap.put(target.substring(1, target.length() - 1), s.substring(1, s.length() - 1));
        }
        return this.convertSQL(sql);
    }

    private void getParametersEmpiric(Map<String, Integer> _psmp, List<String> _parameters, Map<String, String> parem, String sql, boolean init) {
        block8: {
            String psTxt = null;
            try {
                psTxt = this.convertSQL(sql, _parameters);
                List<String> l = SQLConverter.getParameters(psTxt);
                for (String s : l) {
                    String h = this.treatApos(s);
                    for (String modf : _parameters) {
                        if (!this.convertSQL(modf).equals(s) || this.aposMap.containsKey(h = this.treatApos(modf))) continue;
                        _parameters.set(_parameters.indexOf(modf), h);
                        psTxt = psTxt.replaceAll("(?i)" + Pattern.quote(s), this.convertSQL(h));
                        sql = sql.replaceAll("(?i)" + Pattern.quote(modf), h);
                        h = h.substring(1, h.length() - 1);
                        this.aposMap.put(h, modf.substring(1, modf.length() - 1));
                    }
                }
                this.ps = this.hsqldb.prepareStatement(psTxt);
                ParameterMetaData pmd = this.ps.getParameterMetaData();
                ArrayList<String> ar = new ArrayList<String>();
                _psmp = this.reorderIndexes(_psmp, parem);
                ar.addAll(_psmp.keySet());
                List<Integer> pI = this.parIndexes(sql);
                StringBuffer parS = new StringBuffer();
                StringBuffer defPar = new StringBuffer();
                int j = 0;
                String comma = "";
                for (int i = 1; i <= pmd.getParameterCount(); ++i) {
                    String key;
                    int index;
                    if (!this.isProcedure) {
                        this.ps.setNull(i, pmd.getParameterType(i));
                    }
                    if (j > ar.size() - 1 || (index = _psmp.get(key = (String)ar.get(j)).intValue()) != pI.get(i - 1)) continue;
                    defPar.append(comma).append("NULL");
                    String type = this.completeTypeName(pmd.getParameterTypeName(i), pmd.getPrecision(i), pmd.getScale(i), true);
                    parS.append(comma).append(SQLConverter.escapeIdentifier(key, this.hsqldb)).append(" ").append(type);
                    comma = ",";
                    ++j;
                }
                this.parameters = parS.toString();
                this.defaultParameterValues = defPar.toString();
                this.conversionOk = true;
            }
            catch (SQLException _ex) {
                for (String par : _parameters) {
                    String par1 = SQLConverter.preEscapingIdentifier(par.substring(1, par.length() - 1));
                    int index = sql.toUpperCase().indexOf(par.toUpperCase());
                    if (index >= 0 && _ex.getMessage() != null && (_ex.getMessage().toUpperCase().endsWith(": " + par1) || _ex.getMessage().toUpperCase().indexOf(": " + par1 + " IN STATEMENT ") != -1)) {
                        sql = sql.replaceAll("(?i)" + Pattern.quote(par), "?");
                        _psmp.put(par1, index);
                        parem.put(par1, par);
                        String parname = this.originalParameters.length() == 0 ? par : "," + par;
                        this.originalParameters.append(parname);
                        this.getParametersEmpiric(_psmp, _parameters, parem, sql, false);
                        continue;
                    }
                    this.exception = _ex;
                }
                if (this.exception != null) break block8;
                this.exception = _ex;
            }
        }
    }

    private Map<String, Integer> reorderIndexes(Map<String, Integer> psmp, Map<String, String> parem) {
        TreeMap<Integer, String> tm = new TreeMap<Integer, String>();
        Integer[] nI = new Integer[psmp.size()];
        String[] sI = new String[psmp.size()];
        HashMap<String, Integer> dI = new HashMap<String, Integer>();
        int j = 0;
        for (Map.Entry<String, Integer> me : psmp.entrySet()) {
            tm.put(me.getValue(), me.getKey());
            nI[j] = me.getValue();
            sI[j] = me.getKey();
            dI.put(sI[j], 0);
            ++j;
        }
        boolean changedSignature = false;
        for (int i = 0; i < tm.size() - 1; ++i) {
            for (j = i + 1; j < tm.size(); ++j) {
                if (nI[j] >= nI[i]) continue;
                changedSignature = true;
                dI.put(sI[i], (Integer)dI.get(sI[i]) - parem.get(sI[j]).length() + 1);
            }
        }
        LinkedHashMap<String, Integer> rlhm = new LinkedHashMap<String, Integer>();
        for (Map.Entry me : tm.entrySet()) {
            rlhm.put((String)me.getValue(), (Integer)me.getKey() + (Integer)dI.get(me.getValue()));
        }
        if (changedSignature) {
            StringBuffer sb = new StringBuffer();
            String comma = "";
            for (String key : rlhm.keySet()) {
                sb.append(comma).append(parem.get(key));
                comma = ",";
            }
            this.originalParameters = sb;
        }
        return rlhm;
    }

    public boolean loaded() {
        return this.loaded;
    }

    public String getSignature() {
        return this.signature;
    }
}

