select ETC.CodigoTabCtb,
       sum(ce.ValorEvento) Valor,
	   CE.CodigoEvento
  from CalculoEvento ce
  join CFGEmpresaFPA CFG 
    on CFG.CodigoEmpresa = ce.CodigoEmpresa
  join EventoTabelaContabil ETC 
       on ETC.CodigoEvento = ce.CodigoEvento
      and ETC.CodigoGrupoTabelaContabil = CFG.CodigoGrupoTabelaContabil    
 where ce.CodigoEmpresa = :pCodigoEmpresa
   and ce.CodigoPerCalculo = :pCodigoPerCalculo
   and ce.CodigoFuncContr = :pCodigoFuncContr
   and (ETC.CodigoTabCtb is not null or ETC.CodigoTabCtb <> 0)
 group by ETC.CodigoTabCtb,
          CE.CodigoEvento
having sum(ce.ValorEvento) <> 0
 order by 1 