select Fp.CpfFunc,
       FPC.DataPgtoFolha,
       CE.BaseEvento
 from FuncContrato f
 join FuncPessoa FP
   on Fp.codigofuncPessoa = F.codigofuncPessoa
 join FuncPerCalculo FPC
   on FPC.CodigoEmpresa   = F.CodigoEmpresa
  and FPC.CodigoFuncContr = F.CodigoFuncContr
 join TIPOCONTRATO TC
   on tc.CODIGOTIPOCONTR = f.CODIGOTIPOCONTR
  and tc.CATEGESOCIAL <> '111'      
 join CalculoEvento CE
   on CE.CodigoEmpresa = FPC.CodigoEmpresa
  and CE.CodigoPerCalculo = FPC.CodigoPerCalculo
  and CE.CodigoFuncContr = FPC.CodigoFuncContr
 join PeriodoCalculo PC
   on PC.CodigoEmpresa = FPC.CodigoEmpresa
  and PC.CodigoPerCalculo = FPC.CodigoPerCalculo
where F.CodigoEmpresa = :pCodigoEmpresa
  and FPC.DataPgtoFolha between :pCompetIni and :pCompetFin
  and CE.CodigoEvento = :pCodigoEvento
  and PC.DataFinalFolha >= FPC.DataLocal
  and PC.codigotipocalc <> 80

union all

select Fp.CpfFunc,
       ri.DATAPGTO DataPgtoFolha,
       ie.BASEEVENTO   
 from FuncContrato f
 join FuncPessoa FP
   on Fp.codigofuncPessoa = F.codigofuncPessoa
 join TIPOCONTRATO TC
   on tc.CODIGOTIPOCONTR = f.CODIGOTIPOCONTR
  and tc.CATEGESOCIAL = '111' 
 join recibointermitente ri
   on ri.CODIGOEMPRESA = F.CodigoEmpresa
  and ri.CODIGOFUNCCONTR = f.codigofunccontr
 join INTERMITENTEEVENTO ie
   on ie.CODIGOEMPRESA = ri.CODIGOEMPRESA
  and ie.CODIGOFUNCCONTR = ri.CODIGOFUNCCONTR
  and ie.CODIGOCONVOCACAO = ri.CODIGOCONVOCACAO 
where F.CodigoEmpresa = :pCodigoEmpresa
  and ri.DATAPGTO between :pCompetIni and :pCompetFin
  and ie.CodigoEvento = :pCodigoEvento
 group by 
       Fp.CpfFunc,
       ri.DATAPGTO,
       ie.BASEEVENTO   

order by 1, 2   
