   select CE.CodigoEmpresa,
          CE.CodigoFuncContr,
          CE.CodigoEvento,
          CE.ReferEvento,
          CE.ValorEvento,
          CE.BaseEvento,
          E.TipoEvento,
          E.DescrEvento,
          E.CodigoProced,
          E.CodigoEstrut,
          TC.TipoContr,
          E.ReferEvento TipoReferEvento,
          FP.NomeFunc,
          SC.TipoQuebraCaixa,
          FL.ClassifOrgan,
          FS.TipoSalario
     from FuncContrato F
     join FuncPessoa FP
       on FP.CodigoFuncPessoa = F.CodigoFuncPessoa   
     join FuncSalario FS
       on F.CodigoEmpresa = FS.CodigoEmpresa and
          F.CodigoFuncContr = FS.CodigoFuncContr,
          FuncPerCalculo FPC
inner Join SindConvencao SC
       on SC.CodigoSind = FPC.CodigoSind
      and SC.DataInicial = (Select Max(SCa.DataInicial)
                              from SindConvencao SCa
                             where SCa.CodigoSind = SC.CodigoSind
                               and SCa.DataInicial <= :pDataFinalFolha),
          FuncLocal FL,
          CalculoEvento CE,
          Evento E,
          TipoContrato TC
    where CE.CodigoEvento = E.CodigoEvento
      and CE.CodigoEmpresa = :pCodigoEmpresa
      and CE.CodigoPerCalculo = :pCodigoPerCalculo
      and CE.CodigoEmpresa = FPC.CodigoEmpresa
      and CE.CodigoFuncContr = FPC.CodigoFuncContr
      and CE.CodigoPerCalculo = FPC.CodigoPerCalculo
      and FPC.CodigoEmpresa = FL.CodigoEmpresa
      and FPC.CodigoFuncContr = FL.CodigoFuncContr
      and FPC.DataLocal = FL.DataTransf
      and FL.CodigoEstab = :pCodigoEstab
      and CE.CodigoEmpresa = F.CodigoEmpresa
      and CE.CodigoFuncContr = F.CodigoFuncContr
      and F.CodigoTipoContr = TC.CodigoTipoContr
      and FPC.DataLocal <= :pDataFinalFolha
      and FS.DataInicial = FPC.DataSalario
      and FS.SEQ        = FPC.SeqFuncSalario
order by 1,         
         2,
         3