  select CodigoBenef,
         ValorPensao
    from CalculoPensao
   where CodigoEmpresa = :CodigoEmpresa
     and CodigoFuncContr = :CodigoFuncContr
     and CodigoBenef = :CodigoBenef
     and (CodigoPerCalculo = :CodigoPerCalculo
      or CodigoPerCalculo is null)
     and (Complementar <= :Complementar
      or Complementar is null)
     and CodigoEstrut = :CodigoEstrut
union all	 
  select CP.CodigoBenef,
         CP.ValorPensao	 
    from CalculoPensao CP
   where CP.CodigoEmpresa = :CodigoEmpresa
     and CP.CodigoFuncContr = :CodigoFuncContr
     and CP.CodigoBenef = :CodigoBenef
	 and CP.CodigoPerCalculo is not null
     and exists(select 1 
                  from PeriodoCalculo P
                 where P.CodigoEmpresa = CP.CodigoEmpresa
                   and P.CodigoPerCalculo = CP.CodigoPerCalculo
                   and P.CodigoPerCalcCompl = :CodigoPerCalculo
				   and P.CodigoTipoCalc <> 6 ) 
     and CP.Complementar is null
     and CP.CodigoEstrut = :CodigoEstrut
order by 1
