select pj.NomeBenef,
         pj.CPFBenef,
         cp.CodigoEstrut,
         sum(cp.ValorPensao) ValorPensao
    from FuncContrato   f,
         PensaoJud     pj,
         CalculoPensao cp
  join FuncPessoa FP
    on FP.CodigoFuncPessoa = F.CodigoFuncPessoa   
   where f.CodigoEmpresa   = :pCodigoEmpresa
     and fp.CPFFunc         = :pCPFFunc
     and f.CodigoEmpresa   = pj.CodigoEmpresa
     and f.CodigoFuncContr      = pj.CodigoFuncContr
     and pj.CodigoEmpresa  = cp.CodigoEmpresa
     and pj.CodigoFuncContr     = cp.CodigoFuncContr
     and pj.CodigoBenef    = cp.CodigoBenef
     and cp.DataPgto between :pCompetIni and :pCompetFin
     and (cp.DataPgto >= f.DataTransfEmp
      or f.DataTransfEmp is null)
group by pj.NomeBenef,
         pj.CPFBenef,
         cp.CodigoEstrut
 having sum(cp.ValorPensao) > 0
order by 1, 2, 3
