  select FPC.CodigoFuncContr,
         PC.Compet,
         E.CodigoEstrut,
         cast(sum(CR.ValorEvento) as numeric(16,2)) ValorEvento,
         cast(sum(CR.ReferEvento) as numeric(18,2)) ReferEvento,
         cast(sum(CR.BaseEvento) as numeric(18,9)) BaseEvento
    from PeriodoCalculo PC
    join FuncPerCalculo FPC
     on  FPC.CodigoEmpresa = PC.CodigoEmpresa
     and FPC.CodigoPerCalculo = PC.CodigoPerCalculo
    join FuncLocal FL
      on FL.CodigoEmpresa = FPC.CodigoEmpresa
     and FL.CodigoFuncContr = FPC.CodigoFuncContr
     and FL.DataTransf = FPC.DataLocal
    join CalculoRateio CR
      on CR.CodigoEmpresa = FPC.CodigoEmpresa
     and CR.CodigoPerCalculo = FPC.CodigoPerCalculo
     and CR.CodigoFuncContr = FPC.CodigoFuncContr    
    join Evento E
      on E.CodigoEvento = CR.CodigoEvento
     left join OutraEmpEmp OEE
     on OEE.CodigoEmpresa = CR.CodigoEmpresa
     and OEE.CodigoOutEmp = CR.CodigoOutEmp     
   where PC.CodigoEmpresa = :pCodigoEmpresa
     and pc.Compet between :pDataInicial and :pDataFinal
     and FL.CodigoEstab = :pCodigoEstab
     and PC.CodigoTipoCalc in (1, 7)
     and (E.CodigoEstrut = '01.01.08.01'
      or  E.CodigoEstrut = '01.01.09.01'
      or  E.CodigoEstrut like '97.01%')
     and OEE.TipoOutEmp = 1
     and OEE.TipoObra in (1, 3)
group by FPC.CodigoFuncContr,
         PC.Compet,
         E.CodigoEstrut
         
union all

  select FPC.CodigoFuncContr,
         PC.Compet,
         E.CodigoEstrut,
         cast(sum(CR.ValorEvento) as numeric(16,2)) ValorEvento,
         cast(sum(CR.ReferEvento) as numeric(18,2)) ReferEvento,
         cast(sum(CR.BaseEvento) as numeric(18,9)) BaseEvento
    from PeriodoCalculo PC
    join FuncPerCalculo FPC
     on  FPC.CodigoEmpresa = PC.CodigoEmpresa
     and FPC.CodigoPerCalculo = PC.CodigoPerCalculo
    join FuncLocal FL
      on FL.CodigoEmpresa = FPC.CodigoEmpresa
     and FL.CodigoFuncContr = FPC.CodigoFuncContr
     and FL.DataTransf = FPC.DataLocal
    join CalculoRateio CR
      on CR.CodigoEmpresa = FPC.CodigoEmpresa
     and CR.CodigoPerCalculo = FPC.CodigoPerCalculo
     and CR.CodigoFuncContr = FPC.CodigoFuncContr    
    join Evento E
      on E.CodigoEvento = CR.CodigoEvento
     left join OutraEmpEmp OEE
     on OEE.CodigoEmpresa = CR.CodigoEmpresa
     and OEE.CodigoOutEmp = CR.CodigoOutEmp     
   where PC.CodigoEmpresa = :pCodigoEmpresa
     and pc.Compet between :pDataInicial and :pDataFinal
     and FL.CodigoEstab = :pCodigoEstab
     and PC.CodigoTipoCalc in (20, 21, 23)
     and E.CodigoEstrut = '97.01.02'
     and OEE.TipoOutEmp = 1
     and OEE.TipoObra in (1, 3)
group by FPC.CodigoFuncContr,
         PC.Compet,
         E.CodigoEstrut
order by 1, 2, 3
