  select CR.CodigoOutEmp,
         FPC.CodigoFuncContr,
         PC.Compet,
         E.CodigoEstrut,
         cast(sum(CR.ValorEvento) as numeric(16,2)) ValorEvento,
         cast(sum(CR.ReferEvento) as numeric(18,2)) ReferEvento,
         cast(sum(CR.BaseEvento) as numeric(18,9)) BaseEvento
    from PeriodoCalculo PC,
         FuncPerCalculo FPC,
         FuncLocal FL,
         CalculoRateio CR,
         Evento E
   where PC.CodigoEmpresa = FPC.CodigoEmpresa
     and PC.CodigoPerCalculo = FPC.CodigoPerCalculo
     and FPC.CodigoEmpresa = FL.CodigoEmpresa
     and FPC.CodigoFuncContr = FL.CodigoFuncContr
     and FPC.DataLocal = FL.DataTransf
     and FPC.CodigoEmpresa = CR.CodigoEmpresa
     and FPC.CodigoPerCalculo = CR.CodigoPerCalculo
     and FPC.CodigoFuncContr = CR.CodigoFuncContr
     and CR.CodigoEvento = E.CodigoEvento
     and PC.CodigoEmpresa = :pCodigoEmpresa
     and PC.Compet between :pDataInicial and :pDataFinal
     and FL.CodigoEstab = :pCodigoEstab
     and PC.CodigoTipoCalc in (1, 7)
     and (E.CodigoEstrut = '01.01.08.01'
      or  E.CodigoEstrut = '01.01.09.01'
      or  E.CodigoEstrut like '97.01%')
group by CR.CodigoOutEmp,
         FPC.CodigoFuncContr,
         PC.Compet,
         E.CodigoEstrut
         
union all

  select CR.CodigoOutEmp,
         FPC.CodigoFuncContr,
         PC.Compet,
         E.CodigoEstrut,
         cast(sum(CR.ValorEvento) as numeric(16,2)) ValorEvento,
         cast(sum(CR.ReferEvento) as numeric(18,2)) ReferEvento,
         cast(sum(CR.BaseEvento) as numeric(18,9)) BaseEvento
    from PeriodoCalculo PC,
         FuncPerCalculo FPC,
         FuncLocal FL,
         CalculoRateio CR,
         Evento E
   where PC.CodigoEmpresa = FPC.CodigoEmpresa
     and PC.CodigoPerCalculo = FPC.CodigoPerCalculo
     and FPC.CodigoEmpresa = FL.CodigoEmpresa
     and FPC.CodigoFuncContr = FL.CodigoFuncContr
     and FPC.DataLocal = FL.DataTransf
     and FPC.CodigoEmpresa = CR.CodigoEmpresa
     and FPC.CodigoPerCalculo = CR.CodigoPerCalculo
     and FPC.CodigoFuncContr = CR.CodigoFuncContr
     and CR.CodigoEvento = E.CodigoEvento
     and PC.CodigoEmpresa = :pCodigoEmpresa
     and PC.Compet between :pDataInicial and :pDataFinal
     and FL.CodigoEstab = :pCodigoEstab
     and PC.CodigoTipoCalc in (20, 21, 23)
     and E.CodigoEstrut = '97.01.02'
group by CR.CodigoOutEmp,
         FPC.CodigoFuncContr,
         PC.Compet,
         E.CodigoEstrut

order by 1, 2, 3, 4
