SELECT X.CodigoEmpresa,
       X.InscrFederalBenef,
       X.TipoInscrBenef,
       SUM(X.Aposentadoria + 
           X.Diarias + 
           X.Invalidez + 
           X.Lucrodivid1996 +
           X.VlrPagoSocioPqEmp + 
           X.Indenizacao + 
           X.OutrosRendIsento +    
           X.Valor13 + 
           X.ValorOutros + 
           X.JurosCapitalProprio) as ValorOutrosRend,
       (SUM(X.ValorRendimento + 
            coalesce((Select D.ValorRendimento from DIRFReg2Det D
                       where D.CodigoEmpresa = X.CodigoEmpresa
                         and D.AnoBase = X.AnoBase
                         and D.TipoInscrBenef = X.TipoInscrBenef
                         and D.InscrFederalBenef = X.InscrFederalBenef
                         and D.CodigoRetencao = X.CodigoRetencao
                         and D.Mes = 13), 0))) as ValorRendimento,       
       (SUM(X.ValorRetido + 
            coalesce((Select D.ValorRetido from DIRFReg2Det D
                       where D.CodigoEmpresa = X.CodigoEmpresa
                         and D.AnoBase = X.AnoBase
                         and D.TipoInscrBenef = X.TipoInscrBenef
                         and D.InscrFederalBenef = X.InscrFederalBenef
                         and D.CodigoRetencao = X.CodigoRetencao
                         and D.Mes = 13), 0))) as ValorRetido,
       E.NomeEmpresa 
  FROM DIRFREG2 X
  JOIN EMPRESA E
    ON E.CODIGOEMPRESA = X.CODIGOEMPRESA
 WHERE X.ANOBASE = :pANOBASE
   %s
 GROUP BY X.CodigoEmpresa,
       X.InscrFederalBenef,
       X.TipoInscrBenef,
       E.NomeEmpresa
