select T.CPFTerc,
       extract(month from cp.DataPgto) MES, 
       pj.NomeBenef,
       pj.CPFBenef,
       cp.DataPgto,
       pj.Parentesco,
       pj.DataNasc,
      sum(cp.valor) ValorPensao
 from TerceiroPgto x
 join PensaoJudTerc pj
   on pj.CodigoEmpresa = x.CodigoEmpresa
  and pj.CodigoTerc    = x.CodigoTerc
 join CalculoPensaoTerc cp
   on cp.CodigoEmpresa   = pj.CodigoEmpresa
  and cp.CodigoTerc      = pj.CodigoTerc
  and cp.CodigoBenef     = pj.CodigoBenef
  and cp.compet          = x.compet
  and cp.seqterceiropgto = x.seq
  join Terceiro T
   on T.CodigoTerc = X.CodigoTerc
 where cp.DataPgto between :pCompetIni and :pCompetFin
  %s
 group by T.CPFTerc,
          extract(month from cp.DataPgto),    
          pj.NomeBenef,
          pj.CPFBenef,
          cp.DataPgto,
          pj.Parentesco,
          pj.DataNasc
having sum(cp.valor) > 0
 order by 1, 2, 7, 3