Select
FS.DataInicial as fsDataInicial,
Cast(null as Integer) as FSPCodigoProfTipoAula,
Cast(null as varchar(150)) as PTADescrProfTipoAula,
FS.ValorSal as FSValorSal,
FS.TipoSalario as FSTipoSalario,
FS.CodigoEstrutSal as FSCodigoEstrutSal,
FS.CodigoTabSal as FSCodigoTabSal,
FS.CodigoMotivo as FSCodigoMotivo,
FS.ComplSal as FSComplSal,
FS.AntecSal as FSAntecSal,
M.DescrMotivo as MotDescrMotivo,
FS.CodigoEmpresa as FSCodigoEmpresa,
FS.PercAumento as FSPercAumento,
FS.DATAEFEITO as FSDataEfeito,
FS.SEQ AS FSSEQ
From
FuncSalario FS
Join FuncContrato FC on FC.CodigoEmpresa = FS.CodigoEmpresa
    And FC.CodigoFuncContr = FS.CodigoFuncContr
    And FC.FormaCalculo = 1
Join Motivo M on M.CodigoMotivo = FS.CodigoMotivo
Where FS.CodigoEmpresa = :CodigoEmpresa
And FS.CodigoFuncContr = :CodigoFuncContr
group by FS.DataInicial,
FS.ValorSal,
FS.TipoSalario,
FS.CodigoEstrutSal,
FS.CodigoTabSal,
FS.CodigoMotivo,
FS.ComplSal,
FS.AntecSal,
M.DescrMotivo,
FS.CodigoEmpresa,
FS.PercAumento,
FS.DATAEFEITO,
FS.SEQ
Union

Select
FSP.DataInicial as fsDataInicial,
FSP.CodigoProfTipoAula as FSPCodigoProfTipoAula,
PTA.DescrProfTipoAula as PTADescrProfTipoAula,
FSP.ValorAula as FSValorSal,
FS.TipoSalario as FSTipoSalario,
FS.CodigoEstrutSal as FSCodigoEstrutSal,
FS.CodigoTabSal as FSCodigoTabSal,
FS.CodigoMotivo as FSCodigoMotivo,
FS.ComplSal as FSComplSal,
FS.AntecSal as FSAntecSal,
M.DescrMotivo as MotDescrMotivo,
FS.CodigoEmpresa as FSCodigoEmpresa,
FS.PercAumento as FSPercAumento,
FS.DATAEFEITO as FSDataEfeito,
FS.SEQ AS FSSEQ
From
FuncSalario FS
Join FuncContrato FC on FC.CodigoEmpresa = FS.CodigoEmpresa
    And FC.CodigoFuncContr = FS.CodigoFuncContr
    And FC.FormaCalculo in (2, 3)
Join FuncContratoProf FCP on FCP.CodigoEmpresa = FC.CodigoEmpresa
    And FCP.CodigoFuncContr = FC.CodigoFuncContr
    And FCP.DataInicial <= FS.DataInicial
Join FuncSalarioProf FSP on FSP.CodigoEmpresa = FS.CodigoEmpresa
    And FSP.CodigoFuncContr = FS.CodigoFuncContr
    And FSP.DataInicial = FS.DataInicial
Join Motivo M on M.CodigoMotivo = FS.CodigoMotivo
Join ProfTipoAula PTA on PTA.CodigoProfTipoAula = FSP.CodigoProfTipoAula
    And PTA.CodigoEmpresa = FSP.CodigoEmpresa
Where FS.CodigoEmpresa = :CodigoEmpresa
And FS.CodigoFuncContr = :CodigoFuncContr

Group By FSP.DataInicial,
FSP.CodigoProfTipoAula,
PTA.DescrProfTipoAula,
FSP.ValorAula,
FS.TipoSalario,
FS.CodigoEstrutSal,
FS.CodigoTabSal,
FS.CodigoMotivo,
FS.ComplSal,
FS.AntecSal,
M.DescrMotivo,
FS.CodigoEmpresa,
FS.PercAumento,
FS.DATAEFEITO,
FS.SEQ

Order By 1
