  select ce.CodigoEmpresa,
         ce.CodigoFuncContr,
         sum(ce.ValorEvento) / tip.SalarioMinimo QtdeSal

    from CalculoEvento ce,
         FuncContrato f,
         TipoContrato tc,
         Afastamento af,
         PeriodoCalculo pc,
         TabelaINSSPer tip

   where ce.CodigoEmpresa = :pCodigoEmpresa
     and ce.CodigoEvento = 5021
     and f.CodigoEmpresa = ce.CodigoEmpresa
     and f.CodigoFuncContr = ce.CodigoFuncContr
     and f.ParticPAT <> 0
     and f.DataDem is null
     and tc.CodigoTipoContr = f.CodigoTipoContr
     and tc.ConstaRais <> 0
     and pc.CodigoEmpresa = ce.CodigoEmpresa
     and pc.CodigoPerCalculo = ce.CodigoPerCalculo
     and pc.Compet = (Select max(pca.Compet)
                        from PeriodoCalculo pca
                       where pca.CodigoEmpresa = pc.CodigoEmpresa
                         and pca.Compet between :pDataInicial and :pDataFinal)

     and not exists (Select af.CodigoFuncContr,
                             ({TIMESTAMPADD(MONTH, 1, pc.Compet)} -1)
                       from Afastamento af
                      where af.CodigoEmpresa = f.CodigoEmpresa
                        and af.CodigoFuncContr = f.CodigoFuncContr
                        and ((af.DataAfast <= ({TIMESTAMPADD(MONTH, 1, pc.Compet)} -1)
                        and  (af.DataTermino is null or af.DataTermino > ({TIMESTAMPADD(MONTH, 1, pc.Compet)} -1)))
                         or  (af.DataTermino between pc.Compet and ({TIMESTAMPADD(MONTH, 1, pc.Compet)} -1))))

     and tip.CodigoTabINSS = tc.CodigoTabINSS
     and tip.DataInicial = (select max(ti.DataInicial)
                              from TabelaINSSPer ti
                             where ti.CodigoTabINSS = tip.CodigoTabINSS
                               and ti.DataInicial <  {TIMESTAMPADD(MONTH, 1, pc.Compet)})

group by ce.CodigoEmpresa,
         ce.CodigoFuncContr,
         tip.SalarioMinimo

order by 1, 2