Select   
    FP.NomeFunc,
    FP.DataNasc,
    FC.DataAdm,
    FP.PisFunc,
    FP.Nacionalidade,
    FP.DataChegada,
    FP.GrauInstr,
    FP.CPFFunc,
    FTD.UTILIZACARTEIRADIGITAL,
    FTD.NumeroCTPS,
    FTD.SerieCTPS,
    FC.TipoVinculo,
    FP.RacaCor,
    FC.PossuiAlvara,
    FP.Sexo,
    FC.DataDem,
    cast(FSA.ValorSal as numeric(16,2)) ValorSal,
    FSA.TipoSalario,
    Cast (E.CargaHorMensal / 300 As Numeric(14,4)) HorasSem,
    C.CBO,
    TC.CodigoTabINSS,
    FC.ParticPat,
    Cast(E.CargaHorMensal as Numeric(14,4)) CargaHorMensal,
    FS.CodigoSind,
    FC.FormaCalculo,
    FS.Sindicalizado,
    FP.DefFisica,
    FP.DefVisual,
    FP.DefAuditiva,
    FP.DefMental,
    FP.DefIntelectual,
    FP.DefReabilitado,
    cast (0 As Integer) Professor,
    FC.CODIGOTIPOCONTR,
    FC.CATEGESOCIAL,
    FC.MatriculaeSocial,
    FE.REGIMEJOR REGIMEJOR
from FuncContrato FC
    Join FuncPessoa FP on FP.CodigoFuncPessoa = FC.CodigoFuncPessoa
    Inner Join FuncSindicato FS on FS.CodigoEmpresa = FC.CodigoEmpresa
        And FS.CodigofuncContr = FC.CodigofuncContr
        And FS.DataInicial = (Select Max(FSs.DataInicial)
                                From FuncSindicato FSs
                                Where FSs.CodigoEmpresa = FC.CodigoEmpresa
                                    And FSs.CodigofuncContr = FC.CodigofuncContr
                                    And FSs.DataInicial <= :pDataFinal)
  left Join FuncSalario FSDEF 
    on FSDEF.CodigoEmpresa = FC.CodigoEmpresa
   and FSDEF.CodigoFuncContr = FC.CodigoFuncContr
   and FSDEF.DataEfeito is not null
   and FSDEF.DataEfeito = (Select Max(FSs.DataEfeito)
                             From FuncSalario FSs
                             Where FSs.CodigoEmpresa = FSDEF.CodigoEmpresa
                               And FSs.CodigoFuncContr = FSDEF.CodigoFuncContr
                               And FSs.DataEfeito <= :pDataFinal)
                               
     and FSDEF.SEQ = (select max(FuB.SEQ)
                              from FuncSalario FuB
                             where FuB.DataInicial      = FSDEF.DataInicial
                               and FuB.CodigoEmpresa   = FSDEF.CodigoEmpresa 
                               and FuB.CodigoFuncContr = FSDEF.CodigoFuncContr)
                               
                               
 left Join FuncSalario FSDI 
    on FSDI.CodigoEmpresa = FC.CodigoEmpresa
   and FSDI.CodigoFuncContr = FC.CodigoFuncContr
   and FSDI.DataEfeito is null
   and FSDI.DataInicial = (Select Max(FSs.DataInicial)
                             From FuncSalario FSs
                             Where FSs.CodigoEmpresa = FSDI.CodigoEmpresa
                               And FSs.CodigoFuncContr = FSDI.CodigoFuncContr
                               And FSs.DataInicial <= :pDataFinal)
                               
     and FSDI.SEQ = (select max(FuB.SEQ)
                              from FuncSalario FuB
                             where FuB.DataInicial      = FSDI.DataInicial
                               and FuB.CodigoEmpresa   = FSDI.CodigoEmpresa 
                               and FuB.CodigoFuncContr = FSDI.CodigoFuncContr)                          
  Join FuncSalario FSA 
    on FSA.CodigoEmpresa = FC.CodigoEmpresa
   and FSA.CodigoFuncContr = FC.CodigoFuncContr
   and (((FSDI.DataInicial >= FSDEF.DataEfeito 
    or  FSDEF.DataEfeito  is null)
   and FSA.DataInicial = FSDI.DataInicial
   and FSA.SEQ = FSDI.SEQ)
   or ((FSDI.DataInicial < FSDEF.DataEfeito  
    or FSDI.DataInicial is null)
   and FSA.DataInicial = FSDEF.DataInicial
   and FSA.SEQ = FSDEF.SEQ) )   
   
    Join FuncEscala FE on FE.CodigoEmpresa = FC.CodigoEmpresa
        And FE.CodigoFuncContr = FC.CodigoFuncContr
        And FE.DataInicial = (Select Max(FEs.DataInicial)
                              From FuncEscala FEs
                             Where FEs.CodigoEmpresa = FC.CodigoEmpresa
                               And FEs.CodigoFuncContr = FC.CodigoFuncContr
                               And FEs.DataInicial <= :pDataFinal)
    Join Escala E on E.CodigoEscala = FE.CodigoEscala
    Join FuncCargo FCA on FCA.CodigoEmpresa = FC.CodigoEmpresa
        And FCA.CodigoFuncContr = FC.CodigoFuncContr
        And FCA.DataInicial = (Select Max(FCs.DataInicial)
                                From FuncCargo FCs
                                Where FCs.CodigoEmpresa = FC.CodigoEmpresa
                                    And FCs.CodigoFuncContr = FC.CodigoFuncContr
                                    And FCs.DataInicial <= :pDataFinal)
    Join Cargo C on C.CodigoCargo = FCA.CodigoCargo
   left JOIN (SELECT FTD.CODIGOEMPRESA,
                      FTD.CODIGOFUNCCONTR, 
                  MAX(FTD.DATAINICIAL) DATAINICIAL 
            FROM FUNCCTPS FTD 
            GROUP BY FTD.CODIGOEMPRESA, FTD.CODIGOFUNCCONTR) FCTD 
              ON FCTD.CODIGOEMPRESA = FC.CODIGOEMPRESA 
             AND FCTD.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR 
   left JOIN FUNCCTPS FTD 
              ON FTD.CODIGOEMPRESA = FC.CODIGOEMPRESA 
             AND FTD.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR 
             AND FTD.DATAINICIAL = FCTD.DATAINICIAL
    Join TipoContrato TC on TC.CodigoTipoContr = FC.CodigoTipoContr
    Join CFGEmpresaFPA CEF on CEF.CodigoEmpresa = FC.CodigoEmpresa
  where FC.CodigoEmpresa = :pCodigoEmpresa
    and FC.CodigoFuncContr = :pCodigoFuncContr
    and (((Not Exists (Select 1
            From FuncContratoProf FCP
            Where FCP.DataInicial = (Select Max(FCPs.DataInicial)
                                    From FuncContratoProf FCPs
                                    Where FCPs.CodigoEmpresa = FC.CodigoEmpresa
                                      And FCPs.CodigoFuncContr = FC.CodigoFuncContr
                                      And FCPS.CodigoProfTipoAula = FCP.CodigoProfTipoAula
                                      And FCPs.DataInicial <= :pDataFinal)))
    or (Not Exists (Select 1
        From FuncSalarioProf FSP
        Where FSP.DataInicial = (Select Max(FSPs.DataInicial)
                                   from FuncSalarioProf FSPs
                                  where FSPs.CodigoEmpresa = FC.CodigoEmpresa
                                    and FSPs.CodigoFuncContr = FC.CodigoFuncContr
                                    and FSPs.codigoproftipoaula = FSP.codigoproftipoaula
                                    and FSPs.DataInicial <= :pDataFinal))))
      or (CEF.UtilCalcProf = '0'))
union
Select  FP.NomeFunc,
        FP.DataNasc,
        FC.DataAdm,
        FP.PisFunc,
        FP.Nacionalidade,
        FP.DataChegada,
        FP.GrauInstr,
        FP.CPFFunc,
		    FTD.UTILIZACARTEIRADIGITAL,
        FTD.NumeroCTPS,
        FTD.SerieCTPS,
        FC.TipoVinculo,
        FP.RacaCor,
        FC.PossuiAlvara,
        FP.Sexo,
        FC.DataDem,
        Cast((SalProf.ValorAula) as numeric(16,2)) ValorSal,
        case 
        when FSA.TipoSalario = 3 then 5
        else FSA.TipoSalario
        end TipoSalario,  
        Cast (FCP.HorasSem As Numeric(14,4)) HorasSem,
        C.CBO,
        TC.CodigoTabINSS,
        FC.ParticPat,
        Cast (FCP.CargaHorMensal As Numeric(14,4)) CargaHorMensal,
        FS.CodigoSind,
        FC.FormaCalculo,
        FS.Sindicalizado,
        FP.DefFisica,
        FP.DefVisual,
        FP.DefAuditiva,
        FP.DefMental,
        FP.DefIntelectual,
        FP.DefReabilitado,
        cast (1 As Integer) Professor,
        FC.CODIGOTIPOCONTR,
        FC.CATEGESOCIAL,
        FC.MatriculaeSocial,
        cast (0 As Integer) REGIMEJOR
   From FuncContrato FC
   Join FuncPessoa FP 
     on FP.CodigoFuncPessoa = FC.CodigoFuncPessoa
    Join (Select FCP.CodigoEmpresa,
                FCP.CodigoFuncContr,
                Sum((FCP.QtdeHoraDiurna + FCP.QtdeHoranoturna) /60) HorasSem,
                Sum(((FCP.QtdeHoraDiurna + FCP.QtdeHoranoturna) * (FCP.IndiceSemanal + FCP.IndiceDSR)) /60) CargaHorMensal
            From FuncContratoProf FCP
            Where FCP.DataInicial = (Select Max(FCPs.DataInicial)
                                    From FuncContratoProf FCPs
                                    Where FCPs.CodigoEmpresa = FCP.CodigoEmpresa
                                      And FCPs.CodigoFuncContr = FCP.CodigoFuncContr
                                      And FCPS.CodigoProfTipoAula = FCP.CodigoProfTipoAula
                                      And FCPs.DataInicial <= :pDataFinal)
             and (FCP.DataFinal is null
              or FCP.DataFinal >= :pDataFinal)

            Group By FCP.CodigoEmpresa,
                     FCP.CodigoFuncContr
           union
           Select FCP.CodigoEmpresa,
                  FCP.CodigoFuncContr,
                  sum((FCP.QtdeHoraDiurna + FCP.QtdeHoranoturna) /60) HorasSem,
                  sum(((FCP.QtdeHoraDiurna + FCP.QtdeHoranoturna) * (FCP.IndiceSemanal + FCP.IndiceDSR)) /60) CargaHorMensal
            from FuncContratoProf FCP
           where FCP.DataFinal = (select max(FCPs.Datafinal)
                                    from FuncContratoProf FCPs
                                   where FCPs.CodigoEmpresa = FCP.CodigoEmpresa
                                     and FCPs.CodigoFuncContr = FCP.CodigoFuncContr
                                     and FCPs.DataFinal between :pDataInicial and :pDataFinal)
            and not exists(select 1
                              from FuncContratoProf FCPD
                             where FCPD.codigoempresa = FCP.codigoempresa
                               and FCPD.codigofunccontr =  FCP.codigofunccontr
                               and (FCPD.DataFinal is null
                                 or FCPD.DataFinal >= :pDataFinal))

             Group By FCP.CodigoEmpresa,
                      FCP.CodigoFuncContr) FCP on FCP.CodigoEmpresa = FC.CodigoEmpresa
        And FCP.CodigoFuncContr = FC.CodigoFuncContr
    Join FuncSindicato FS on FS.CodigoEmpresa = FC.CodigoEmpresa
     And FS.CodigoFuncContr = FC.CodigoFuncContr
      And FS.DataInicial = (Select Max(FSs.DataInicial)
                              From FuncSindicato FSs
                             Where FSs.CodigoEmpresa = FC.CodigoEmpresa
                               And FSs.CodigofuncContr = FC.CodigofuncContr
                               And FSs.DataInicial <= :pDataFinal)


 Join (select CodigoEmpresa,
              CodigoFuncContr,
              sum(valoraula) valoraula 
       from  (select FCP.CodigoEmpresa,
              FCP.CodigoFuncContr,
              FSP.valoraula
         from FuncContratoProf FCP
         
         Join FuncSalarioProf FSP
           on FSP.CodigoEmpresa = FCP.CodigoEmpresa
          and FSP.CodigoFuncContr = FCP.CodigoFuncContr
          and FSP.codigoproftipoaula = FCP.CodigoProfTipoAula
         
        Join FuncSalario FSA 
           on FSA.CodigoEmpresa = FSP.CodigoEmpresa
          and FSA.CodigoFuncContr = FSP.CodigoFuncContr	 
          and FSA.DataInicial = FSP.DataInicial
          and FSA.SEQ = FSP.SEQFuncSalario		  
        where ((FSA.DataEfeito is not null
          and FSA.DataEfeito = (Select Max(FSs.DataEfeito)
                                  From FuncSalario FSs
                                 Where FSs.CodigoEmpresa = FSP.CodigoEmpresa
                                   And FSs.CodigoFuncContr = FSP.CodigoFuncContr
                                   And FSs.DataEfeito <= :pDataFinal)
                               
         and FSA.SEQ = (select max(FuB.SEQ)
                          from FuncSalario FuB
                         where FuB.DataInicial     = FSA.DataInicial
                           and FuB.CodigoEmpresa   = FSA.CodigoEmpresa 
                           and FuB.CodigoFuncContr = FSA.CodigoFuncContr)
                               
     
         and not exists(Select Max(FSs.DataInicial)
                          From FuncSalario FSs
                         Where FSs.CodigoEmpresa = FSA.CodigoEmpresa
                           And FSs.CodigoFuncContr = FSA.CodigoFuncContr
                           And FSs.DataInicial <= :pDataFinal
                        having Max(FSs.DataInicial) > FSA.DataEfeito) 
            )
            
            
        or (not exists(Select max(FSs.DataInicial)
                        from FuncSalario FSs
                       where FSs.CodigoEmpresa = FSA.CodigoEmpresa
                         and FSs.CodigoFuncContr = FSA.CodigoFuncContr
                      having max(FSs.DataInicial) <= FSA.DataEfeito) 
        and FSP.dataInicial = (Select max(FSPs.datainicial)
                                 from FuncSalarioProf FSPs
                                where FSPs.CodigoEmpresa = FCP.CodigoEmpresa
                                  and FSPs.CodigoFuncContr = FCP.CodigoFuncContr
                                  and FSPs.codigoproftipoaula = FCP.CodigoProfTipoAula
                                  and FSPs.DataInicial <= :pDataFinal)
                                             
        and FSP.SEQFuncSalario = (Select max(FSPs.SEQFuncSalario)
                                    from FuncSalarioProf FSPs
                                   where FSPs.CodigoEmpresa = FSP.CodigoEmpresa
                                     and FSPs.CodigoFuncContr = FSP.CodigoFuncContr
                                     and FSPs.codigoproftipoaula = FSP.CodigoProfTipoAula
                                     and FSPs.DataInicial = FSP.dataInicial)
            ) 
		) 
      and ((FCP.status = 1        
      and FCP.datafinal is null) 
      
        or (FCP.status in (4,6) 
       and not exists(select 1
                        from FuncContratoProf FSPSs
                       where FSPSs.CodigoEmpresa = FCP.CodigoEmpresa
                         and FSPSs.CodigoFuncContr = FCP.CodigoFuncContr
                         and FSPSs.Status = 1
                         and FSPSs.DataInicial <= :pDataFinal 
                         and (FSPSs.DataFinal >= :pDataInicial
                          or FSPSs.DataFinal is null) )
          )
         or (FCP.status in (2, 3, 5)
	    and FCP.DataInicial <= :pDataFinal
        and FCP.DataFinal > :pDataFinal)
         )  
          union  
          select FCP.codigoempresa,
                 FCP.codigofunccontr,
                 FSP.valoraula
            from FuncContratoProf FCP
            Join FuncSalarioProf FSP
              on FSP.CodigoEmpresa = FCP.CodigoEmpresa
             and FSP.CodigoFuncContr = FCP.CodigoFuncContr
             and FSP.codigoproftipoaula = FCP.CodigoProfTipoAula
            Join FuncSalario FSA 
	          on FSA.CodigoEmpresa = FSP.CodigoEmpresa
             and FSA.CodigoFuncContr = FSP.CodigoFuncContr	 
             and FSA.DataInicial = FSP.DataInicial
             and FSA.SEQ = FSP.SEQFuncSalario   
            where ((FSA.DataEfeito is not null
              and FSA.DataEfeito = (Select Max(FSs.DataEfeito)
                                  From FuncSalario FSs
                                 Where FSs.CodigoEmpresa = FSA.CodigoEmpresa
                                   And FSs.CodigoFuncContr = FSA.CodigoFuncContr
                                   And FSs.DataEfeito <= :pDataFinal)
                               
              and FSA.SEQ = (select max(FuB.SEQ)
                          from FuncSalario FuB
                         where FuB.DataEfeito      = FSA.DataEfeito
                           and FuB.CodigoEmpresa   = FSA.CodigoEmpresa 
                           and FuB.CodigoFuncContr = FSA.CodigoFuncContr)                               
                               
     
             and not exists(Select Max(FSs.DataInicial)
                          from FuncSalario FSs
                         where FSs.CodigoEmpresa = FSA.CodigoEmpresa
                           and FSs.CodigoFuncContr = FSA.CodigoFuncContr
                           and FSs.DataInicial <= :pDataFinal
                        having Max(FSs.DataInicial) > FSA.DataEfeito) 
              )
           or (FSP.dataInicial = (Select max(FSPs.datainicial)
                                      from FuncSalarioProf FSPs
                                      where FSPs.CodigoEmpresa = FCP.CodigoEmpresa
                                       and FSPs.CodigoFuncContr = FCP.CodigoFuncContr
                                       and FSPs.codigoproftipoaula = FCP.CodigoProfTipoAula
                                      and FSPs.DataInicial <= :pDataFinal)
                                             
            and FSP.SEQFuncSalario = (Select max(FSPs.SEQFuncSalario)
                                        from FuncSalarioProf FSPs
                                       where FSPs.CodigoEmpresa = FCP.CodigoEmpresa
                                         and FSPs.CodigoFuncContr = FCP.CodigoFuncContr
                                         and FSPs.codigoproftipoaula = FCP.CodigoProfTipoAula
                                        and FSPs.DataInicial = dataInicial)
            ) 
          ) 
       and FCP.datafinal = (select max(FCPs.Datafinal)
                                    from FuncContratoProf FCPs
                                   where FCPs.CodigoEmpresa = FCP.CodigoEmpresa
                                     and FCPs.CodigoFuncContr = FCP.CodigoFuncContr
                                     and FCPs.DataFinal <=:pDataFinal)
         and not exists(select 1
                          from FuncContratoProf FCPD
                         where FCPD.codigoempresa = FCP.codigoempresa
                           and FCPD.codigofunccontr =  FCP.codigofunccontr
                           and (FCPD.DataFinal is null
                            or FCPD.DataFinal > :pDataFinal))
           ) SalPro  
           Group by CodigoEmpresa,
                     codigofunccontr) SalProf   
     on  SalProf.CodigoEmpresa = FC.CodigoEmpresa
     and SalProf.CodigoFuncContr =  FC.codigofunccontr
     
  Join FuncSalario FSA 
    on FSA.CodigoEmpresa = FC.CodigoEmpresa
   and FSA.CodigoFuncContr = FC.CodigoFuncContr
   and ((FSA.DataEfeito is not null
   and FSA.DataEfeito = (Select Max(FSs.DataEfeito)
                             From FuncSalario FSs
                             Where FSs.CodigoEmpresa = FC.CodigoEmpresa
                               And FSs.CodigoFuncContr = FC.CodigoFuncContr
                               And FSs.DataEfeito <= :pDataFinal)
                               
     and FSA.SEQ = (select max(FuB.SEQ)
                              from FuncSalario FuB
                             where FuB.DataInicial     = FSA.DataInicial
                               and FuB.CodigoEmpresa   = FSA.CodigoEmpresa 
                               and FuB.CodigoFuncContr = FSA.CodigoFuncContr)                               
                               
     
      and not exists(Select Max(FSs.DataInicial)
                       from FuncSalario FSs
                      where FSs.CodigoEmpresa = FSA.CodigoEmpresa
                        and FSs.CodigoFuncContr = FSA.CodigoFuncContr
                        and FSs.DataInicial <= :pDataFinal
                     having Max(FSs.DataInicial) > FSA.DataEfeito) 
            )
               or (not exists(Select max(FSs.DataInicial)
                        from FuncSalario FSs
                       where FSs.CodigoEmpresa = FSA.CodigoEmpresa
                         and FSs.CodigoFuncContr = FSA.CodigoFuncContr
                      having max(FSs.DataInicial) <= FSA.DataEfeito) 
			   
			   and FSA.DataInicial = (Select Max(FSs.DataInicial)
                                            From FuncSalario FSs
                                           Where FSs.CodigoEmpresa = FC.CodigoEmpresa
                                             And FSs.CodigoFuncContr = FC.CodigoFuncContr
                                             And FSs.DataInicial <= :pDataFinal)
                                             
            and FSA.SEQ = (select max(FuB.SEQ)
                              from FuncSalario FuB
                             where FuB.DataInicial      = FSA.DataInicial
                               and FuB.CodigoEmpresa    = FSA.CodigoEmpresa 
                               and FuB.CodigoFuncContr  = FSA.CodigoFuncContr)
                ) 
            )  
    Join FuncCargo FCA on FCA.CodigoEmpresa = FC.CodigoEmpresa
        And FCA.CodigoFuncContr = FC.CodigoFuncContr
        And FCA.DataInicial = (Select Max(FCs.DataInicial)
                                From FuncCargo FCs
                                Where FCs.CodigoEmpresa = FC.CodigoEmpresa
                                    And FCs.CodigoFuncContr = FC.CodigoFuncContr
                                    And FCs.DataInicial <= :pDataFinal)
    Join Cargo C on C.CodigoCargo = FCA.CodigoCargo
    LEFT JOIN (SELECT FTD.CODIGOEMPRESA,
                      FTD.CODIGOFUNCCONTR, 
                  MAX(FTD.DATAINICIAL) DATAINICIAL 
            FROM FUNCCTPS FTD 
            GROUP BY FTD.CODIGOEMPRESA, FTD.CODIGOFUNCCONTR) FCTD 
              ON FCTD.CODIGOEMPRESA = FC.CODIGOEMPRESA 
             AND FCTD.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR 
    LEFT JOIN FUNCCTPS FTD 
              ON FTD.CODIGOEMPRESA = FC.CODIGOEMPRESA 
             AND FTD.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR 
             AND FTD.DATAINICIAL = FCTD.DATAINICIAL
    Join TipoContrato TC on TC.CodigoTipoContr = FC.CodigoTipoContr
    Join CFGEmpresaFPA CEF on CEF.CodigoEmpresa = FC.CodigoEmpresa
        And CEF.UtilCalcProf = '1'
where FC.CodigoEmpresa = :pCodigoEmpresa
  and FC.CodigoFuncContr = :pCodigoFuncContr 
Order by 1