  select ic.CodigoEmpresa ,
         ic.CodigoINSSComp,
         ic.CodigoEstab,
         ic.ClassifOrgan,
         ic.CodigoOutEmp,
         ic.Compet,
         Ic.CompetCorrecao,
         ic.PercCompens,         
         ic.ValorOrig,
		 ic.FormaCorrecao
    from InssComp ic
    join CfgEmpresaFpa cfg
      on cfg.codigoEmpresa = IC.CodigoEmpresa
  left join(select MAX(DM.ORDEM) ORDEM,
                       DM.CODIGOEMPRESA,
                       DM.CODIGOINSSCOMP,
                       DM.COMPETCOMP
             from INSSCOMPDET DM
            where DM.CodigoEmpresa = :CodigoEmpresa
             and DM.CompetComp <= :Compet  
  group by DM.CODIGOEMPRESA,
           DM.CODIGOINSSCOMP,
           DM.COMPETCOMP)ICM
   on ICM.CodigoEmpresa   = ic.CodigoEmpresa
  and ICM.CodigoINSSComp  = IC.CodigoINSSComp
  and ICM.CompetComp = IC.Compet
  
  left join INSSCOMPDET ICD        
   on ICD.CodigoEmpresa   = ICM.CodigoEmpresa
  and ICD.CodigoINSSComp  = ICM.CodigoINSSComp      
  and ICD.Ordem           = ICM.Ordem
  and ICD.CompetComp      = ICM.CompetComp
  
        	
   where ic.CodigoEmpresa = :CodigoEmpresa
     and ic.CompetCorrecao <= Cast(:Compet as Date)
     and ic.ValorOrig > 0
     and ic.CompensRealiz = '0'
     and IC.Compet >= cfg.DataCompensacaoCruzada
   and not exists(select 1 
                    from  INSSCOMPDET D        
                   where D.CodigoEmpresa   = IC.CodigoEmpresa
                     and D.CodigoINSSComp  = IC.CodigoINSSComp      
                     and D.CompetComp      = Cast(:Compet as Date))
    and not exists(select 1 
                    from  INSSCOMPDET D        
                   where D.CodigoEmpresa   = IC.CodigoEmpresa
                     and D.CodigoINSSComp  = IC.CodigoINSSComp
                     and D.VALORTOTAL = 0)					 
   
order by 1, 2, 3, 4, 5, 6 