select sum(D.ValorSegurado) ValorSegurado
     , sum(D.ValorEmpresa) ValorEmpresa
     , sum(D.ValorTerceiro) ValorTerceiro
     , sum(D.ValorDeducao) ValorDeducao
     , sum(D.ValorCompensacaoMObra) CompensacaoMObra
     , sum(D.ValorCompensacao) Compensacao
  from DebitoGPS D
 where exists (select 1
                 from DebitoGPS D1
            left join Organograma O
                   on O.ClassifOrgan = D1.ClassifOrgan
            left join GPS G
                   on G.CodigoEmpresa = O.CodigoEmpresa
                  and G.CodigoTabGPS = O.CodigoTabGPS
                where cast(D.ChaveAcum as integer) = D1.ChaveDebitoGPS
                  and D1.CodigoEmpresa = :pCodigoEmpresa
                  and D1.CodigoEstab = :pCodigoEstab
                  and D1.DataLctoCtr = :pCompet
                  and D1.TipoGPS between :pTipoIni and :pTipoFin
                  and D1.CodigoOutEmp is null
                  and ((:pTipoRecol = 1 and D1.CodigoImposto not in (2607,2704,2437,2500,2011))
                   or  (:pTipoRecol = 2 and D1.CodigoImposto in (2607,2704,2437,2011))
                   or  (:pTipoRecol = 3 and D1.CodigoImposto = 2500))
                  and G.CodigoFpas  = :pCodigoFpas
                  and G.DataInicial = (select max(gps2.DataInicial)
                                         from GPS gps2
                                        where gps2.CodigoEmpresa = o.CodigoEmpresa
                                          and gps2.CodigoTabGPS = o.CodigoTabGPS
                                          and gps2.DataInicial < :pMesSeg)
               )    
   and (D.DataLctoCtr < :pCompet 
    or (D.DataLctoCtr = :pCompet 
   and D.TipoGPS = 2
   and D.TipoGPS<>:pTipoFin))
order by 1               