select pc.Compet,
       cast(sum(ic.Remuneracao) as numeric(18,2)) Remuneracao
  from PeriodoCalculo pc,
       ImpostoCalculo ic
 where pc.CodigoEmpresa = :pCodigoEmpresa
   and pc.Compet between :pDataInicial and :pDataFinal
   and pc.CodigoTipoCalc between 1 and 6
   and ic.CodigoEmpresa = pc.CodigoEmpresa
   and ic.CodigoFuncContr = :pCodigoFuncContr
   and ic.CodigoPerCalculo = pc.CodigoPerCalculo
   and ic.ComProcesso = '1'
 group by pc.Compet
having (sum(ic.Remuneracao) > 0)
order by 1
