select cast(sum(I.BaseFGTSNorm) as numeric(18,2)) BaseFGTSNorm,
       cast(sum(I.BaseFGTS13) as numeric(18,2)) BaseFGTS13,
       cast(sum(I.BasePISNorm) as numeric(18,2)) BasePISNorm,
       cast(sum(I.BasePIS13) as numeric(18,2)) BasePIS13,
       cast(sum(I.BaseINSSEmp) as numeric(18,2)) BaseINSSEmp,
       cast(sum(I.BaseINSS13Emp) as numeric(18,2)) BaseINSS13Emp,
       cast(sum(I.BaseINSSFunc) as numeric(18,2)) BaseINSSFunc,
       cast(sum(I.BaseINSS13Func) as numeric(18,2)) BaseINSS13Func,
       cast(sum(I.ValorFgts13) as numeric(18,2)) ValorFgts13,
       cast(sum(I.ValorFgtsNorm) as numeric(18,2)) ValorFgtsNorm,
       cast(sum(I.ValorPISNorm) as numeric(18,2)) ValorPISNorm,
       cast(sum(I.ValorPIS13) as numeric(18,2)) ValorPIS13,
       cast(sum(I.ValorAdicFGTSNorm) as numeric(18,2)) ValorAdicFGTSNorm,
       cast(sum(I.ValorAdicFGTS13) as numeric(18,2)) ValorAdicFGTS13,
       cast(sum(I.AcresSat) as numeric(18,2)) AcresSat,
       cast(sum(I.INSSEntFinanc) as numeric(18,2)) INSSEntFinanc,
       cast(sum(I.INSSParteSat + I.AcresFAP) as numeric(18,2)) INSSParteSat,
       cast(sum(I.INSSDirAuton)as numeric(18,2)) INSSDirAuton,
       cast(sum(I.AcresFAP)as numeric(18,2)) INSSAcresFAP,
       I.CodigoEmpresa
  from  ImpostoCalculo I
        LEFT OUTER JOIN OutraEmpEmp OEE
                     ON I.CodigoEmpresa = OEE.CodigoEmpresa
                    and I.CodigoOutEmp = OEE.CodigoOutEmp
 where I.CodigoEmpresa = :pCodigoEmpresa
   and I.CodigoPerCalculo = :pCodigoPerCalculo
   and I.CodigoFuncContr = :pCodigoFuncContr
   and (OEE.PossuiGPS = '0'
    or I.CodigoOutEmp is null)
   and I.ClassifOrgan is null
   and I.ComProcesso = '1'
group by I.CodigoEmpresa
order by 1
