  select fpc.DataPgtoFolha DataPgto,
         e.LocalInformeDirf,
         e.CodigoEstrut,
         sum(ce.ValorEvento * e.FormaInformeDirf) Valor
    from FuncContrato f,
         FuncPerCalculo fpc,
         CalculoEvento ce,
         Evento e,
         PeriodoCalculo pc
    join FuncPessoa FP
      on FP.CodigoFuncPessoa = F.CodigoFuncPessoa    
   where f.CodigoEmpresa      = :pCodigoEmpresa
     and fp.CPFFunc            = :pCPFFunc
     and f.CodigoEmpresa      = fpc.CodigoEmpresa
     and f.CodigoFuncContr         = fpc.CodigoFuncContr
     and fpc.DataPgtoFolha between :pCompetIni and :pCompetFin
     and fpc.CodigoEmpresa    = ce.CodigoEmpresa
     and fpc.CodigoPerCalculo = ce.CodigoPerCalculo
     and fpc.CodigoFuncContr       = ce.CodigoFuncContr
     and ce.CodigoEvento      = e.CodigoEvento
     and e.OrigemDadoDirf     = 1
     and e.LocalInformeDirf   <> 0
     and e.FormaInformeDirf   <> 0
     and PC.CodigoEmpresa = FPC.CodigoEmpresa
     and PC.CodigoPerCalculo = FPC.CodigoPerCalculo
     and PC.DataFinalFolha >= FPC.DataLocal
group by fpc.DataPgtoFolha,
         e.LocalInformeDirf,
         e.CodigoEstrut
union all
  select rf.DataPgto DataPgto,
         e.LocalInformeDirf,
         e.CodigoEstrut,
         sum(fe.ValorEvento * e.FormaInformeDirf) Valor
      from FuncContrato f,
           ReciboFerias rf,
           FeriasEvento fe,
           Evento e
      join FuncPessoa FP
        on FP.CodigoFuncPessoa = F.CodigoFuncPessoa      
     where f.CodigoEmpresa     = :pCodigoEmpresa
       and fp.CPFFunc           = :pCPFFunc
       and f.CodigoFuncContr        = rf.CodigoFuncContr
       and f.CodigoEmpresa     = rf.CodigoEmpresa
       and rf.DataPgto  between :pCompetIni and :pCompetFin
       and rf.CodigoEmpresa    = fe.CodigoEmpresa
       and rf.CodigoFuncContr       = fe.CodigoFuncContr
       and rf.DataInicial      = fe.DataInicial
       and rf.DataInicialFerias= fe.DataInicialFerias
	   and rf.SeqReciboFerias = fe.SeqReciboFerias
       and rf.TipoRecibo <> 3
       and fe.CodigoEvento     = e.CodigoEvento
       and e.OrigemDadoDirf   = 2
       and e.LocalInformeDirf <> 0
       and e.FormaInformeDirf <> 0
       and (rf.DataPgto >= f.DataTransfEmp
        or f.DataTransfEmp is null)
  group by rf.DataPgto,
           e.LocalInformeDirf,
           e.CodigoEstrut
union all
  select r.DataPgtoResc DataPgto,
         e.LocalInformeDirf,
         e.CodigoEstrut,
         sum(re.ValorEvento * e.FormaInformeDirf) Valor
    from FuncContrato f,
         Rescisao r,
         RescisaoEvento re,
         Evento e
    join FuncPessoa FP
      on FP.CodigoFuncPessoa = F.CodigoFuncPessoa    
   where f.CodigoEmpresa      =  :pCodigoEmpresa
     and fp.CPFFunc            =  :pCPFFunc
     and f.CodigoFuncContr         =  r.CodigoFuncContr
     and f.CodigoEmpresa      =  r.CodigoEmpresa
     and r.DataPgtoResc between  :pCompetIni and :pCompetFin
     and r.CodigoEmpresa      =  re.CodigoEmpresa
     and r.CodigoFuncContr         =  re.CodigoFuncContr
     and r.Complementar       =  re.Complementar
     and re.CodigoEvento      =  e.CodigoEvento
     and e.OrigemDadoDirf     =  1
     and e.LocalInformeDirf   <> 0
     and e.FormaInformeDirf   <> 0
group by r.DataPgtoResc,
         e.LocalInformeDirf,
         e.CodigoEstrut
order by 1, 2, 3
